/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.xmlstream;

import com.sonicsw.xq.service.xcbr.xmlstream.OutputXML;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLInvalidNamespaceException;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLInvalidTagNameException;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLOutputStream;

public class XMLTagName
implements OutputXML {
    private String _namespace;
    private String _tagname;

    public XMLTagName(String aNamespace, String aTagName) throws XMLInvalidTagNameException, XMLInvalidNamespaceException {
        this(aTagName);
        if (aNamespace != null) {
            if (XMLTagName.isValidXMLNamespaceName(aNamespace)) {
                this._namespace = aNamespace;
            } else {
                throw new XMLInvalidNamespaceException();
            }
        }
    }

    public XMLTagName(String aTagName) throws XMLInvalidTagNameException {
        if (!XMLTagName.isValidXMLTagName(aTagName)) {
            throw new XMLInvalidTagNameException();
        }
        this._tagname = aTagName;
    }

    @Override
    public void print(XMLOutputStream aStream) {
        aStream.add("</");
        if (this._namespace != null) {
            aStream.add(this._namespace + ":");
        }
        aStream.add(this._tagname + ">");
    }

    protected boolean isNamespaceDefined() {
        return this._namespace != null;
    }

    protected String getNamespace() {
        return this._namespace;
    }

    protected String getTagName() {
        return this._namespace;
    }

    public static boolean isValidXMLTagName(String aName) {
        return aName != null && aName.indexOf(32) == -1 && aName.indexOf(58) == -1;
    }

    public static boolean isValidXMLNamespaceName(String aName) {
        return aName == null || aName.indexOf(32) == -1 && aName.indexOf(58) == -1;
    }
}

