/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.envelope;

import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQMessage;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Envelope
implements XQEnvelope {
    private static final long serialVersionUID = 252112099054337814L;
    private XQMessage m_message;
    private HashSet<XQAddress> m_addresses = new HashSet(4);

    public void setMessage(XQMessage message) {
        this.m_message = message;
    }

    public XQMessage getMessage() {
        return this.m_message;
    }

    public void addAddress(XQAddress address) {
        if (address != null) {
            this.m_addresses.add(address);
        }
    }

    public void addAddresses(List<XQAddress> addresses) {
        for (XQAddress address : addresses) {
            this.m_addresses.add(address);
        }
    }

    public Iterator<XQAddress> getAddresses() {
        return this.m_addresses.iterator();
    }

    public void clearAddresses() {
        this.m_addresses.clear();
    }

    public synchronized void removeAddress(XQAddress address) {
        for (XQAddress addr : this.m_addresses) {
            if (!addr.equals(address)) continue;
            this.m_addresses.remove(addr);
            break;
        }
    }

    public Object clone() {
        try {
            Envelope clone = (Envelope)super.clone();
            clone.m_addresses = (HashSet)this.m_addresses.clone();
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError();
        }
    }

    public String toString() {
        return "Envelope to " + this.m_addresses.toString();
    }

    public String getStringRepresentation() {
        return "Envelope (" + this.m_addresses + "," + this.m_message + ")";
    }
}

