/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap;

import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.ESBWSIFJMSDestination;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.Hashtable;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.transport.http.HTTPSender;

public class DirectHTTPSender
extends HTTPSender {
    private static XQLog log = XQLogImpl.getCategoryLog((int)32);

    public void invoke(MessageContext msgContext) throws AxisFault {
        boolean logRawRequest = false;
        boolean waitForResponse = false;
        boolean forceRequestResponse = false;
        String authUser = null;
        String authPassword = null;
        Long httpRequestTimeout = null;
        ESBWSIFJMSDestination dest = (ESBWSIFJMSDestination)msgContext.getProperty("Destination");
        authUser = (String)dest.inProps.get("X-HTTP-AuthUser");
        authPassword = (String)dest.inProps.get("X-HTTP-AuthPassword");
        Object o = dest.inProps.get("X-HTTP-RequestTimeout");
        if (o != null && o instanceof Long) {
            httpRequestTimeout = (Long)dest.inProps.get("X-HTTP-RequestTimeout");
        } else if (o != null && o instanceof Integer) {
            httpRequestTimeout = new Long(((Integer)dest.inProps.get("X-HTTP-RequestTimeout")).intValue());
        } else if (o instanceof String) {
            try {
                httpRequestTimeout = Long.valueOf((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (msgContext.containsProperty("com_sonicsw_xqimpl_invk_ESBConstants_LogRawRequest")) {
            logRawRequest = (Boolean)msgContext.getProperty("com_sonicsw_xqimpl_invk_ESBConstants_LogRawRequest");
        }
        if (msgContext.containsProperty("IsSyncRequestReply")) {
            waitForResponse = (Boolean)msgContext.getProperty("IsSyncRequestReply");
        }
        if (msgContext.containsProperty("com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_FORCE_REQUEST_RESPONSE_OP")) {
            forceRequestResponse = (Boolean)msgContext.getProperty("com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_FORCE_REQUEST_RESPONSE_OP");
        }
        if (logRawRequest) {
            log.logInformation("Raw SOAP Request:" + msgContext.getRequestMessage().getSOAPPartAsString());
        }
        if (httpRequestTimeout != null) {
            msgContext.setTimeout(httpRequestTimeout.intValue() * 1000);
        }
        msgContext.setUsername(authUser);
        msgContext.setPassword(authPassword);
        msgContext.setMaintainSession(true);
        msgContext.setProperty("axis.transport.version", (Object)HTTPConstants.HEADER_PROTOCOL_V11);
        msgContext.setProperty("transport.url", (Object)dest.getLocationURL());
        Hashtable userHeaderTable = new Hashtable();
        msgContext.setProperty("HTTP-Request-Headers", userHeaderTable);
        String soapAction = msgContext.getSOAPActionURI();
        if (soapAction != null & soapAction.length() >= 2 && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
            msgContext.setSOAPActionURI(soapAction.substring(1, soapAction.length() - 1));
        }
        super.invoke(msgContext);
        if (!waitForResponse) {
            msgContext.setResponseMessage(null);
            return;
        }
        if (forceRequestResponse && msgContext.getResponseMessage() != null && msgContext.getResponseMessage().getContentLength() == 0L) {
            msgContext.setResponseMessage(null);
            return;
        }
        if (logRawRequest) {
            log.logInformation("Raw SOAP Response:" + msgContext.getResponseMessage().getSOAPPartAsString());
        }
    }

    boolean delegatesToDirectSender(MessageContext msgContext) {
        Integer providerOption = (Integer)msgContext.getProperty("com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_HTTP_PROVIDER");
        if (providerOption == null || providerOption == 1) {
            return false;
        }
        ESBWSIFJMSDestination dest = (ESBWSIFJMSDestination)msgContext.getProperty("Destination");
        if (dest.getESBWSType() != 0) {
            return false;
        }
        if (!dest.getLocationURL().startsWith("http://")) {
            return false;
        }
        if (dest.assertAsyncResponse()) {
            return false;
        }
        String wsPolicy = dest.getPolicy();
        String wsResponsePolicy = dest.getResponsePolicy();
        String wsFaultPolicy = dest.getFaultPolicy();
        return wsPolicy == null && wsResponsePolicy == null && wsFaultPolicy == null;
    }
}

