/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap;

import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.ESBJmsSender;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.ESBJmsTransport;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.ESBWSIFJMSDestination;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.ESBWSIFOperation_ApacheAxis;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.BaseWsifPort;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.Constants;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.GeneralWSInvocationException;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.rpc.JAXRPCException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.client.Transport;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.util.WSIFUtils;

public class ESBWSIFPort_ApacheAxis
extends BaseWsifPort {
    protected SOAPBinding soapBinding;
    protected SOAPAddress soapAddress;
    protected String endPointURL;
    protected transient Transport transport;
    protected transient Call call;
    private static XQLog log = XQLogImpl.getCategoryLog((int)32);

    public ESBWSIFPort_ApacheAxis(Definition definition, Port port, SOAPBinding soapBinding, WSIFDynamicTypeMap wsifdynamictypemap) throws WSIFException {
        super(definition, port, wsifdynamictypemap);
        this.soapBinding = soapBinding;
        this.parseServiceAddress();
        this.parseSoapBinding();
    }

    private void parseSoapBinding() throws WSIFException {
        this.bindingStyle = this.soapBinding.getStyle();
        if (this.bindingStyle == null || this.bindingStyle.length() < 1) {
            this.bindingStyle = "document";
        } else if (!Constants.VALID_STYLES.contains(this.bindingStyle)) {
            Object[] arguments = new Object[]{this.bindingStyle, this.soapBinding};
            throw new GeneralWSInvocationException("unsupported-style", arguments);
        }
        String transportURI = this.soapBinding.getTransportURI();
        if (!Constants.VALID_TRANSPORTS.contains(transportURI)) {
            Object[] arguments = new Object[]{transportURI, this.soapBinding};
            throw new GeneralWSInvocationException("unsupported-transport", arguments);
        }
    }

    @Override
    protected final void parseServiceAddress() throws WSIFException {
        this.soapAddress = (SOAPAddress)this.getExtElem(this.port, SOAPAddress.class, this.port.getExtensibilityElements());
        if (this.soapAddress == null) {
            if (this.isTransportHTTP()) {
                Object[] arguments = new Object[]{"http://schemas.xmlsoap.org/soap/http", this.port};
                throw new GeneralWSInvocationException("transport-requires-soap-address", arguments);
            }
            super.parseServiceAddress();
        } else {
            if (this.isTransportJMS()) {
                Object[] arguments = new Object[]{"http://schemas.xmlsoap.org/soap/jms", this.port};
                throw new GeneralWSInvocationException("transport-requires-esb-address", arguments);
            }
            String s = this.soapAddress.getLocationURI();
            if (s == null || s.trim().length() == 0) {
                throw new GeneralWSInvocationException("soap-address-with-location-uri-required", new Object[]{this.port});
            }
            this.endPointURL = s;
        }
    }

    public void close() throws WSIFException {
        if (this.transport != null && this.transport instanceof ESBJmsTransport) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            try {
                ((ESBJmsTransport)this.transport).close();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
    }

    public Transport getAxisTransport() throws WSIFException {
        Transport t = this.getTransport();
        return t;
    }

    public Call getCall() throws WSIFException {
        if (this.call == null) {
            this.call = this.makeNewAXISCall();
        }
        return this.call;
    }

    private Call makeNewAXISCall() throws WSIFException {
        Call c = null;
        try {
            SimpleProvider sp = new SimpleProvider();
            sp.deployTransport("esb", (Handler)new ESBJmsSender());
            c = new Call(new Service((EngineConfiguration)sp));
            c.setMaintainSession(true);
        }
        catch (JAXRPCException e) {
            throw new GeneralWSInvocationException("exception-creating-call-object", new Object[]{e.getLocalizedMessage()});
        }
        return c;
    }

    @Override
    public WSIFOperation getConcreteWSIFOperation(String opName, String inputName, String outputName) throws WSIFException {
        BindingOperation bop = WSIFUtils.getBindingOperation((Binding)this.port.getBinding(), (String)opName, (String)inputName, (String)outputName);
        if (bop == null) {
            throw new GeneralWSInvocationException("operation-not-found", new Object[]{opName, inputName, outputName});
        }
        return new ESBWSIFOperation_ApacheAxis(this, bop, this.wsifdynamictypemap);
    }

    public String getEndPoint() {
        return this.endPointURL;
    }

    public SOAPOperation getSOAPOperation(BindingOperation bindingOp) throws WSIFException {
        SOAPOperation soapOperation = (SOAPOperation)this.getExtElem(bindingOp, SOAPOperation.class, bindingOp.getExtensibilityElements());
        if (soapOperation == null) {
            throw new GeneralWSInvocationException("soap-operation-not-found", new Object[]{bindingOp});
        }
        return soapOperation;
    }

    public Transport getTransport(String urlParam) throws WSIFException {
        String url = urlParam;
        log.logDebug("ESBWSIFPort_ApacheAxis.getTransport: supplied url=" + url);
        if (this.transport == null) {
            String transportURI = this.soapBinding.getTransportURI();
            log.logDebug("ESBWSIFPort_ApacheAxis.getTransport: transportURI=" + transportURI);
            if (url == null && this.soapAddress != null) {
                url = this.soapAddress.getLocationURI();
            }
            log.logDebug("ESBWSIFPort_ApacheAxis.getTransport: destination URL=" + url);
            if ("http://schemas.xmlsoap.org/soap/http".equals(transportURI) || "http://schemas.xmlsoap.org/ws/soap/duplex".equals(transportURI)) {
                ESBWSIFJMSDestination jmsDestination = new ESBWSIFJMSDestination(url);
                this.transport = new ESBJmsTransport(jmsDestination);
            } else if ("http://schemas.xmlsoap.org/soap/jms".equals(transportURI)) {
                ESBWSIFJMSDestination jmsDestination = new ESBWSIFJMSDestination(this.esbJmsAddress.getLocation());
                this.transport = new ESBJmsTransport(jmsDestination);
            } else {
                throw new GeneralWSInvocationException("transport-not-supported", new Object[]{transportURI});
            }
        }
        return this.transport;
    }

    public Transport getTransport() throws WSIFException {
        return this.getTransport(null);
    }

    public boolean isTransportHTTP() {
        String transportURI = this.soapBinding.getTransportURI();
        boolean httpTransport = "http://schemas.xmlsoap.org/soap/http".equals(transportURI) || "http://schemas.xmlsoap.org/ws/soap/duplex".equals(transportURI);
        return httpTransport;
    }

    public boolean isTransportJMS() {
        String transportURI = this.soapBinding.getTransportURI();
        boolean jmsTransport = "http://schemas.xmlsoap.org/soap/jms".equals(transportURI);
        return jmsTransport;
    }
}

