/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.xqimpl.script.IParameterValue;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlAnyURI;
import org.apache.xmlbeans.XmlBase64Binary;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlBoolean;
import org.apache.xmlbeans.XmlByte;
import org.apache.xmlbeans.XmlCalendar;
import org.apache.xmlbeans.XmlDate;
import org.apache.xmlbeans.XmlDateTime;
import org.apache.xmlbeans.XmlDecimal;
import org.apache.xmlbeans.XmlDouble;
import org.apache.xmlbeans.XmlDuration;
import org.apache.xmlbeans.XmlENTITIES;
import org.apache.xmlbeans.XmlENTITY;
import org.apache.xmlbeans.XmlFloat;
import org.apache.xmlbeans.XmlGDay;
import org.apache.xmlbeans.XmlGMonth;
import org.apache.xmlbeans.XmlGMonthDay;
import org.apache.xmlbeans.XmlGYear;
import org.apache.xmlbeans.XmlGYearMonth;
import org.apache.xmlbeans.XmlHexBinary;
import org.apache.xmlbeans.XmlID;
import org.apache.xmlbeans.XmlIDREF;
import org.apache.xmlbeans.XmlIDREFS;
import org.apache.xmlbeans.XmlInt;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlLanguage;
import org.apache.xmlbeans.XmlLong;
import org.apache.xmlbeans.XmlNCName;
import org.apache.xmlbeans.XmlNMTOKEN;
import org.apache.xmlbeans.XmlNMTOKENS;
import org.apache.xmlbeans.XmlNOTATION;
import org.apache.xmlbeans.XmlName;
import org.apache.xmlbeans.XmlNegativeInteger;
import org.apache.xmlbeans.XmlNonNegativeInteger;
import org.apache.xmlbeans.XmlNonPositiveInteger;
import org.apache.xmlbeans.XmlNormalizedString;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlPositiveInteger;
import org.apache.xmlbeans.XmlQName;
import org.apache.xmlbeans.XmlShort;
import org.apache.xmlbeans.XmlString;
import org.apache.xmlbeans.XmlTime;
import org.apache.xmlbeans.XmlToken;
import org.apache.xmlbeans.XmlUnsignedByte;
import org.apache.xmlbeans.XmlUnsignedInt;
import org.apache.xmlbeans.XmlUnsignedLong;
import org.apache.xmlbeans.XmlUnsignedShort;

public class XMLTypeUtils {
    private static final String XML_SCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    private static SchemaTypeLoader m_defaultTypeLoader;
    public static final byte DOUBLE = 0;
    public static final byte FLOAT = 1;
    public static final byte INTEGER = 2;
    public static final byte BOOLEAN = 3;
    public static final byte LONG = 4;
    public static final byte SHORT = 5;
    public static final byte STRING = 6;
    public static final byte BYTE = 7;
    public static final byte BYTE_ARRAY = 8;
    public static final byte CALENDAR = 9;
    public static final byte QNAME = 10;
    public static final byte URI = 11;
    public static final byte BIGDECIMAL = 12;
    public static final byte BIGINTEGER = 13;
    public static final byte ELEMENT = 14;
    public static final byte LIST = 15;
    public static final byte UNKNOWN = 16;
    private static Object m_syncObj;

    public static boolean isBase64Encoded(String primitiveType) throws ScriptEngineException {
        String typeName = XMLTypeUtils.getTypeName(primitiveType);
        SchemaType type = XMLTypeUtils.findType(typeName);
        if (type == null) {
            throw new ScriptEngineException("unknown-xml-schema-base-type", new Object[]{typeName}, 2);
        }
        return type.getBuiltinTypeCode() == 4;
    }

    public static boolean isAnyType(String primitiveType) throws ScriptEngineException {
        String typeName = XMLTypeUtils.getTypeName(primitiveType);
        SchemaType type = XMLTypeUtils.findType(typeName);
        if (type == null) {
            return false;
        }
        return type.getBuiltinTypeCode() == 1;
    }

    public static boolean isHexEncoded(String primitiveType) throws ScriptEngineException {
        String typeName = XMLTypeUtils.getTypeName(primitiveType);
        SchemaType type = XMLTypeUtils.findType(typeName);
        if (type == null) {
            throw new ScriptEngineException("unknown-xml-schema-base-type", new Object[]{typeName}, 2);
        }
        return type.getBuiltinTypeCode() == 5;
    }

    public static int getJavaType(String primitiveType) throws ScriptEngineException {
        String typeName = XMLTypeUtils.getTypeName(primitiveType);
        if ("anyType".equals(typeName)) {
            return 14;
        }
        SchemaType type = XMLTypeUtils.findType(typeName);
        if (type == null) {
            throw new ScriptEngineException("unknown-type", new Object[]{primitiveType}, 2);
        }
        switch (type.getBuiltinTypeCode()) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return 9;
            }
            case 7: {
                return 10;
            }
            case 6: {
                return 11;
            }
            case 10: {
                return 0;
            }
            case 9: {
                return 1;
            }
            case 4: 
            case 5: {
                return 8;
            }
            case 3: {
                return 3;
            }
            case 8: 
            case 12: 
            case 13: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 45: {
                return 6;
            }
            case 11: {
                return 12;
            }
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return 13;
            }
            case 23: {
                return 4;
            }
            case 24: {
                return 2;
            }
            case 25: {
                return 5;
            }
            case 26: {
                return 7;
            }
            case 33: {
                return 2;
            }
            case 34: {
                return 5;
            }
            case 42: 
            case 44: 
            case 46: {
                return 15;
            }
        }
        return 16;
    }

    public static Object getJavaObject(IParameterValue value) throws ScriptEngineException {
        return XMLTypeUtils.getJavaObject(value, false);
    }

    public static void validateParameterValue(IParameterValue value) throws ScriptEngineException {
        XMLTypeUtils.getJavaObject(value, true);
    }

    private static Object getJavaObject(IParameterValue value, boolean validateOnly) throws ScriptEngineException {
        String primitiveType = value.getBaseType();
        String typeName = XMLTypeUtils.getTypeName(primitiveType);
        if ("anyType".equals(typeName)) {
            return null;
        }
        SchemaType type = XMLTypeUtils.findType(typeName);
        if (type == null) {
            throw new ScriptEngineException("unknown-type", new Object[]{primitiveType}, 2);
        }
        switch (type.getBuiltinTypeCode()) {
            case 14: {
                XmlDateTime dateTimeValue = XmlDateTime.Factory.newInstance();
                dateTimeValue.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)dateTimeValue, value);
                if (validateOnly) break;
                return dateTimeValue.getCalendarValue();
            }
            case 7: {
                XmlQName qname = XmlQName.Factory.newInstance();
                String stringValue = value.getAsString();
                String prefix = XMLTypeUtils.getTypePrefix(stringValue);
                String localPart = XMLTypeUtils.getTypeName(stringValue);
                if (prefix != null) {
                    String uri = value.getNamespaceURI(prefix);
                    if (uri == null) {
                        qname.setStringValue(stringValue);
                    } else {
                        QName newQname = new QName(uri, localPart, prefix);
                        qname.setQNameValue(newQname);
                    }
                } else {
                    qname.setStringValue(stringValue);
                }
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)qname, value);
                if (validateOnly) break;
                return qname.getQNameValue();
            }
            case 6: {
                XmlAnyURI uri = XmlAnyURI.Factory.newInstance();
                if (validateOnly) break;
                return XMLTypeUtils.returnStringResult((XmlAnySimpleType)uri, value, validateOnly);
            }
            case 10: {
                XmlDouble doubleValue = XmlDouble.Factory.newInstance();
                doubleValue.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)doubleValue, value);
                if (validateOnly) break;
                return new Double(doubleValue.getDoubleValue());
            }
            case 9: {
                XmlFloat floatValue = XmlFloat.Factory.newInstance();
                floatValue.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)floatValue, value);
                if (validateOnly) break;
                return new Float(floatValue.getFloatValue());
            }
            case 4: 
            case 5: {
                if (!value.isByteArray()) {
                    throw new ScriptEngineException("parameter-not-byte-array", 2);
                }
                if (validateOnly) break;
                return value.getAsByteArray();
            }
            case 3: {
                XmlBoolean booleanValue = XmlBoolean.Factory.newInstance();
                booleanValue.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)booleanValue, value);
                if (validateOnly) break;
                return new Boolean(booleanValue.getBooleanValue());
            }
            case 12: {
                XmlString string = XmlString.Factory.newInstance();
                return XMLTypeUtils.returnStringResult((XmlAnySimpleType)string, value, validateOnly);
            }
            case 35: {
                XmlNormalizedString string = XmlNormalizedString.Factory.newInstance();
                return XMLTypeUtils.returnStringResult((XmlAnySimpleType)string, value, validateOnly);
            }
            case 11: {
                XmlDecimal decimal = XmlDecimal.Factory.newInstance();
                decimal.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)decimal, value);
                if (validateOnly) break;
                return decimal.getBigDecimalValue();
            }
            case 22: {
                XmlInteger integer = XmlInteger.Factory.newInstance();
                integer.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)integer, value);
                if (validateOnly) break;
                return integer.getBigIntegerValue();
            }
            case 27: {
                XmlNonPositiveInteger integer = XmlNonPositiveInteger.Factory.newInstance();
                integer.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)integer, value);
                if (validateOnly) break;
                return integer.getBigIntegerValue();
            }
            case 29: {
                XmlNonNegativeInteger integer = XmlNonNegativeInteger.Factory.newInstance();
                integer.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)integer, value);
                if (validateOnly) break;
                return integer.getBigIntegerValue();
            }
            case 28: {
                XmlNegativeInteger integer = XmlNegativeInteger.Factory.newInstance();
                integer.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)integer, value);
                if (validateOnly) break;
                return integer.getBigIntegerValue();
            }
            case 31: {
                XmlUnsignedLong longValue = XmlUnsignedLong.Factory.newInstance();
                longValue.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)longValue, value);
                if (validateOnly) break;
                return longValue.getBigIntegerValue();
            }
            case 30: {
                XmlPositiveInteger integer = XmlPositiveInteger.Factory.newInstance();
                integer.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)integer, value);
                if (validateOnly) break;
                return integer.getBigIntegerValue();
            }
            case 32: {
                XmlUnsignedInt integer = XmlUnsignedInt.Factory.newInstance();
                integer.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)integer, value);
                if (validateOnly) break;
                return integer.getBigIntegerValue();
            }
            case 23: {
                XmlLong longValue = XmlLong.Factory.newInstance();
                longValue.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)longValue, value);
                if (validateOnly) break;
                return new Long(longValue.getLongValue());
            }
            case 24: {
                XmlInt intValue = XmlInt.Factory.newInstance();
                intValue.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)intValue, value);
                if (validateOnly) break;
                return new Integer(intValue.getIntValue());
            }
            case 25: {
                XmlShort shortValue = XmlShort.Factory.newInstance();
                shortValue.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)shortValue, value);
                if (validateOnly) break;
                return new Short(shortValue.getShortValue());
            }
            case 26: {
                XmlByte byteValue = XmlByte.Factory.newInstance();
                byteValue.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)byteValue, value);
                if (validateOnly) break;
                return new Byte(byteValue.getByteValue());
            }
            case 33: {
                XmlUnsignedShort shortValue = XmlUnsignedShort.Factory.newInstance();
                shortValue.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)shortValue, value);
                if (validateOnly) break;
                return new Integer(shortValue.getIntValue());
            }
            case 34: {
                XmlUnsignedByte byteValue = XmlUnsignedByte.Factory.newInstance();
                byteValue.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)byteValue, value);
                if (validateOnly) break;
                return new Short(byteValue.getShortValue());
            }
            case 20: {
                XmlGDay gday = XmlGDay.Factory.newInstance();
                gday.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)gday, value);
                if (validateOnly) break;
                return gday.getCalendarValue();
            }
            case 21: {
                XmlGMonth date = XmlGMonth.Factory.newInstance();
                date.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)date, value);
                if (validateOnly) break;
                return date.getCalendarValue();
            }
            case 19: {
                XmlGMonthDay date = XmlGMonthDay.Factory.newInstance();
                date.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)date, value);
                if (validateOnly) break;
                return date.getCalendarValue();
            }
            case 18: {
                XmlGYear date = XmlGYear.Factory.newInstance();
                date.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)date, value);
                if (validateOnly) break;
                return date.getCalendarValue();
            }
            case 17: {
                XmlGYearMonth date = XmlGYearMonth.Factory.newInstance();
                date.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)date, value);
                if (validateOnly) break;
                return date.getCalendarValue();
            }
            case 16: {
                XmlDate date = XmlDate.Factory.newInstance();
                date.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)date, value);
                if (validateOnly) break;
                return date.getCalendarValue();
            }
            case 15: {
                XmlTime time = XmlTime.Factory.newInstance();
                time.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)time, value);
                if (validateOnly) break;
                return time.getCalendarValue();
            }
            case 13: {
                XmlDuration duration = XmlDuration.Factory.newInstance();
                return XMLTypeUtils.returnStringResult((XmlAnySimpleType)duration, value, validateOnly);
            }
            case 39: {
                XmlLanguage language = XmlLanguage.Factory.newInstance();
                return XMLTypeUtils.returnStringResult((XmlAnySimpleType)language, value, validateOnly);
            }
            case 8: {
                XmlNOTATION notation = XmlNOTATION.Factory.newInstance();
                return XMLTypeUtils.returnStringResult((XmlAnySimpleType)notation, value, validateOnly);
            }
            case 38: {
                XmlNCName ncname = XmlNCName.Factory.newInstance();
                return XMLTypeUtils.returnStringResult((XmlAnySimpleType)ncname, value, validateOnly);
            }
            case 45: {
                XmlNMTOKEN nmToken = XmlNMTOKEN.Factory.newInstance();
                return XMLTypeUtils.returnStringResult((XmlAnySimpleType)nmToken, value, validateOnly);
            }
            case 40: {
                XmlID id = XmlID.Factory.newInstance();
                return XMLTypeUtils.returnStringResult((XmlAnySimpleType)id, value, validateOnly);
            }
            case 41: {
                XmlIDREF string = XmlIDREF.Factory.newInstance();
                return XMLTypeUtils.returnStringResult((XmlAnySimpleType)string, value, validateOnly);
            }
            case 37: {
                XmlName string = XmlName.Factory.newInstance();
                return XMLTypeUtils.returnStringResult((XmlAnySimpleType)string, value, validateOnly);
            }
            case 36: {
                XmlToken string = XmlToken.Factory.newInstance();
                return XMLTypeUtils.returnStringResult((XmlAnySimpleType)string, value, validateOnly);
            }
            case 43: {
                XmlENTITY string = XmlENTITY.Factory.newInstance();
                return XMLTypeUtils.returnStringResult((XmlAnySimpleType)string, value, validateOnly);
            }
            case 44: {
                XmlENTITIES entities = XmlENTITIES.Factory.newInstance();
                entities.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)entities, value);
                if (validateOnly) break;
                return entities.getListValue();
            }
            case 46: {
                XmlNMTOKENS entities = XmlNMTOKENS.Factory.newInstance();
                entities.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)entities, value);
                if (validateOnly) break;
                return entities.getListValue();
            }
            case 42: {
                XmlIDREFS entities = XmlIDREFS.Factory.newInstance();
                entities.setStringValue(value.getAsString());
                XMLTypeUtils.validateSimpleType((XmlAnySimpleType)entities, value);
                if (validateOnly) break;
                return entities.getListValue();
            }
        }
        return null;
    }

    public static String serializeObject(Object value, String primitiveType) throws ScriptEngineException {
        String typeName = XMLTypeUtils.getTypeName(primitiveType);
        SchemaType type = XMLTypeUtils.findType(typeName);
        XmlAnySimpleType result = null;
        if (type == null) {
            throw new ScriptEngineException("unknown-xml-schema-base-type", new Object[]{typeName}, 2);
        }
        switch (type.getBuiltinTypeCode()) {
            case 14: {
                XmlDateTime dateTimeValue = XmlDateTime.Factory.newInstance();
                if (!(value instanceof Calendar)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                dateTimeValue.setCalendarValue((Calendar)value);
                result = dateTimeValue;
                break;
            }
            case 7: {
                QName qnameValue;
                String prefix;
                if (!(value instanceof QName)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                if ((prefix = (qnameValue = (QName)value).getPrefix()) != null && prefix.length() > 0) {
                    return qnameValue.getPrefix() + ":" + qnameValue.getLocalPart();
                }
                return qnameValue.getLocalPart();
            }
            case 6: {
                XmlAnyURI uri = XmlAnyURI.Factory.newInstance();
                result = XMLTypeUtils.validateAndPopulateString(value, primitiveType, (XmlAnySimpleType)uri);
                break;
            }
            case 10: {
                XmlDouble doubleValue = XmlDouble.Factory.newInstance();
                if (!(value instanceof Double)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                doubleValue.setDoubleValue(((Double)value).doubleValue());
                result = doubleValue;
                break;
            }
            case 9: {
                XmlFloat floatValue = XmlFloat.Factory.newInstance();
                if (!(value instanceof Float)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                floatValue.setFloatValue(((Float)value).floatValue());
                result = floatValue;
                break;
            }
            case 5: {
                XmlHexBinary bin = XmlHexBinary.Factory.newInstance();
                if (!(value instanceof byte[])) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                bin.setByteArrayValue((byte[])value);
                result = bin;
                break;
            }
            case 4: {
                XmlBase64Binary bin = XmlBase64Binary.Factory.newInstance();
                if (!(value instanceof byte[])) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                bin.setByteArrayValue((byte[])value);
                result = bin;
                break;
            }
            case 3: {
                XmlBoolean booleanValue = XmlBoolean.Factory.newInstance();
                if (!(value instanceof Boolean)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                booleanValue.setBooleanValue(((Boolean)value).booleanValue());
                result = booleanValue;
                break;
            }
            case 12: {
                XmlString string = XmlString.Factory.newInstance();
                result = XMLTypeUtils.validateAndPopulateString(value, primitiveType, (XmlAnySimpleType)string);
                break;
            }
            case 35: {
                XmlNormalizedString string = XmlNormalizedString.Factory.newInstance();
                result = XMLTypeUtils.validateAndPopulateString(value, primitiveType, (XmlAnySimpleType)string);
                break;
            }
            case 11: {
                XmlDecimal decimal = XmlDecimal.Factory.newInstance();
                if (!(value instanceof BigDecimal)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                decimal.setBigDecimalValue((BigDecimal)value);
                result = decimal;
                break;
            }
            case 22: {
                XmlInteger integer = XmlInteger.Factory.newInstance();
                result = XMLTypeUtils.populateIntValue(value, primitiveType, integer);
                break;
            }
            case 27: {
                XmlNonPositiveInteger integer = XmlNonPositiveInteger.Factory.newInstance();
                result = XMLTypeUtils.populateIntValue(value, primitiveType, (XmlInteger)integer);
                break;
            }
            case 29: {
                XmlNonNegativeInteger integer = XmlNonNegativeInteger.Factory.newInstance();
                result = XMLTypeUtils.populateIntValue(value, primitiveType, (XmlInteger)integer);
                break;
            }
            case 28: {
                XmlNegativeInteger integer = XmlNegativeInteger.Factory.newInstance();
                result = XMLTypeUtils.populateIntValue(value, primitiveType, (XmlInteger)integer);
                break;
            }
            case 31: {
                XmlUnsignedLong longValue = XmlUnsignedLong.Factory.newInstance();
                result = XMLTypeUtils.populateIntValue(value, primitiveType, (XmlInteger)longValue);
                break;
            }
            case 30: {
                XmlPositiveInteger integer = XmlPositiveInteger.Factory.newInstance();
                result = XMLTypeUtils.populateIntValue(value, primitiveType, (XmlInteger)integer);
                break;
            }
            case 32: {
                XmlUnsignedInt integer = XmlUnsignedInt.Factory.newInstance();
                result = XMLTypeUtils.populateIntValue(value, primitiveType, (XmlInteger)integer);
                break;
            }
            case 23: {
                XmlLong longValue = XmlLong.Factory.newInstance();
                if (!(value instanceof Long)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                longValue.setLongValue(((Long)value).longValue());
                result = longValue;
                break;
            }
            case 24: {
                XmlInt intValue = XmlInt.Factory.newInstance();
                if (!(value instanceof Integer)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                intValue.setIntValue(((Integer)value).intValue());
                result = intValue;
                break;
            }
            case 25: {
                XmlShort shortValue = XmlShort.Factory.newInstance();
                if (!(value instanceof Short)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                shortValue.setShortValue(((Short)value).shortValue());
                result = shortValue;
                break;
            }
            case 26: {
                XmlByte byteValue = XmlByte.Factory.newInstance();
                if (!(value instanceof Byte)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                byteValue.setByteValue(((Byte)value).byteValue());
                result = byteValue;
                break;
            }
            case 33: {
                XmlUnsignedShort shortValue = XmlUnsignedShort.Factory.newInstance();
                if (!(value instanceof Integer)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                shortValue.setIntValue(((Integer)value).intValue());
                result = shortValue;
                break;
            }
            case 34: {
                XmlUnsignedByte byteValue = XmlUnsignedByte.Factory.newInstance();
                if (!(value instanceof Short)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                byteValue.setShortValue(((Short)value).shortValue());
                result = byteValue;
                break;
            }
            case 20: {
                XmlGDay gday = XmlGDay.Factory.newInstance();
                if (!(value instanceof Calendar)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                gday.setCalendarValue((Calendar)value);
                result = gday;
                break;
            }
            case 21: {
                XmlGMonth date = XmlGMonth.Factory.newInstance();
                if (!(value instanceof Calendar)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                date.setCalendarValue((Calendar)value);
                result = date;
                break;
            }
            case 19: {
                XmlGMonthDay date = XmlGMonthDay.Factory.newInstance();
                if (!(value instanceof Calendar)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                date.setCalendarValue((Calendar)value);
                result = date;
                break;
            }
            case 18: {
                XmlGYear date = XmlGYear.Factory.newInstance();
                if (!(value instanceof Calendar)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                date.setCalendarValue((Calendar)value);
                result = date;
                break;
            }
            case 17: {
                XmlGYearMonth date = XmlGYearMonth.Factory.newInstance();
                if (!(value instanceof Calendar)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                date.setCalendarValue((Calendar)value);
                result = date;
                break;
            }
            case 16: {
                XmlDate date = XmlDate.Factory.newInstance();
                if (!(value instanceof Calendar)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                XmlCalendar calendar = new XmlCalendar();
                calendar.set(1, ((Calendar)value).get(1));
                calendar.set(2, ((Calendar)value).get(2));
                calendar.set(5, ((Calendar)value).get(5));
                date.setCalendarValue((Calendar)calendar);
                result = date;
                break;
            }
            case 15: {
                XmlTime time = XmlTime.Factory.newInstance();
                if (!(value instanceof Calendar)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                time.setCalendarValue((Calendar)value);
                result = time;
                break;
            }
            case 13: {
                XmlDuration duration = XmlDuration.Factory.newInstance();
                result = XMLTypeUtils.validateAndPopulateString(value, primitiveType, (XmlAnySimpleType)duration);
                break;
            }
            case 39: {
                XmlLanguage language = XmlLanguage.Factory.newInstance();
                result = XMLTypeUtils.validateAndPopulateString(value, primitiveType, (XmlAnySimpleType)language);
                break;
            }
            case 8: {
                XmlNOTATION notation = XmlNOTATION.Factory.newInstance();
                result = XMLTypeUtils.validateAndPopulateString(value, primitiveType, (XmlAnySimpleType)notation);
                break;
            }
            case 38: {
                XmlNCName ncname = XmlNCName.Factory.newInstance();
                result = XMLTypeUtils.validateAndPopulateString(value, primitiveType, (XmlAnySimpleType)ncname);
                break;
            }
            case 45: {
                XmlNMTOKEN nmToken = XmlNMTOKEN.Factory.newInstance();
                result = XMLTypeUtils.validateAndPopulateString(value, primitiveType, (XmlAnySimpleType)nmToken);
                break;
            }
            case 40: {
                XmlID id = XmlID.Factory.newInstance();
                result = XMLTypeUtils.validateAndPopulateString(value, primitiveType, (XmlAnySimpleType)id);
                break;
            }
            case 41: {
                XmlIDREF string = XmlIDREF.Factory.newInstance();
                result = XMLTypeUtils.validateAndPopulateString(value, primitiveType, (XmlAnySimpleType)string);
                break;
            }
            case 37: {
                XmlName string = XmlName.Factory.newInstance();
                result = XMLTypeUtils.validateAndPopulateString(value, primitiveType, (XmlAnySimpleType)string);
                break;
            }
            case 36: {
                XmlToken string = XmlToken.Factory.newInstance();
                result = XMLTypeUtils.validateAndPopulateString(value, primitiveType, (XmlAnySimpleType)string);
                break;
            }
            case 43: {
                XmlENTITY entity = XmlENTITY.Factory.newInstance();
                result = XMLTypeUtils.validateAndPopulateString(value, primitiveType, (XmlAnySimpleType)entity);
                break;
            }
            case 44: {
                XmlENTITIES entities = XmlENTITIES.Factory.newInstance();
                if (!(value instanceof List)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                entities.setListValue((List)value);
                result = entities;
                break;
            }
            case 46: {
                XmlNMTOKENS entities = XmlNMTOKENS.Factory.newInstance();
                if (!(value instanceof List)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                entities.setListValue((List)value);
                result = entities;
                break;
            }
            case 42: {
                XmlIDREFS entities = XmlIDREFS.Factory.newInstance();
                if (!(value instanceof List)) {
                    XMLTypeUtils.throwInvalidClass(value, primitiveType);
                }
                entities.setListValue((List)value);
                result = entities;
                break;
            }
        }
        if (result == null) {
            return null;
        }
        return result.getStringValue();
    }

    private static XmlAnySimpleType validateAndPopulateString(Object value, String primitiveType, XmlAnySimpleType nmToken) throws ScriptEngineException {
        if (!(value instanceof String)) {
            XMLTypeUtils.throwInvalidClass(value, primitiveType);
        }
        nmToken.setStringValue((String)value);
        return nmToken;
    }

    private static XmlAnySimpleType populateIntValue(Object value, String primitiveType, XmlInteger integer) throws ScriptEngineException {
        if (!(value instanceof BigInteger)) {
            XMLTypeUtils.throwInvalidClass(value, primitiveType);
        }
        integer.setBigIntegerValue((BigInteger)value);
        return integer;
    }

    private static String returnStringResult(XmlAnySimpleType simpleType, IParameterValue value, boolean validateOnly) throws ScriptEngineException {
        simpleType.setStringValue(value.getAsString());
        XMLTypeUtils.validateSimpleType(simpleType, value);
        if (!validateOnly) {
            return simpleType.getStringValue();
        }
        return null;
    }

    private static void validateSimpleType(XmlAnySimpleType simpleType, IParameterValue value) throws ScriptEngineException {
        XmlOptions opts = new XmlOptions();
        opts.setValidateOnSet();
        ArrayList errors = new ArrayList();
        opts.setErrorListener(errors);
        if (!simpleType.validate(opts)) {
            String message = value.getAsString() + " is not in valid XMLSchema format for " + value.getBaseType() + "\nReason(s):";
            Iterator iter = errors.iterator();
            while (iter.hasNext()) {
                message = message + "\n\t" + iter.next();
            }
            throw new ScriptEngineException(message, 2);
        }
    }

    public static String getTypeName(String nameParam) {
        String name = nameParam;
        int index = name.indexOf(58);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public static String getTypePrefix(String nameParam) {
        String name = nameParam;
        int index = name.indexOf(58);
        if (index != -1) {
            name = name.substring(0, index);
            return name;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SchemaType findType(String typeName) {
        Object object = m_syncObj;
        synchronized (object) {
            SchemaType type = m_defaultTypeLoader.findType(new QName(XML_SCHEMA_URI, typeName));
            return type;
        }
    }

    private static void throwInvalidClass(Object badObject, String pimitiveType) throws ScriptEngineException {
        throw new ScriptEngineException("invalid-class-for-primitive", new Object[]{badObject.getClass().getName(), pimitiveType}, 2);
    }

    static {
        m_syncObj = new Object();
        m_defaultTypeLoader = XmlBeans.getContextTypeLoader();
    }
}

