/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script.wsdl;

import com.sonicsw.xqimpl.script.wsdl.WSDLHelperException;
import javax.wsdl.Part;
import javax.xml.namespace.QName;

public class WSDLUtils {
    public static QName getPartTypeName(Part p) {
        QName typeName = p.getTypeName();
        if (typeName == null) {
            typeName = p.getElementName();
        }
        return typeName;
    }

    public static String getTypeURI(Part p) {
        String ret = null;
        QName typeName = p.getTypeName();
        if (typeName == null) {
            QName q = p.getElementName();
            if (q != null) {
                return q.getNamespaceURI();
            }
        } else {
            ret = typeName.getNamespaceURI();
        }
        return ret;
    }

    public static boolean isElement(Part part) throws WSDLHelperException {
        QName typename = part.getTypeName();
        return typename == null;
    }

    public static String encode(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '&') {
                buf.append("&amp;");
                continue;
            }
            if (c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (c == '>') {
                buf.append("&gt;");
                continue;
            }
            if (c == '\"') {
                buf.append("&quot;");
                continue;
            }
            if (c == '\'') {
                buf.append("&apos;");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }
}

