/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.esb.client.ESBInteractorFactory;
import com.sonicsw.esb.expression.def.EsbdlExpressionDef;
import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.mapping.DefaultOutputMappingRule;
import com.sonicsw.esb.itinerary.mapping.InvocationContextImpl;
import com.sonicsw.esb.process.caching.CacheManager;
import com.sonicsw.esb.process.caching.CachingDefinition;
import com.sonicsw.esb.process.caching.CachingException;
import com.sonicsw.esb.process.mapping.InvocationContext;
import com.sonicsw.esb.process.mapping.MappingContext;
import com.sonicsw.esb.process.mapping.MappingRuleList;
import com.sonicsw.esb.process.mapping.MessageMapper;
import com.sonicsw.esb.visitor.ESBVisitor;
import com.sonicsw.esb.visitor.ESBVisitorContext;
import com.sonicsw.xq.XQAccessorFactory;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressFactory;
import com.sonicsw.xq.XQDisableLookingGlass;
import com.sonicsw.xq.XQDispatch;
import com.sonicsw.xq.XQEndpointManager;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQLifeCycleManager;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQService;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xq.XQState;
import com.sonicsw.xq.service.cbr.CBRService;
import com.sonicsw.xqimpl.actional.lg.visitor.ActionalRuntimeContext;
import com.sonicsw.xqimpl.endpoint.container.EndpointContextContainer;
import com.sonicsw.xqimpl.envelope.Envelope;
import com.sonicsw.xqimpl.envelope.EnvelopeFactory;
import com.sonicsw.xqimpl.envelope.XQMessageImpl;
import com.sonicsw.xqimpl.service.CriticalException;
import com.sonicsw.xqimpl.service.InvalidStateException;
import com.sonicsw.xqimpl.service.MessageAlreadyRejected;
import com.sonicsw.xqimpl.service.MessageHandler;
import com.sonicsw.xqimpl.service.RMEMessage;
import com.sonicsw.xqimpl.service.RejectedMessageDispatcher;
import com.sonicsw.xqimpl.service.ServiceLifeCycleManager;
import com.sonicsw.xqimpl.service.TrustVerificationException;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQFaultProcessContextImpl;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.service.XQProcessContextImpl;
import com.sonicsw.xqimpl.service.XQServiceChain;
import com.sonicsw.xqimpl.service.XQServiceConstants;
import com.sonicsw.xqimpl.service.XQServiceContextImpl;
import com.sonicsw.xqimpl.service.XQServiceMetrics;
import com.sonicsw.xqimpl.service.wsinvk.WSInvocationComponent;
import com.sonicsw.xqimpl.util.ClassLoaderManager;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ServiceMessageHandler
extends MessageHandler {
    private static final XQLog log = XQLogImpl.getCategoryLog((int)128);
    private static final XQLog peLog = XQLogImpl.getCategoryLog((int)32768);
    private final XQService m_service;
    private final String m_serviceName;
    private String m_entryEndpoint;
    private final ConcurrentLocks m_concurrentLocks;
    private final ClassLoader m_classLoader;
    private final String m_description;
    private boolean m_enterpriseCachingWarningMessageIssued = false;

    public ServiceMessageHandler(XQService service, String serviceName, int numConcurrentCalls, ClassLoader loader) {
        this.m_service = service;
        this.m_serviceName = serviceName;
        this.m_concurrentLocks = new ConcurrentLocks(numConcurrentCalls);
        this.m_classLoader = loader;
        this.m_description = "ServiceMessageHandler for service " + this.m_serviceName;
    }

    @Override
    public void init(XQParameters environment, XQEndpointManager endpointManager, XQMessageFactory messageFactory, EnvelopeFactory envelopeFactory, XQAccessorFactory accessorFactory, XQAddressFactory addressFactory, XQAddress rmeAddress, XQDispatch dispatcher, XQLifeCycleManager lifeCycle, XQServiceMetrics metricsHelper, RejectedMessageDispatcher rejectedMessageDispatcher, ESBInteractorFactory interactorFactory) {
        super.init(environment, endpointManager, messageFactory, envelopeFactory, accessorFactory, addressFactory, rmeAddress, dispatcher, lifeCycle, metricsHelper, rejectedMessageDispatcher, interactorFactory);
        this.m_concurrentLocks.init();
    }

    @Override
    public MessageHandler.SendBox handleMessage(EsbMessageExchange mex) throws Throwable {
        return this.handleMessageCommon(mex, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageHandler.SendBox handleMessageCommon(EsbMessageExchange mex, boolean immediate) throws Throwable {
        XQMessage message = mex.getInputMessage();
        XQParameters params = mex.getXQParameters();
        EnvelopeFactory envelopeFactory = mex.getEnvelopeFactory();
        XQMessageFactory messageFactory = mex.getMessageFactory();
        XQAddress rmeAddress = mex.getRMEAddress();
        if (log.isDebugLoggingEnabled()) {
            String namestr = immediate ? "handleMessageImmediate" : "handleMessage";
            String str = params.getParameter("SonicXQ.ProcessStep", 1);
            log.logDebug("In service handler " + namestr + ": stepName = " + str);
        }
        if (envelopeFactory == null) {
            envelopeFactory = this.m_envelopeFactory;
        }
        if (rmeAddress == null) {
            rmeAddress = this.m_rmeAddress;
        }
        XQMessageInternal msgInternal = (XQMessageInternal)message;
        XQServiceContextImpl serviceContext = null;
        Integer lock = null;
        HashMap<String, Object> visitorParams = null;
        ESBVisitor visitor = msgInternal.getVisitor();
        boolean receivedByStepInvoked = false;
        Throwable caught = null;
        String errorCode = null;
        boolean incremented = false;
        try {
            this.checkServiceContainerAborting();
            lock = this.m_concurrentLocks.getLock();
            this.checkServiceContainerAborting();
            if (lock != null) {
                incremented = this.m_concurrentLocks.incrementMaxActive();
            }
            serviceContext = new XQServiceContextImpl(this.m_endpointManager, envelopeFactory, this.m_accessorFactory, messageFactory, this.m_addressFactory, params, lock, this.m_eventDispatcher, this.m_lifeCycle, this.m_interactorFactory);
            if (!immediate && msgInternal.getSidebandProperty("SonicESB.CurrentEntryEndpoint") != null) {
                serviceContext.setEntryEndpoint((String)msgInternal.getSidebandProperty("SonicESB.CurrentEntryEndpoint"));
            } else {
                serviceContext.setEntryEndpoint(this.m_entryEndpoint);
            }
            serviceContext.setRMEAddress(rmeAddress);
            serviceContext.setQoS(mex.getQOS());
            serviceContext.setMitigationContextFactory(XQContainer.getMitigationContextFactory());
            serviceContext.addIncoming(envelopeFactory.createDefaultEnvelope(message));
            String processName = params.getParameter("SonicXQ.ProcessName", 1);
            XQProcessContextImpl processContext = null;
            if (processName != null) {
                if (log.isDebugLoggingEnabled()) {
                    log.logDebug("Invoking process: " + processName);
                }
                if (mex.isInFaultProcess()) {
                    processContext = new XQFaultProcessContextImpl(params, serviceContext);
                    mex.setInFaultProcess(false);
                } else {
                    processContext = new XQProcessContextImpl(params, serviceContext);
                }
                serviceContext.setProcessContext(processContext);
            }
            String debugInfo = "";
            if (log.isDebugLoggingEnabled()) {
                debugInfo = this.m_serviceName + " from entry endpoint:" + this.m_entryEndpoint + " with messageID=" + message.getHeaderValue("JMSMessageID");
                log.logDebug("Invoking service: " + debugInfo);
            }
            visitorParams = new HashMap<String, Object>();
            receivedByStepInvoked = this.actionalNotifyPreStep(message, params, msgInternal, visitor, processName, visitorParams);
            try {
                this.callService(serviceContext);
            }
            catch (Throwable thrown) {
                caught = thrown;
                errorCode = "XQ_SERVICE_EXCEPTION";
            }
        }
        catch (CriticalException e) {
            throw e;
        }
        catch (Throwable thrown) {
            caught = thrown;
            errorCode = "MESSAGE_RECEIPT_FAILURE";
        }
        finally {
            if (lock != null) {
                this.m_concurrentLocks.returnLock(lock);
                if (incremented) {
                    this.m_concurrentLocks.decrementMaxActive();
                }
            }
            if (receivedByStepInvoked) {
                this.actionalEndServerInteraction(visitor, visitorParams);
            }
        }
        RMEMessage rmeMsg = null;
        if (caught != null) {
            if (immediate) {
                throw caught;
            }
            if ("XQ_SERVICE_EXCEPTION".equals(errorCode) && mex.isInProcess()) {
                rmeMsg = new RMEMessage(caught, rmeAddress, this.m_messageFactory, message, params, errorCode);
            } else {
                EndpointContextContainer endpointContext = mex.getEndpointContext();
                this.m_rejectedMessageDispatcher.sendMessageToRME(caught, message, rmeAddress, errorCode, params, endpointContext, this.m_messageFactory, this.m_description);
                if (!"XQ_SERVICE_EXCEPTION".equals(errorCode)) {
                    throw new MessageAlreadyRejected(this.m_description, caught);
                }
            }
        }
        List<XQEnvelope> outboxList = serviceContext.getOutgoing();
        List<XQEnvelope> faultboxList = serviceContext.getFaults();
        if (visitor != null) {
            ESBVisitorContext visitorCtx = (ESBVisitorContext)msgInternal.getSidebandProperty("ESBVisitor.PARAM_RUNTIME_CONTEXT");
            if (outboxList != null) {
                this.addVisitors(outboxList, visitor, visitorCtx);
            }
            if (faultboxList != null) {
                this.addVisitors(faultboxList, visitor, visitorCtx);
            }
        }
        MessageHandler.SendBox sb = new MessageHandler.SendBox(outboxList, faultboxList);
        sb.setRME(rmeMsg);
        return sb;
    }

    private void addVisitors(List<XQEnvelope> faultboxList, ESBVisitor visitor, ESBVisitorContext visitorCtx) {
        for (XQEnvelope envelope : faultboxList) {
            this.addVisitor(envelope, visitor, visitorCtx);
        }
    }

    private boolean actionalNotifyPreStep(XQMessage message, XQParameters params, XQMessageInternal msgInternal, ESBVisitor visitor, String processName, Map<String, Object> visitorParams) {
        boolean actionalEnabled = visitor != null;
        boolean receivedByStepInvoked = false;
        if (actionalEnabled) {
            if (processName != null) {
                visitorParams.put("ESBVisitor.PARAM_PROCESS_NAME", processName);
            } else {
                boolean bl = actionalEnabled = actionalEnabled && !this.isLookingGlassDisabled();
                if (actionalEnabled) {
                    visitorParams.put("ESBVisitor.PARAM_SERVICE_NAME", this.m_serviceName);
                }
            }
            if (actionalEnabled) {
                visitorParams.put("ESBVisitor.PARAM_XQ_PARAMETERS", params);
                visitorParams.put("ESBVisitor.PARAM_XQ_MESSAGE", message);
                visitor.sentToStep(visitorParams);
                boolean trusted = true;
                this.actionalNotifyReceivedByStep(visitor, visitorParams, processName, params, message);
                receivedByStepInvoked = true;
                trusted = this.getTrustInformation(msgInternal);
                if (!trusted) {
                    throw new TrustVerificationException();
                }
            }
        }
        return receivedByStepInvoked;
    }

    public boolean isLookingGlassDisabled() {
        XQService svc;
        if (this.m_service instanceof XQDisableLookingGlass) {
            return true;
        }
        return this.m_service instanceof XQServiceChain && (svc = ((XQServiceChain)this.m_service).getTargetService()) instanceof XQDisableLookingGlass;
    }

    public boolean isWebServiceCall() {
        XQService svc;
        if (this.m_service instanceof WSInvocationComponent) {
            return true;
        }
        return this.m_service instanceof XQServiceChain && (svc = ((XQServiceChain)this.m_service).getTargetService()) instanceof WSInvocationComponent;
    }

    @Override
    public MessageHandler.SendBox handleMessageImmediate(EsbMessageExchange mex) throws Throwable {
        return this.handleMessageCommon(mex, true);
    }

    private boolean getTrustInformation(XQMessageInternal msgInternal) {
        boolean trusted = true;
        ActionalRuntimeContext arc = (ActionalRuntimeContext)msgInternal.getSidebandProperty("ESBVisitor.PARAM_RUNTIME_CONTEXT");
        if (arc != null) {
            if (arc.getTrustCheckPerformed()) {
                trusted = arc.getTrustVerificationStatus();
                log.logDebug("Trust enforcement " + (trusted ? "successful" : "failed"));
            } else {
                log.logDebug("Trust enforcement disabled for this container. This message is treated as a trusted message.");
            }
        } else {
            log.logDebug("Trust enforcement information not accessible. This message is treated as a trusted message");
        }
        return trusted;
    }

    private void callService(XQServiceContext serviceContext) throws Throwable {
        ClassLoader oldLoader = ClassLoaderManager.setThreadContextClassLoader((ClassLoader)this.m_classLoader);
        try {
            MessageMapper msgMapper = (MessageMapper)serviceContext.getParameters().getParameterObject(MessageMapper.class.getName(), 3);
            boolean supportsESBDL = this.isESBDLService(serviceContext);
            MappingContext mappingCtx = null;
            if (msgMapper != null) {
                mappingCtx = new MappingContext();
                serviceContext.getParameters().removeParameter(MessageMapper.class.getName(), 3);
                serviceContext.getParameters().removeParameter("Internal.MessageMapper", 3);
                InvocationContextImpl invocationCtx = new InvocationContextImpl(msgMapper);
                ((XQServiceContextImpl)serviceContext).setInvocationContext(invocationCtx);
                mappingCtx.setServiceContext(serviceContext);
                msgMapper.executeInputMapping(serviceContext.getFirstIncoming().getMessage(), mappingCtx);
            }
            List<CachingValueHolder> cachedValues = null;
            boolean errorRetrievingCachedValues = false;
            CachingDefinition caching = (CachingDefinition)serviceContext.getParameters().getParameterObject(CachingDefinition.class.getName(), 3);
            if (caching != null) {
                serviceContext.getParameters().removeParameter(CachingDefinition.class.getName(), 3);
                try {
                    cachedValues = this.cacheLookup(caching, serviceContext);
                }
                catch (RuntimeException e) {
                    log.logWarning("Retrieving cached values for the service \"" + this.m_serviceName + "\" in the process step \"" + serviceContext.getProcessContext().getStepName() + "\" of the process \"" + serviceContext.getProcessContext().getName() + "\" has reported an error: " + e.getMessage());
                    log.logWarning((Throwable)e);
                    errorRetrievingCachedValues = true;
                }
            }
            if (caching == null || this.atLeastOneCacheMiss(cachedValues) || errorRetrievingCachedValues) {
                this.m_service.service(serviceContext);
            }
            if (caching != null && cachedValues != null) {
                if (!XQContainer.isEnterpriseLicense()) {
                    if (!this.m_enterpriseCachingWarningMessageIssued) {
                        log.logWarning("ESB Caching is not supported and requires an ESB Enterprise License");
                        this.m_enterpriseCachingWarningMessageIssued = true;
                    }
                } else if (supportsESBDL) {
                    this.handleParameterOutputCacheMissHit(serviceContext, cachedValues);
                } else {
                    this.handleOutboxCacheMissHit(serviceContext, cachedValues);
                }
            }
            if (msgMapper != null) {
                this.mapOutboxMessages(serviceContext, mappingCtx, msgMapper);
                this.mapFaultmessages(serviceContext, mappingCtx, msgMapper);
                if (mappingCtx != null) {
                    mappingCtx.clearAll();
                }
            }
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(this.toString() + ": onMessage: done: returning");
            }
        }
        catch (Throwable thrown) {
            if (log.isDebugLoggingEnabled()) {
                log.logDebug(this.toString() + ": onMessage: caught exception from service method: " + thrown);
            }
            log.logError("Exception calling service " + this.m_serviceName + ": message rejected");
            log.logError(thrown);
            throw thrown;
        }
        finally {
            ClassLoaderManager.setThreadContextClassLoader((ClassLoader)oldLoader);
        }
    }

    private boolean isESBDLService(XQServiceContext serviceContext) throws Throwable {
        boolean esbdlService = false;
        MessageMapper msgMapper = (MessageMapper)serviceContext.getParameters().getParameterObject(MessageMapper.class.getName(), 3);
        if (msgMapper == null) {
            esbdlService = false;
        } else if (this.hasInterfaceParameters(msgMapper.getOutputMappingRules()) || this.hasInterfaceParameters(msgMapper.getInputMappingRules())) {
            esbdlService = true;
        }
        return esbdlService;
    }

    private boolean hasInterfaceParameters(MappingRuleList mrl) {
        if (mrl == null) {
            return false;
        }
        Set<EsbdlExpressionDef> interfaceParms = mrl.getInterfaceParameters();
        return interfaceParms != null && !interfaceParms.isEmpty();
    }

    private void handleOutboxCacheMissHit(XQServiceContext serviceContext, List<CachingValueHolder> cachedValues) throws CachingException, XQMessageException {
        CacheManager cacheManager = XQContainer.getInstance().getCacheManager();
        for (CachingValueHolder holder : cachedValues) {
            if (holder.cachedValue == null) {
                List<XQEnvelope> outbox = ((XQServiceContextImpl)serviceContext).getOutgoing();
                if (null == outbox) continue;
                List<XQEnvelope> toCache = this.prepareCacheContent(outbox, serviceContext);
                if (peLog.isDebugLoggingEnabled()) {
                    for (XQEnvelope env : toCache) {
                        peLog.logDebug("Cache Content :" + ((Envelope)env).getStringRepresentation());
                    }
                }
                cacheManager.putEntry(holder.cacheName, holder.cacheKey, toCache);
                continue;
            }
            Collection cachedOutbox = (Collection)holder.cachedValue;
            List<XQEnvelope> outboxToSend = this.restoreCachedContent(cachedOutbox, serviceContext);
            List<XQEnvelope> outgoing = ((XQServiceContextImpl)serviceContext).getOutgoingReqd();
            for (XQEnvelope envelope : outboxToSend) {
                XQMessage message = envelope.getMessage();
                if (message instanceof XQMessageInternal) {
                    XQServiceContextImpl.setBoxType((XQMessageInternal)message, XQServiceConstants.OUTBOX);
                }
                outgoing.add(envelope);
            }
        }
    }

    private void handleParameterOutputCacheMissHit(XQServiceContext serviceContext, List<CachingValueHolder> cachedValues) throws Throwable {
        CacheManager cacheManager = XQContainer.getInstance().getCacheManager();
        for (CachingValueHolder holder : cachedValues) {
            if (holder.cachedValue == null) {
                List<XQEnvelope> outbox = ((XQServiceContextImpl)serviceContext).getOutgoing();
                if (null == outbox) continue;
                cacheManager.putEntry(holder.cacheName, holder.cacheKey, serviceContext.getInvocationContext());
                continue;
            }
            InvocationContext iccached = (InvocationContext)holder.cachedValue;
            InvocationContext iclive = (InvocationContext)serviceContext.getInvocationContext();
            iclive.assignPrepopulatedOutputParameterValues(iccached.getOutputParameterValues());
            serviceContext.addOutgoing(serviceContext.getFirstIncoming());
        }
    }

    private boolean atLeastOneCacheMiss(List<CachingValueHolder> cachedValues) {
        if (null == cachedValues) {
            return false;
        }
        for (CachingValueHolder holder : cachedValues) {
            if (holder.cachedValue != null) continue;
            return true;
        }
        return false;
    }

    private List<CachingValueHolder> cacheLookup(CachingDefinition caching, XQServiceContext serviceContext) throws CachingException {
        CacheManager cacheManager = XQContainer.getInstance().getCacheManager();
        cacheManager.setupCaches(caching, serviceContext.getParameters());
        Map<String, Serializable> cacheKeys = cacheManager.computeCacheKeys(caching, serviceContext);
        if (peLog.isDebugLoggingEnabled()) {
            peLog.logDebug("Caching is enabled for this step and computed the following cache keys: " + cacheKeys);
        }
        ArrayList<CachingValueHolder> cachedValues = null;
        if (!cacheKeys.isEmpty()) {
            cachedValues = new ArrayList<CachingValueHolder>(cacheKeys.size());
            for (Map.Entry<String, Serializable> entry : cacheKeys.entrySet()) {
                CachingValueHolder holder = new CachingValueHolder();
                holder.cacheKey = entry.getValue();
                holder.cacheName = caching.getCacheNameForKey(entry.getKey());
                holder.cachedValue = cacheManager.getEntry(holder.cacheName, holder.cacheKey);
                if (holder.cachedValue == null) {
                    if (peLog.isDebugLoggingEnabled()) {
                        peLog.logDebug("Cache miss for cache key: " + holder.cacheKey);
                    }
                } else if (peLog.isDebugLoggingEnabled()) {
                    peLog.logDebug("Cache hit for cache key: " + holder.cacheKey);
                }
                cachedValues.add(holder);
            }
        }
        return cachedValues;
    }

    private List<XQEnvelope> prepareCacheContent(List<XQEnvelope> outbox, XQServiceContext serviceContext) {
        XQEnvelope defaultEnvelope = ((EnvelopeFactory)serviceContext.getEnvelopeFactory()).getDefaultEnvelope();
        ArrayList<XQEnvelope> result = new ArrayList<XQEnvelope>(outbox.size());
        for (XQEnvelope envelope : outbox) {
            XQEnvelope toCache = (XQEnvelope)envelope.clone();
            if (this.isCBRService()) {
                this.prepareCacheAddresses(toCache, defaultEnvelope);
                toCache.setMessage(null);
            } else {
                this.prepareCacheAddresses(toCache, defaultEnvelope);
                this.prepareCacheMessage(toCache);
            }
            result.add(toCache);
        }
        return result;
    }

    private boolean isCBRService() {
        boolean result = false;
        XQService svc = this.m_service;
        if (svc instanceof XQServiceChain) {
            svc = ((XQServiceChain)this.m_service).getTargetService();
        }
        if (svc instanceof CBRService) {
            result = true;
        }
        return result;
    }

    private void prepareCacheMessage(XQEnvelope toCache) {
        XQMessageInternal message = (XQMessageInternal)toCache.getMessage().clone();
        message.setVisitor(null);
        message.setSidebandProperties(null);
        try {
            message.setReplyTo(null);
        }
        catch (XQMessageException xQMessageException) {
            // empty catch block
        }
        toCache.setMessage((XQMessage)message);
    }

    private void prepareCacheAddresses(XQEnvelope toCache, XQEnvelope defaultEnvelope) {
        if (this.sameDestination(toCache, defaultEnvelope)) {
            toCache.clearAddresses();
        }
    }

    private boolean sameDestination(XQEnvelope newEnvelope, XQEnvelope defaultEnvelope) {
        HashSet newDestinations = new HashSet(4);
        Iterator newAddrs = newEnvelope.getAddresses();
        while (newAddrs.hasNext()) {
            newDestinations.add(newAddrs.next());
        }
        HashSet defaultDestinations = new HashSet(4);
        Iterator defaultAddrs = defaultEnvelope.getAddresses();
        while (defaultAddrs.hasNext()) {
            defaultDestinations.add(defaultAddrs.next());
        }
        return newDestinations.equals(defaultDestinations);
    }

    private List<XQEnvelope> restoreCachedContent(Collection<XQEnvelope> cachedOutbox, XQServiceContext serviceContext) throws XQMessageException {
        XQEnvelope inflightEnvelope = serviceContext.getFirstIncoming();
        ArrayList<XQEnvelope> result = new ArrayList<XQEnvelope>(cachedOutbox.size());
        for (XQEnvelope cachedEnvelope : cachedOutbox) {
            XQEnvelope envelopeToSend = (XQEnvelope)cachedEnvelope.clone();
            if (this.isCBRService()) {
                this.restoreAddresses(envelopeToSend, inflightEnvelope);
                this.restoreInflightMessage(envelopeToSend, inflightEnvelope);
            } else {
                this.restoreAddresses(envelopeToSend, inflightEnvelope);
                ServiceMessageHandler.restoreMessage(envelopeToSend, inflightEnvelope);
            }
            result.add(envelopeToSend);
        }
        return result;
    }

    private void restoreInflightMessage(XQEnvelope envelopeToSend, XQEnvelope inflightEnvelope) {
        envelopeToSend.setMessage(inflightEnvelope.getMessage());
    }

    static void restoreMessage(XQEnvelope envelopeToSend, XQEnvelope inflightEnvelope) throws XQMessageException {
        XQMessageInternal message = (XQMessageInternal)envelopeToSend.getMessage().clone();
        XQMessageInternal inflightMessage = (XQMessageInternal)inflightEnvelope.getMessage();
        ServiceMessageHandler.propagateHeader(inflightMessage, message, "JMSCorrelationID");
        ServiceMessageHandler.propagateHeader(inflightMessage, message, "JMSPriority");
        ServiceMessageHandler.propagateHeader(inflightMessage, message, "JMSReplyTo");
        String headerName = XQMessageImpl.USE_NEW_REPLYTO ? "SonicESBReplyTo" : "{http://www.sonicsw.com/esb}ReplyTo";
        ServiceMessageHandler.propagateHeader(inflightMessage, message, headerName);
        message.setEndpointRegistry(inflightMessage.getEndpointRegistry());
        message.setReplyTo(inflightMessage.getReplyTo());
        message.setVisitor(inflightMessage.getVisitor());
        message.setSidebandProperties(inflightMessage.getSidebandProperties());
        envelopeToSend.setMessage((XQMessage)message);
    }

    private void restoreAddresses(XQEnvelope envelopeToSend, XQEnvelope inflightEnvelope) {
        if (!envelopeToSend.getAddresses().hasNext()) {
            Iterator defaultAddresses = inflightEnvelope.getAddresses();
            while (defaultAddresses.hasNext()) {
                envelopeToSend.addAddress((XQAddress)defaultAddresses.next());
            }
        }
    }

    private static void propagateHeader(XQMessage from, XQMessage to, String property) throws XQMessageException {
        Object value = from.getHeaderValue(property);
        if (null != value) {
            to.setHeaderValue(property, value);
        }
    }

    private void mapFaultmessages(XQServiceContext serviceContext, MappingContext mappingCtx, MessageMapper msgMapper) throws XQMessageException {
        int nOut;
        List<XQEnvelope> faultbox = ((XQServiceContextImpl)serviceContext).getFaults();
        List<XQEnvelope> outbox = ((XQServiceContextImpl)serviceContext).getOutgoing();
        int n = nOut = outbox != null ? outbox.size() : 0;
        if (faultbox != null && msgMapper.getFaultMappingRules() != null && msgMapper.getFaultMappingRules().size() > 0) {
            Iterator<XQEnvelope> faultIter = faultbox.iterator();
            while (faultIter.hasNext()) {
                XQEnvelope env = faultIter.next();
                XQMessage msg = env.getMessage();
                String faultName = null;
                try {
                    faultName = msg.getStringHeader("SonicESB.Fault.Name");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (faultName == null) {
                    log.logDebug("Using the first fault mapping as the fault name header is not found");
                    faultName = msgMapper.getFaultMappingRules().entrySet().iterator().next().getKey();
                }
                if (log.isDebugLoggingEnabled()) {
                    log.logDebug(this.toString() + ": Fault mapping for fault name: " + faultName);
                }
                mappingCtx.addObject("MultipleMessages", nOut > 0 || faultIter.hasNext());
                boolean result = msgMapper.executeFaultMapping(faultName, msg, mappingCtx);
                if (result) {
                    msg = (XQMessage)mappingCtx.getObject(DefaultOutputMappingRule.RESPONSE_MSG, true);
                    env.setMessage(msg);
                    mappingCtx.removeObject(DefaultOutputMappingRule.RESPONSE_MSG);
                }
                XQServiceContextImpl.setBoxType((XQMessageInternal)msg, XQServiceConstants.FAULTBOX);
            }
        }
    }

    private void mapOutboxMessages(XQServiceContext serviceContext, MappingContext mappingCtx, MessageMapper msgMapper) {
        int nFaults;
        List<XQEnvelope> outbox = ((XQServiceContextImpl)serviceContext).getOutgoing();
        List<XQEnvelope> faultbox = ((XQServiceContextImpl)serviceContext).getFaults();
        int n = nFaults = faultbox != null ? faultbox.size() : 0;
        if (outbox != null && msgMapper.getOutputMappingRules() != null && msgMapper.getOutputMappingRules().getSize() > 0) {
            Iterator<XQEnvelope> outboxIter = outbox.iterator();
            while (outboxIter.hasNext()) {
                XQEnvelope env = outboxIter.next();
                mappingCtx.addObject("MultipleMessages", nFaults > 0 || outboxIter.hasNext());
                XQMessage msg = env.getMessage();
                if (log.isDebugLoggingEnabled()) {
                    log.logDebug(this.toString() + ": Mapping Outbox messages");
                }
                msgMapper.executeOutputMapping(msg, mappingCtx);
                if (!msgMapper.getOutputMappingRules().isXQMsgMappingForRHSDefined()) continue;
                msg = (XQMessage)mappingCtx.getObject(DefaultOutputMappingRule.RESPONSE_MSG, true);
                env.setMessage(msg);
                mappingCtx.removeObject(DefaultOutputMappingRule.RESPONSE_MSG);
            }
        }
    }

    void releaseAllLocks() {
        try {
            this.m_concurrentLocks.releaseAllLocks();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void destroy() {
        ClassLoader oldLoader = ClassLoaderManager.setThreadContextClassLoader((ClassLoader)this.m_classLoader);
        try {
            this.m_service.destroy();
        }
        finally {
            ClassLoaderManager.setThreadContextClassLoader((ClassLoader)oldLoader);
        }
    }

    public String getEntryEndpoint() {
        return this.m_entryEndpoint;
    }

    public void setEntryEndpoint(String entryEndpoint) {
        this.m_entryEndpoint = entryEndpoint;
    }

    private void checkServiceContainerAborting() {
        ServiceLifeCycleManager serviceLifecycleMgr = (ServiceLifeCycleManager)this.m_lifeCycle;
        if (serviceLifecycleMgr.wasServiceAborted()) {
            throw new InvalidStateException("Not processing message in service handler", this.m_serviceName, false, true, serviceLifecycleMgr.getCurrentServiceState() == XQState.STOPPED);
        }
        if (serviceLifecycleMgr.getContainerLifeCycleManager().wasContainerAborted()) {
            throw new InvalidStateException("Not processing message in service handler", "container", true, true);
        }
    }

    private void actionalNotifyReceivedByStep(ESBVisitor visitor, Map<String, Object> visitorParams, String processName, XQParameters params, XQMessage message) {
        if (!this.isLookingGlassDisabled()) {
            visitorParams.put("ESBVisitor.PARAM_PROCESS_NAME", processName);
            visitorParams.put("ESBVisitor.PARAM_SERVICE_NAME", this.m_serviceName);
            visitorParams.put("ESBVisitor.PARAM_XQ_PARAMETERS", params);
            visitorParams.put("ESBVisitor.PARAM_XQ_MESSAGE", message);
            visitor.receivedByStep(visitorParams);
        }
    }

    private void addVisitor(XQEnvelope env, ESBVisitor visitor, ESBVisitorContext visitorCtx) {
        XQMessageInternal xqMsg = (XQMessageInternal)env.getMessage();
        xqMsg.setVisitor(visitor);
        if (visitorCtx != null) {
            xqMsg.addSidebandProperty("ESBVisitor.PARAM_RUNTIME_CONTEXT", visitorCtx.clone());
        }
    }

    private void actionalEndServerInteraction(ESBVisitor visitor, Map<String, Object> visitorParams) {
        if (visitor != null && !this.isLookingGlassDisabled()) {
            visitorParams.put("End SI", "true");
            visitor.receivedByStep(visitorParams);
        }
    }

    public String toString() {
        return this.m_description;
    }

    public final class ConcurrentLocks {
        private final int m_size;
        private final Integer[] m_locks;
        private int m_head;
        private final Lock m_lock = new ReentrantLock();
        private final Condition m_full = this.m_lock.newCondition();
        private final Condition m_notEmpty = this.m_lock.newCondition();
        private final AtomicInteger m_unlimitedLockCounter;
        private XQServiceMetrics.Statistic m_concurrencyRefreshIntervalMaxActive;
        private XQServiceMetrics.UsageStatisticProvider m_concurrencyUsageTime;
        private XQServiceMetrics.UsageStatisticProvider m_concurrencyAverageUsageTime;

        public ConcurrentLocks(int numConcurrentCalls) {
            boolean unlimitedLocks = numConcurrentCalls == -1;
            this.m_size = unlimitedLocks ? 0 : numConcurrentCalls;
            this.m_locks = new Integer[this.m_size];
            for (int i = 0; i < this.m_size; ++i) {
                this.m_locks[i] = this.m_size - i;
            }
            this.m_head = this.m_size - 1;
            this.m_unlimitedLockCounter = unlimitedLocks ? new AtomicInteger() : null;
        }

        void init() {
            this.m_concurrencyRefreshIntervalMaxActive = ServiceMessageHandler.this.m_metricsHelper.getStatistic(XQServiceMetrics.CONCURRENCY_REFRESH_INTERVAL_MAX_ACTIVE);
            String resourcesName = "service " + ServiceMessageHandler.this.m_serviceName;
            this.m_concurrencyUsageTime = new XQServiceMetrics.UsageStatisticProvider(resourcesName, this.m_size);
            ServiceMessageHandler.this.m_metricsHelper.setConcurrencyUsage(this.m_concurrencyUsageTime);
            this.m_concurrencyAverageUsageTime = new XQServiceMetrics.UsageStatisticProvider(resourcesName, this.m_size);
            ServiceMessageHandler.this.m_metricsHelper.setConcurrencyAverageUsage(this.m_concurrencyAverageUsageTime);
        }

        public Integer getLock() throws InterruptedException {
            if (this.m_unlimitedLockCounter != null) {
                return this.m_unlimitedLockCounter.incrementAndGet();
            }
            this.m_lock.lock();
            Integer lock = null;
            try {
                while (this.m_head < 0) {
                    this.m_notEmpty.await();
                }
                Integer n = lock = this.m_locks[this.m_head--];
                this.m_lock.unlock();
                this.m_concurrencyUsageTime.registerResourceStart(lock);
                this.m_concurrencyAverageUsageTime.registerResourceStart(lock);
                return n;
            }
            catch (Throwable throwable) {
                this.m_lock.unlock();
                this.m_concurrencyUsageTime.registerResourceStart(lock);
                this.m_concurrencyAverageUsageTime.registerResourceStart(lock);
                throw throwable;
            }
        }

        public boolean incrementMaxActive() {
            return this.m_concurrencyRefreshIntervalMaxActive.increment();
        }

        public boolean decrementMaxActive() {
            return this.m_concurrencyRefreshIntervalMaxActive.decrement();
        }

        public void returnLock(Integer lock) {
            if (this.m_unlimitedLockCounter != null) {
                this.m_unlimitedLockCounter.decrementAndGet();
                return;
            }
            this.m_lock.lock();
            try {
                this.m_locks[++this.m_head] = lock;
                if (this.m_size == this.m_head + 1) {
                    this.m_full.signalAll();
                }
                this.m_notEmpty.signalAll();
            }
            finally {
                this.m_lock.unlock();
                this.m_concurrencyUsageTime.registerResourceEnd(lock);
                this.m_concurrencyAverageUsageTime.registerResourceEnd(lock);
            }
        }

        public void releaseAllLocks() throws InterruptedException {
            if (this.m_unlimitedLockCounter != null) {
                this.m_unlimitedLockCounter.set(0);
                return;
            }
            this.m_lock.lock();
            try {
                while (this.m_head + 1 != this.m_size) {
                    this.m_full.await();
                }
                this.m_concurrencyUsageTime.clear();
                this.m_concurrencyAverageUsageTime.clear();
            }
            finally {
                this.m_lock.unlock();
            }
        }
    }

    static class CachingValueHolder {
        protected String cacheName;
        protected Serializable cacheKey;
        protected Object cachedValue;

        CachingValueHolder() {
        }
    }
}

