/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.esb.expression.Expression;
import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.expression.el.ELExpressionFactory;
import com.sonicsw.esb.expression.el.ELUtils;
import com.sonicsw.esb.mgmtapi.runtime.ESBArtifactInfo;
import com.sonicsw.esb.process.caching.CacheManager;
import com.sonicsw.esb.process.engine.ProcessEngine;
import com.sonicsw.esb.process.engine.bootstrap.PEConfigUtil;
import com.sonicsw.esb.visitor.ESBVisitorChain;
import com.sonicsw.mf.common.AbstractApplicationComponent;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementChangeHandler;
import com.sonicsw.mf.common.config.IFSElementChange;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.info.INotificationInfo;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.runtime.ICanonicalName;
import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQState;
import com.sonicsw.xq.connector.jms.GlobalContentTypeJMSMapperOverride;
import com.sonicsw.xq.connector.jms.messagingbean.TempDestinationCache;
import com.sonicsw.xqimpl.common.MitigationContextFactory;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQContainerConfig;
import com.sonicsw.xqimpl.config.XQGlobalConfig;
import com.sonicsw.xqimpl.config.XQIntrinsicServicesHelper;
import com.sonicsw.xqimpl.config.XQLicenseHelper;
import com.sonicsw.xqimpl.config.XQProcessConfig;
import com.sonicsw.xqimpl.config.XQServiceConfig;
import com.sonicsw.xqimpl.config.XQServiceTypeHelper;
import com.sonicsw.xqimpl.config.XQTransientNamingService;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.envelope.XQAddressFactoryImpl;
import com.sonicsw.xqimpl.envelope.XQMessageFactoryImpl;
import com.sonicsw.xqimpl.service.AccessorFactory;
import com.sonicsw.xqimpl.service.ContainerLifeCycleManager;
import com.sonicsw.xqimpl.service.ESBSpringUtils;
import com.sonicsw.xqimpl.service.TestCallbackManager;
import com.sonicsw.xqimpl.service.XQAppManager;
import com.sonicsw.xqimpl.service.XQEndpointManagerImpl;
import com.sonicsw.xqimpl.service.XQServiceApplication;
import com.sonicsw.xqimpl.service.XQServiceMetrics;
import com.sonicsw.xqimpl.service.XQServiceNotifications;
import com.sonicsw.xqimpl.util.ClassLoaderManager;
import com.sonicsw.xqimpl.util.EsbClassLoader;
import com.sonicsw.xqimpl.util.FileChangeHandler;
import com.sonicsw.xqimpl.util.SonicFsFileChangeManager;
import com.sonicsw.xqimpl.util.StringUtil;
import com.sonicsw.xqimpl.util.log.XQLog4jConfigurator;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import com.sonicsw.xqimpl.ws.addressing.AddressingUtils;
import java.io.File;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class XQContainer
extends AbstractApplicationComponent {
    public static final String TEST_CALLBACK_PARAM = "TEST_CALLBACK";
    public static String TEST_CONTAINER_MODE_PARAM = "TEST_CONTAINER_MODE";
    public static final String DEPLOYMENT_PARAM_EP_CALL_QOS = "ENDPOINT_CALL_QOS";
    public static final String CACHED_ENABLED_PARAM = "ENABLE_CACHING";
    public static String DEFAULT_WSA_NAMESPACE_PARAM = "DEFAULT_WSA_NAMESPACE";
    private static final String MF_FAILOVER_IDENTITY = System.getProperty("com.sonicsw.xq.connection.mf_failover_identity");
    private static XQContainer s_instance;
    private static String s_xqContainerName;
    private static String s_xqConfigContainerName;
    private static String s_mfContainerName;
    private static String s_mfComponentName;
    private static String s_mfFailoverIdentity;
    private static String s_domainName;
    private static String s_location;
    private static boolean s_bUseIntraContainer;
    private static boolean s_testContainerMode;
    private static String s_defaultWSANamespace;
    private static boolean s_cacheEnabledFlagSet;
    private static boolean s_cacheEnabled;
    private static boolean s_actionalEnabled;
    private static boolean s_payloadCaptureEnabled;
    private static boolean s_legacyPayloadReportingModeEnabled;
    private static boolean s_enhancedStepReportingModeEnabled;
    private static boolean s_displayUnmanagedJmsNodes;
    private static String[] s_payloadCaptureMimes;
    private static boolean s_intraContainerMessageAcceptedOnStop;
    private static boolean s_waitForServiceToStartBeforeICMDispatch;
    private static boolean s_enterpriseLicense;
    private static String s_jmsDefaultConnName;
    private static String s_httpDefaultConnName;
    private static XQConnectionConfig s_jmsDefaultConnConfig;
    private static XQConnectionConfig s_httpDefaultConnConfig;
    private static XQIntrinsicServicesHelper s_intrinsicServicesHelper;
    private static XQServiceTypeHelper s_serviceTypeHelper;
    private XQLog m_log = null;
    private XQTransientNamingService m_tns = null;
    private XQAppManager m_appManager;
    private EndpointManager m_epManager;
    private IMetricsRegistrar m_metricsRegistrar;
    private AccessorFactory m_accessorFactory;
    private XQMessageFactory m_messageFactory;
    private boolean m_initSuccess = false;
    private boolean m_startCalled = false;
    private ContainerLifeCycleManager m_lifecycleMgr;
    private String m_configElemName;
    private String m_actionalVisitorFactoryClassName;
    private XQLog4jConfigurator m_log4jConfigurator;
    private ConfigurableApplicationContext m_rootAppContext;
    private static Boolean s_reloadable;
    private static HashMap<String, Set<IElementChangeHandler>> s_serviceHandlerMap;
    private static SonicFsFileChangeManager s_fileChangeMgr;
    private static final ArrayList<MBeanAttributeInfo> ATTRIBUTE_INFOS;
    private static final ArrayList<MBeanOperationInfo> OPERATION_INFOS;
    private static final ArrayList<MBeanNotificationInfo> NOTIFICATION_INFOS;
    public static final String ENABLE_UNMANAGED_JMS_NODES = "actional.interceptor.enableUnmanagedJmsNodes";
    public static final String ENABLE_LEGACY_PAYLOAD_MODE = "actional.interceptor.legacyPayloadReportingModeEnabled";
    public static final String ENABLE_ENHANCED_STEP_MODE = "actional.interceptor.enhancedStepReportingModeEnabled";
    private static final String CAPTURE_PAYLOAD_MIME_TYPES = "actional.interceptor.capturePayloadMimeTypes";
    private static Map<IMetricIdentity, IMetricInfo> s_metricInfos;
    private static Map<IMetricIdentity, IStatistic> s_globalStatistics;
    private static HashMap<IMetricIdentity, List<String>> s_instanceMetrics;
    private static MitigationContextFactory s_mitigationCtxFactory;
    public static final EndpointCallBehaviour EP_CALL_FORCE_ALO;
    public static final EndpointCallBehaviour EP_CALL_FORCE_ALOF;
    public static final EndpointCallBehaviour EP_CALL_FORCE_BE;
    public static final EndpointCallBehaviour EP_CALL_FORCE_BED;
    public static final EndpointCallBehaviour EP_CALL_USE_EP_DEFINITION;
    private static EndpointCallBehaviour s_EndpointCallBehaviour;
    private static final XQConfigManager.IBusConnectionLookup XQContainerBusConnectionLookup;
    ProcessEngine processEngine;
    private CacheManager m_cacheManager;
    private XQAddressFactoryImpl m_addrFactory;

    public synchronized void init(IComponentContext context) {
        String additionalMimeTypes;
        super.init(context);
        if (Boolean.getBoolean("com.sonicsw.xq.container.debug_init")) {
            try {
                System.out.println(">>>>> PRESS ENTER TO CONTINUE ...");
                LineNumberReader lnr = new LineNumberReader(new InputStreamReader(System.in));
                lnr.readLine();
            }
            catch (Exception lnr) {
                // empty catch block
            }
        }
        this.m_initSuccess = true;
        context.clearErrorCondition();
        this.m_startCalled = false;
        this.m_log = XQLogImpl.getInstance((IComponentContext)context);
        ((XQLogImpl)this.m_log).setTraceMask(this.getTraceMask());
        this.initTestCallbackManager();
        this.initWSAdefaultAttribute();
        this.initTestContainerAttribute();
        this.initCacheEnabledAttribute();
        this.initEndpointcallBehaviorAttribute();
        XQProcessConfig.setParseInterfaceDefinitionMode((boolean)false);
        XQServiceConfig.setParseInterfaceDefinitionMode((boolean)false);
        this.m_tns = new XQTransientNamingService(context, !XQContainer.isCacheEnabled());
        this.m_tns.init();
        XQConfigManager xqConfigMgr = XQConfigManager.getInstance(null);
        xqConfigMgr.setComponentContext(context);
        xqConfigMgr.setCacheEnabled(XQContainer.isCacheEnabled());
        xqConfigMgr.setBusConnectionLookup(XQContainerBusConnectionLookup);
        this.m_messageFactory = new XQMessageFactoryImpl();
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        ClassLoaderManager.init((ClassLoader)cl);
        EsbClassLoader esbClassLoader = ClassLoaderManager.getInstance().getDefaultClassLoader();
        this.m_epManager = EndpointManager.getInstance();
        this.m_epManager.init(esbClassLoader, this.m_messageFactory, xqConfigMgr);
        XQContainerConfig config = null;
        try {
            this.m_accessorFactory = AccessorFactory.getInstance();
            this.m_accessorFactory.init(new XQEndpointManagerImpl(null, null));
            this.m_configElemName = context.getConfiguration(true).getIdentity().getName();
            config = this.lookupContainerConfig(xqConfigMgr);
            s_xqConfigContainerName = config.getName();
            s_xqContainerName = config.getXQContainerName();
            s_bUseIntraContainer = config.useIntraContainer();
            if (s_bUseIntraContainer) {
                this.m_log.logInformation("Intra-container messaging is enabled ..");
            }
            s_jmsDefaultConnName = XQContainer.evaluateELExpression(config.getJMSDefaultConnection());
            s_httpDefaultConnName = config.getHTTPDefaultConnection();
            s_intrinsicServicesHelper = new XQIntrinsicServicesHelper();
            s_serviceTypeHelper = new XQServiceTypeHelper();
            this.checkIfActionalEnabled(config);
            if (s_jmsDefaultConnName != null && s_jmsDefaultConnName.trim().length() != 0) {
                s_jmsDefaultConnConfig = this.retrieveXQConnectionConfig(s_jmsDefaultConnConfig, xqConfigMgr, s_jmsDefaultConnName);
            }
            if (s_httpDefaultConnName != null && s_httpDefaultConnName.trim().length() != 0) {
                s_httpDefaultConnConfig = this.retrieveXQConnectionConfig(s_httpDefaultConnConfig, xqConfigMgr, s_httpDefaultConnName);
            }
        }
        catch (Throwable e) {
            String message = "Error initializing container " + e.getMessage();
            this.m_log.logError(message);
            this.m_log.logError(e);
            this.m_initSuccess = false;
            context.registerErrorCondition(message, 1);
        }
        if (!this.m_initSuccess) {
            return;
        }
        XQLicenseHelper licenseHelper = null;
        try {
            licenseHelper = new XQLicenseHelper(xqConfigMgr);
            licenseHelper.validate();
            s_enterpriseLicense = licenseHelper.isEnterprise();
            this.m_log.logInformation(s_xqContainerName + " initializing..." + licenseHelper.getLicenseText());
        }
        catch (Exception e) {
            context.registerErrorCondition("Error Validating License Key: " + e.getMessage(), 1);
            this.m_log.logError("Error Validating License Key: " + e.getMessage());
            this.m_initSuccess = false;
            return;
        }
        XQGlobalConfig globalCfg = XQGlobalConfig.getGlobalConfig();
        String s = System.getProperty(ENABLE_UNMANAGED_JMS_NODES);
        if (s != null) {
            s_displayUnmanagedJmsNodes = new Boolean(s);
        } else if (globalCfg != null) {
            s_displayUnmanagedJmsNodes = globalCfg.isUnmanagedJMSNodesEnabled();
        }
        s = System.getProperty(ENABLE_LEGACY_PAYLOAD_MODE);
        if (s != null) {
            s_legacyPayloadReportingModeEnabled = new Boolean(s);
        } else if (globalCfg != null) {
            s_legacyPayloadReportingModeEnabled = globalCfg.isLegacyPayloadReportingModeEnabled();
        }
        s = System.getProperty(ENABLE_ENHANCED_STEP_MODE);
        if (s != null) {
            s_enhancedStepReportingModeEnabled = new Boolean(s);
        } else if (globalCfg != null) {
            s_enhancedStepReportingModeEnabled = globalCfg.isEnhancedStepReportingModeEnabled();
        }
        String[] mimeVals = null;
        s = System.getProperty(CAPTURE_PAYLOAD_MIME_TYPES);
        if (s != null) {
            mimeVals = s.split(",");
        } else if (globalCfg != null && (additionalMimeTypes = globalCfg.getPayloadCaptureMimeTypes()) != null) {
            mimeVals = additionalMimeTypes.split(",");
        }
        if (mimeVals != null && mimeVals.length > 0) {
            ArrayList<String> mimeValList = new ArrayList<String>();
            for (int i = 0; i < mimeVals.length; ++i) {
                String trimmedVal = mimeVals[i].trim();
                if (trimmedVal.length() <= 0) continue;
                mimeValList.add(trimmedVal);
            }
            if (!mimeValList.isEmpty()) {
                s_payloadCaptureMimes = mimeValList.toArray(new String[0]);
            }
        }
        if (globalCfg != null) {
            String globalXQJMSMessageMapperOverrideUrl = globalCfg.getXQJMSMappingOverrideURL();
            if (globalXQJMSMessageMapperOverrideUrl != null && globalXQJMSMessageMapperOverrideUrl.trim().length() > 0) {
                GlobalContentTypeJMSMapperOverride.init(globalXQJMSMessageMapperOverrideUrl);
            }
            s_intraContainerMessageAcceptedOnStop = globalCfg.isIntraContainerMessageAcceptedOnStop();
            s_waitForServiceToStartBeforeICMDispatch = globalCfg.isWaitForServiceToStartBeforeICMDispatch();
        }
        ICanonicalName mfComponentCanonicalName = context.getComponentName();
        s_domainName = mfComponentCanonicalName.getDomainName();
        s_mfContainerName = mfComponentCanonicalName.getContainerName();
        s_mfComponentName = mfComponentCanonicalName.getComponentName();
        s_mfFailoverIdentity = this.getMfFailoverIdentity(context);
        s_fileChangeMgr = new SonicFsFileChangeManager(context, this.m_log);
        s_instance = this;
        this.initLog4j(config);
        this.initializeApplicationContext(config);
        this.processEngine = PEConfigUtil.setupForProcessEngineInitialization(this.m_rootAppContext);
        this.m_appManager = new XQAppManager();
        this.initializeContainerLifecycleManager();
        if (s_testContainerMode) {
            ClassLoaderManager.getInstance().configureRunDebugClasspaths();
        }
        int initialized = this.m_appManager.init(config, mfComponentCanonicalName, s_mfFailoverIdentity, this.m_accessorFactory, this.m_messageFactory, this.m_lifecycleMgr, this.m_rootAppContext);
        int expected = config.getServiceApplications().size();
        if (expected > initialized) {
            String message = "Failed to start one or more service applications";
            this.m_log.logError(message);
            context.registerErrorCondition(message, 1);
        }
        this.registerDefaultMetrics();
        this.registerDefaultNotifications();
        this.initMetrics(context);
        this.initializeVisitorFactoryChain();
        this.initializeActionalVisitor(false);
        this.initializeMitigationContextFactory();
        ((XQLogImpl)this.m_log).logSysInfo();
        this.m_addrFactory = new XQAddressFactoryImpl(null, -1);
        PEConfigUtil.validateProcessEngineConfig(this.processEngine);
        this.m_cacheManager = new CacheManager();
    }

    private XQConnectionConfig retrieveXQConnectionConfig(XQConnectionConfig connectionConfigParam, XQConfigManager xqConfigMgr, String connectionName) {
        XQConnectionConfig connectionConfig = connectionConfigParam;
        try {
            connectionConfig = xqConfigMgr.lookupConnectionConfig(connectionName.trim());
        }
        catch (XQConfigurationException e) {
            this.m_log.logWarning((Throwable)e);
        }
        return connectionConfig;
    }

    private static String evaluateELExpression(String expression) {
        if (expression == null) {
            return null;
        }
        ELExpressionFactory exprFactory = ELUtils.createExpressionFactory();
        ExpressionContext exprCtx = exprFactory.createContext();
        ELUtils.prepareDefaultExpressionContext(exprCtx, null, null);
        Expression expr = exprFactory.createExpression(exprCtx, expression);
        Object val = expr.getValue(exprCtx);
        return val == null ? "" : val.toString();
    }

    private String getMfFailoverIdentity(IComponentContext context) {
        if (null != MF_FAILOVER_IDENTITY) {
            return MF_FAILOVER_IDENTITY;
        }
        IElement containerConfig = context.getContainerConfiguration(false);
        IAttributeSet ftParams = (IAttributeSet)containerConfig.getAttributes().getAttribute("FAULT_TOLERANCE_PARAMETERS");
        if (ftParams != null) {
            Reference peerReference;
            String peerName;
            IElement peerConfiguration;
            String ftRole = (String)ftParams.getAttribute("FAULT_TOLERANCE_ROLE");
            if ("PRIMARY".equals(ftRole)) {
                return (String)containerConfig.getAttributes().getAttribute("CONTAINER_NAME");
            }
            if ("BACKUP".equals(ftRole) && null != (peerConfiguration = context.getConfiguration(peerName = (peerReference = (Reference)ftParams.getAttribute("FAULT_TOLERANCE_PEER_REF")).getElementName(), false))) {
                return (String)peerConfiguration.getAttributes().getAttribute("CONTAINER_NAME");
            }
        }
        return null;
    }

    private XQContainerConfig lookupContainerConfig(XQConfigManager xqConfigMgr) throws XQConfigurationException {
        int index;
        IElement configuration = this.m_context.getConfiguration(true);
        String name = (String)configuration.getAttributes().getAttribute("config_uri");
        if (name == null && (index = (name = this.m_configElemName).lastIndexOf(47)) != -1) {
            name = name.substring(index + 1, name.length());
        }
        return xqConfigMgr.lookupContainerConfig(name);
    }

    public static XQContainer getInstance() {
        return s_instance;
    }

    public static ProcessEngine getProcessEngine() {
        return XQContainer.getInstance().processEngine;
    }

    public CacheManager getCacheManager() {
        return this.m_cacheManager;
    }

    public static XQAddressFactoryImpl getAddressFactory() {
        return XQContainer.s_instance.m_addrFactory;
    }

    private void initLog4j(XQContainerConfig config) {
        this.m_log4jConfigurator = new XQLog4jConfigurator(s_fileChangeMgr, this.m_log);
        this.m_log4jConfigurator.setEsbContainerName(XQContainer.getXQContainerName());
        this.m_log4jConfigurator.setConfiguration(config.getLog4jConfiguration());
    }

    private void initializeContainerLifecycleManager() {
        this.m_lifecycleMgr = new ContainerLifeCycleManager(this, this.m_log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMitigationContextFactory() {
        IAttributeSet modeSet;
        HashMap params;
        String classname = "com.sonicsw.xqimpl.actional.lg.visitor.StabilizerHelper";
        IAttributeSet deploymentParameters = this.m_context.getDeploymentParameters();
        HashMap hashMap = params = deploymentParameters == null ? new HashMap() : deploymentParameters.getAttributes();
        if (deploymentParameters != null && (modeSet = (IAttributeSet)deploymentParameters.getAttribute("STABILIZER_FACTORY")) != null) {
            classname = (String)modeSet.getAttribute("VALUE");
        }
        Object obj = null;
        try {
            this.m_log.logInformation("Initializing Mitigation context factory class: " + classname);
            Class<?> clazz = Class.forName(classname);
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            this.m_log.logInformation("Could not create stabilizer factory class, skipping: " + classname);
            this.m_log.logDebug((Throwable)e);
        }
        if (obj != null && obj instanceof MitigationContextFactory) {
            MitigationContextFactory fact = obj;
            if (fact.initialize(params)) {
                Class<XQContainer> clazz = XQContainer.class;
                synchronized (XQContainer.class) {
                    s_mitigationCtxFactory = fact;
                    // ** MonitorExit[var6_7] (shouldn't be in output)
                }
            }
        } else {
            this.m_log.logInformation("Specified class is not an instance of MitigationContextFactory, skipping: " + classname);
        }
    }

    public static MitigationContextFactory getMitigationContextFactory() {
        return s_mitigationCtxFactory;
    }

    private void checkIfActionalEnabled(XQContainerConfig containerCfg) {
        String s = System.getProperty("com.sonicsw.xqimpl.actional.lg.visitor.enabled");
        s_actionalEnabled = s != null ? Boolean.parseBoolean(s) : containerCfg.getActionalConfig().isInterceptorEnabled();
        if (s_actionalEnabled) {
            s_payloadCaptureEnabled = containerCfg.getActionalConfig().isPayloadReportingEnabled();
        }
    }

    private void initializeVisitorFactoryChain() {
        IAttributeSet modeSet;
        HashMap params;
        IAttributeSet deploymentParameters = this.m_context.getDeploymentParameters();
        HashMap hashMap = params = deploymentParameters == null ? new HashMap() : deploymentParameters.getAttributes();
        if (deploymentParameters != null && (modeSet = (IAttributeSet)deploymentParameters.getAttribute("VISITOR_FACTORIES")) != null) {
            String visitorNames = (String)modeSet.getAttribute("VALUE");
            StringTokenizer st = new StringTokenizer(visitorNames, ",");
            while (st.hasMoreElements()) {
                String tok = st.nextToken();
                ESBVisitorChain.addVisitorFactory((String)tok, params);
            }
        }
    }

    private synchronized void initializeActionalVisitor(boolean configChanged) {
        IAttributeSet deploymentParameters = this.m_context.getDeploymentParameters();
        HashMap params = deploymentParameters == null ? new HashMap() : deploymentParameters.getAttributes();
        this.m_log.logInformation("Actional instrumentation is " + (s_actionalEnabled ? "enabled" : "disabled") + " for this container");
        if (s_actionalEnabled) {
            IAttributeSet modeSet;
            this.m_log.logInformation("Actional payload capture is " + (s_payloadCaptureEnabled ? "enabled." : "disabled."));
            if (s_payloadCaptureEnabled && s_payloadCaptureMimes != null) {
                this.m_log.logInformation("Additional MIME types supported for payload capture: " + StringUtil.deepToString((String[])s_payloadCaptureMimes));
            }
            this.m_actionalVisitorFactoryClassName = "com.sonicsw.xqimpl.actional.lg.visitor.ActionalVisitorFactory";
            if (deploymentParameters != null && (modeSet = (IAttributeSet)deploymentParameters.getAttribute("LOOKING_GLASS_VISITOR")) != null) {
                this.m_actionalVisitorFactoryClassName = (String)modeSet.getAttribute("VALUE");
            }
            ESBVisitorChain.addVisitorFactory((String)this.m_actionalVisitorFactoryClassName, params);
        }
        if (configChanged) {
            if (!s_actionalEnabled) {
                ESBVisitorChain.removeVisitorFactory((String)this.m_actionalVisitorFactoryClassName);
            }
            EndpointManager.getInstance().setActionalFlag();
        }
    }

    private void initializeApplicationContext(XQContainerConfig config) {
        GenericApplicationContext rootCtx = ESBSpringUtils.createApplicationContext("ESBRootApplicationContext");
        rootCtx.getBeanFactory().registerSingleton("xqLog", (Object)this.m_log);
        rootCtx.getBeanFactory().registerSingleton("xqConfigManager", (Object)XQConfigManager.getInstance(null));
        rootCtx.getBeanFactory().registerSingleton("containerComponentContext", (Object)this.m_context);
        rootCtx.getBeanFactory().registerSingleton("fileChangeManager", (Object)s_fileChangeMgr);
        ArrayList<String> configs = new ArrayList<String>();
        String springConfig = config.getSpringConfiguration();
        if (springConfig != null) {
            StringTokenizer tok = new StringTokenizer(springConfig, ";");
            while (tok.hasMoreTokens()) {
                configs.add(tok.nextToken());
            }
        }
        rootCtx.getBeanFactory().registerSingleton("sharedApplicationContextConfigs", configs);
        rootCtx.refresh();
        this.m_rootAppContext = rootCtx;
    }

    private void initTestCallbackManager() {
        if (this.m_context == null) {
            return;
        }
        IAttributeSet deploymentParameters = this.m_context.getDeploymentParameters();
        if (deploymentParameters == null) {
            return;
        }
        IAttributeSet testCallbackAttribute = (IAttributeSet)deploymentParameters.getAttribute(TEST_CALLBACK_PARAM);
        if (testCallbackAttribute == null) {
            return;
        }
        String callbackValue = (String)testCallbackAttribute.getAttribute("VALUE");
        TestCallbackManager.setCallback(callbackValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWSAdefaultAttribute() {
        IAttributeSet addSet;
        IAttributeSet deploymentParameters = this.m_context.getDeploymentParameters();
        if (deploymentParameters != null && (addSet = (IAttributeSet)deploymentParameters.getAttribute(DEFAULT_WSA_NAMESPACE_PARAM)) != null) {
            Class<XQContainer> clazz = XQContainer.class;
            synchronized (XQContainer.class) {
                s_defaultWSANamespace = (String)addSet.getAttribute("VALUE");
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
        Class<XQContainer> clazz = XQContainer.class;
        synchronized (XQContainer.class) {
            s_defaultWSANamespace = AddressingUtils.getDefaultNS();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void initTestContainerAttribute() {
        IAttributeSet modeSet;
        IAttributeSet deploymentParameters = this.m_context.getDeploymentParameters();
        if (deploymentParameters != null && (modeSet = (IAttributeSet)deploymentParameters.getAttribute(TEST_CONTAINER_MODE_PARAM)) != null) {
            String value = (String)modeSet.getAttribute("VALUE");
            s_testContainerMode = Boolean.valueOf(value);
            return;
        }
        s_testContainerMode = false;
    }

    private void initCacheEnabledAttribute() {
        IAttributeSet modeSet;
        IAttributeSet deploymentParameters = this.m_context.getDeploymentParameters();
        if (deploymentParameters != null && (modeSet = (IAttributeSet)deploymentParameters.getAttribute(CACHED_ENABLED_PARAM)) != null) {
            s_cacheEnabledFlagSet = true;
            String value = (String)modeSet.getAttribute("VALUE");
            s_cacheEnabled = Boolean.valueOf(value);
            return;
        }
    }

    private synchronized void initEndpointcallBehaviorAttribute() {
        String value;
        IAttributeSet modeSet;
        s_EndpointCallBehaviour = EP_CALL_FORCE_ALO;
        IAttributeSet deploymentParameters = this.m_context.getDeploymentParameters();
        if (deploymentParameters != null && (modeSet = (IAttributeSet)deploymentParameters.getAttribute(DEPLOYMENT_PARAM_EP_CALL_QOS)) != null && (s_EndpointCallBehaviour = EndpointCallBehaviour.getForName(value = (String)modeSet.getAttribute("VALUE"))) == null) {
            s_EndpointCallBehaviour = EP_CALL_FORCE_ALO;
            this.m_log.logWarning("EndpointCall value of :" + value + " is invalid. Using default:" + s_EndpointCallBehaviour.name);
        }
    }

    public static EndpointCallBehaviour getEndpointCallBehaviour() {
        return s_EndpointCallBehaviour;
    }

    public static String getDefaultWSANamespace() {
        return s_defaultWSANamespace;
    }

    public static boolean isTestContainer() {
        return s_testContainerMode;
    }

    public static boolean isActionalEnabled() {
        return s_actionalEnabled;
    }

    public static boolean isPayloadCaptureEnabled() {
        return s_payloadCaptureEnabled;
    }

    public static boolean isUnmanagedJmsNodesEnabled() {
        return s_displayUnmanagedJmsNodes;
    }

    public static boolean isLegacyPayloadReportingModeEnabled() {
        return s_legacyPayloadReportingModeEnabled;
    }

    public static boolean isEnhancedStepReportingModeEnabled() {
        return s_enhancedStepReportingModeEnabled;
    }

    public static String[] getAdditionalPayloadCaptureMimeTypes() {
        return s_payloadCaptureMimes == null ? s_payloadCaptureMimes : Arrays.copyOf(s_payloadCaptureMimes, s_payloadCaptureMimes.length);
    }

    public static boolean isCacheEnabled() {
        if (s_cacheEnabledFlagSet) {
            return s_cacheEnabled;
        }
        return !s_testContainerMode;
    }

    public static boolean isEnterpriseLicense() {
        return s_enterpriseLicense;
    }

    public static boolean isIntraContainerMessageAcceptedOnStop() {
        return s_intraContainerMessageAcceptedOnStop;
    }

    public static boolean isWaitForServiceToStartBeforeICMDispatch() {
        return s_waitForServiceToStartBeforeICMDispatch;
    }

    @Deprecated
    public static synchronized void registerFileChangeInterest(String path, FileChangeHandler handler) {
        s_fileChangeMgr.registerFileChangeInterest(path, handler);
    }

    @Deprecated
    public static synchronized void unregisterFileChangeInterest(String path, FileChangeHandler handler) {
        s_fileChangeMgr.unregisterFileChangeInterest(path, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void registerInterest(String elementName, IElementChangeHandler handler) {
        Set<IElementChangeHandler> handlerSet;
        if (s_serviceHandlerMap == null) {
            Class<XQContainer> clazz = XQContainer.class;
            // MONITORENTER : com.sonicsw.xqimpl.service.XQContainer.class
            if (s_serviceHandlerMap == null) {
                s_serviceHandlerMap = new HashMap();
            }
            // MONITOREXIT : clazz
        }
        if ((handlerSet = s_serviceHandlerMap.get(elementName)) == null) {
            handlerSet = new HashSet<IElementChangeHandler>();
        }
        handlerSet.add(handler);
        s_serviceHandlerMap.put(elementName, handlerSet);
    }

    public static void unregisterInterest(String elementName, IElementChangeHandler handler) {
        Set<IElementChangeHandler> handlerSet = s_serviceHandlerMap.get(elementName);
        handlerSet.remove(handler);
        if (handlerSet.isEmpty()) {
            s_serviceHandlerMap.remove(elementName);
        } else {
            s_serviceHandlerMap.put(elementName, handlerSet);
        }
    }

    public synchronized void handleElementChange(IElementChange elementChange) {
        if (elementChange == null) {
            return;
        }
        String elementName = elementChange.getElement().getIdentity().getName();
        if (elementName.equals(this.m_configElemName)) {
            this.handleContainerConfigChange(elementChange);
            return;
        }
        if (null == s_serviceHandlerMap) {
            return;
        }
        Set<IElementChangeHandler> nameHandlerSet = s_serviceHandlerMap.get(elementName);
        int lastSlash = elementName.lastIndexOf("/");
        String dirName = elementName.substring(0, lastSlash);
        Set<IElementChangeHandler> dirHandlerSet = s_serviceHandlerMap.get(dirName);
        if (nameHandlerSet != null) {
            this.handleChanges(nameHandlerSet, elementChange);
        }
        if (dirHandlerSet != null) {
            this.handleChanges(dirHandlerSet, elementChange);
        }
    }

    private void handleChanges(Set<IElementChangeHandler> dirHandlerSet, IElementChange elementChange) {
        for (IElementChangeHandler handler : dirHandlerSet) {
            handler.handleElementChange(elementChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleContainerConfigChange(IElementChange elementChange) {
        IBasicElement element = elementChange.getElement();
        if (element instanceof IDeltaElement) {
            IDeltaElement deltaElem = (IDeltaElement)element;
            IDeltaAttributeSet deltaAttrs = (IDeltaAttributeSet)deltaElem.getDeltaAttributes();
            String[] modifiedItems = deltaAttrs.getModifiedAttributesNames();
            for (int i = 0; i < modifiedItems.length; ++i) {
                String value;
                if (modifiedItems[i].equals("useForLookingGlass")) {
                    value = this.getNewValue(deltaAttrs, modifiedItems[i]);
                    if (value == null) continue;
                    s_actionalEnabled = Boolean.valueOf(value);
                    this.initializeActionalVisitor(true);
                    continue;
                }
                if (modifiedItems[i].equals("enablePayloadCapture")) {
                    value = this.getNewValue(deltaAttrs, modifiedItems[i]);
                    if (value == null) continue;
                    s_payloadCaptureEnabled = Boolean.valueOf(value);
                    this.m_log.logInformation("Actional payload capture is " + (s_payloadCaptureEnabled ? "enabled." : "disabled."));
                    continue;
                }
                if (!modifiedItems[i].equals("log4jConfiguration") || (value = this.getNewValue(deltaAttrs, modifiedItems[i])) == null) continue;
                ClassLoaderManager classloaderMgr = ClassLoaderManager.getInstance();
                ClassLoader oldLoader = ClassLoaderManager.setThreadContextClassLoader((ClassLoader)classloaderMgr.getDefaultClassLoader());
                try {
                    this.m_log.logInformation("Container log4j configuration attribute modified.");
                    if (this.m_log4jConfigurator == null) continue;
                    this.m_log4jConfigurator.setConfiguration(value);
                    continue;
                }
                finally {
                    ClassLoaderManager.setThreadContextClassLoader((ClassLoader)oldLoader);
                }
            }
        }
    }

    private String getNewValue(IDeltaAttributeSet deltaAttrs, String name) {
        try {
            return (String)deltaAttrs.getNewValue(name);
        }
        catch (Throwable e) {
            if (this.m_log.isDebugLoggingEnabled()) {
                this.m_log.logDebug("Unable to read new attribute value '" + name + "', ignoring change notification.");
            }
            return null;
        }
    }

    public static synchronized void setNonReloadable() {
        s_reloadable = Boolean.FALSE;
    }

    public Boolean getReloadable() {
        return s_reloadable;
    }

    public MBeanAttributeInfo[] getAttributeInfos() {
        return ATTRIBUTE_INFOS.toArray(IEmptyArray.EMPTY_ATTRIBUTE_INFO_ARRAY);
    }

    public MBeanOperationInfo[] getOperationInfos() {
        return OPERATION_INFOS.toArray(IEmptyArray.EMPTY_OPERATION_INFO_ARRAY);
    }

    public MBeanNotificationInfo[] getNotificationInfos() {
        return NOTIFICATION_INFOS.toArray(IEmptyArray.EMPTY_NOTIFICATION_INFO_ARRAY);
    }

    public static String getContainerName() {
        return s_xqConfigContainerName;
    }

    public static String getXQContainerName() {
        return s_xqContainerName;
    }

    public static String getMFContainerName() {
        return s_mfContainerName;
    }

    public static String getMFFailoverIdentity() {
        return s_mfFailoverIdentity;
    }

    public static String getMFComponentName() {
        return s_mfComponentName;
    }

    public static String getDomainName() {
        return s_domainName;
    }

    public synchronized void start() {
        if (this.m_state != 1) {
            return;
        }
        if (this.m_initSuccess && this.m_appManager != null) {
            this.m_lifecycleMgr.clearStateVariables();
            this.setXQState(XQState.STARTING);
            this.m_appManager.start();
            super.start();
            this.m_log.logInformation("Container's ESB (JMS) Connection: " + XQContainer.getJMSDefaultConnection());
            this.m_log.logInformation("Container's HTTP Routing Connection: " + XQContainer.getHTTPDefaultConnection());
            if (this.m_startCalled && this.m_log != null) {
                this.m_log.logInformation("Container resumed -- Status: online");
            }
        } else if (this.m_log != null) {
            this.m_log.logInformation("Container startup unsuccesful -- Status: offline");
        } else {
            System.out.println("Container startup unsuccesful -- Status: offline");
        }
        this.m_startCalled = true;
    }

    private static void dumpCoverageData() {
        try {
            Class<?> coverageClass = Class.forName("com.vladium.emma.rt.RT");
            Class[] paramTypes = new Class[]{File.class, Boolean.TYPE, Boolean.TYPE};
            Method coverageDumpMethod = coverageClass.getMethod("dumpCoverageData", paramTypes);
            Object[] paramVals = new Object[]{new File("coverage.ec"), Boolean.TRUE, Boolean.FALSE};
            coverageDumpMethod.invoke(coverageClass, paramVals);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void stop() {
        if (this.m_state == 1) {
            return;
        }
        this.setXQState(XQState.STOPPING);
        XQContainer.dumpCoverageData();
        if (this.m_appManager != null) {
            this.m_appManager.stop();
        }
        if (this.m_epManager != null) {
            this.m_epManager.disconnect();
        }
        super.stop();
        this.m_log.logInformation("Container suspended -- Status: offline");
    }

    void setXQState(XQState state) {
        super.setState(state.getState());
    }

    protected XQState getXQState() {
        Short stateVal = super.getState();
        return XQState.get((short)stateVal);
    }

    XQLog getLog() {
        return this.m_log;
    }

    public synchronized void destroy() {
        if (this.m_cacheManager != null) {
            this.m_cacheManager.shutdown();
            this.m_cacheManager = null;
        }
        if (this.m_appManager != null) {
            this.m_appManager.destroy();
            this.m_appManager = null;
        }
        if (this.m_tns != null) {
            this.m_tns.close();
            this.m_tns = null;
        }
        if (this.m_epManager != null) {
            this.m_epManager.releaseResources();
            this.m_epManager = null;
        }
        this.m_log = null;
        s_metricInfos.clear();
        s_globalStatistics.clear();
        this.m_metricsRegistrar = null;
        if (s_mitigationCtxFactory != null) {
            s_mitigationCtxFactory.terminate();
        }
        ESBVisitorChain.terminate();
        this.m_lifecycleMgr = null;
        TempDestinationCache.instance().clear();
        super.destroy();
    }

    public static synchronized String getLocation() {
        if (s_location == null) {
            try {
                s_location = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                s_location = "localhost";
            }
        }
        return s_location;
    }

    public static boolean useIntraContainer() {
        return s_bUseIntraContainer;
    }

    public static List getIntrinsicServices() {
        return s_intrinsicServicesHelper.getIntrinsicServices();
    }

    public static boolean isInternalContainerComponent(String serviceName) {
        return s_intrinsicServicesHelper.isIntrinsicServiceName(serviceName);
    }

    public static boolean isInternalContainerComponentType(String serviceType) {
        return s_intrinsicServicesHelper.isIntrinsicServiceType(serviceType);
    }

    public static boolean isHiddenComponentType(String serviceType) {
        return s_serviceTypeHelper.isHiddenServiceType(serviceType);
    }

    public static String getJMSDefaultConnection() {
        return s_jmsDefaultConnName;
    }

    public static String getHTTPDefaultConnection() {
        return s_httpDefaultConnName;
    }

    public static XQConnectionConfig getJMSDefaultConnConfig() {
        return s_jmsDefaultConnConfig;
    }

    public static XQConnectionConfig getHTTPDefaultConnConfig() {
        return s_httpDefaultConnConfig;
    }

    public static void addNotificationInfo(INotificationInfo info) {
        if (info instanceof MBeanNotificationInfo) {
            NOTIFICATION_INFOS.add((MBeanNotificationInfo)info);
        }
    }

    public static synchronized void registerMetricInfo(IMetricInfo info, IStatistic statistic) {
        s_metricInfos.put(info.getMetricIdentity(), info);
        s_globalStatistics.put(info.getMetricIdentity(), statistic);
    }

    public static synchronized void registerInstanceMetric(IMetricInfo info) {
        List<String> names = XQServiceMetrics.getServiceMetricInstanceNames(info, XQContainer.getInstance().getXQAppManager());
        s_metricInfos.put(info.getMetricIdentity(), info);
        s_instanceMetrics.put(info.getMetricIdentity(), names);
    }

    public static synchronized void registerInstanceMetric(IMetricInfo info, String service) {
        s_metricInfos.put(info.getMetricIdentity(), info);
        XQContainer.getServicesForMetric(info.getMetricIdentity()).add(service);
    }

    private static List<String> getServicesForMetric(IMetricIdentity id) {
        List<String> services = s_instanceMetrics.get(id);
        if (services == null) {
            services = new ArrayList<String>();
            s_instanceMetrics.put(id, services);
        }
        return services;
    }

    public String[] getInstanceMetricNames(IMetricIdentity id) {
        List<String> instances = XQContainer.getServicesForMetric(id);
        return instances.toArray(new String[0]);
    }

    public Object invokeMethod(String[] serviceId, String methodName, String[] paramTypes, Object[] paramVals) throws Exception {
        try {
            if (this.m_appManager != null) {
                return this.m_appManager.invokeMethod(serviceId, methodName, paramTypes, paramVals);
            }
        }
        catch (Exception ex) {
            this.m_log.logError((Throwable)ex);
            throw ex;
        }
        return null;
    }

    public Object invokeLifecycleMethod(String methodName, String[] inputParams) throws Exception {
        ESBArtifactInfo[] artifacts = null;
        if ("getArtifacts".equals(methodName)) {
            artifacts = this.getArtifacts();
        } else if ("stopServices".equals(methodName)) {
            artifacts = this.stopServices(inputParams);
        } else if ("startServices".equals(methodName)) {
            artifacts = this.startServices(inputParams);
        } else if ("abortServices".equals(methodName)) {
            artifacts = this.abortServices(inputParams);
        } else if ("reloadServices".equals(methodName)) {
            artifacts = this.reloadServices(inputParams);
        } else if ("stopProcesses".equals(methodName)) {
            artifacts = this.stopProcesses(inputParams);
        } else if ("startProcesses".equals(methodName)) {
            artifacts = this.startProcesses(inputParams);
        } else if ("abortProcesses".equals(methodName)) {
            artifacts = this.abortProcesses(inputParams);
        } else if ("reloadProcesses".equals(methodName)) {
            artifacts = this.reloadProcesses(inputParams);
        } else {
            if ("abortContainer".equals(methodName)) {
                return this.abortContainer();
            }
            if ("getServiceInfo".equals(methodName)) {
                return this.getServiceInfo(inputParams[0]);
            }
            if ("getProcessInfo".equals(methodName)) {
                return this.getProcessInfo(inputParams[0]);
            }
        }
        if (artifacts != null) {
            return artifacts;
        }
        throw new IllegalArgumentException("Method name " + methodName + " is not a supportedlifecycle operation");
    }

    public ESBArtifactInfo[] getArtifacts() {
        return this.m_lifecycleMgr.getArtifacts();
    }

    public ESBArtifactInfo[] stopServices(String[] serviceNames) {
        return this.m_lifecycleMgr.stopServices(serviceNames);
    }

    public ESBArtifactInfo[] startServices(String[] serviceNames) {
        return this.m_lifecycleMgr.startServices(serviceNames);
    }

    public ESBArtifactInfo[] abortServices(String[] serviceNames) {
        return this.m_lifecycleMgr.abortServices(serviceNames);
    }

    public ESBArtifactInfo[] reloadServices(String[] serviceNames) {
        return this.m_lifecycleMgr.reloadServices(serviceNames);
    }

    public ESBArtifactInfo[] stopProcesses(String[] processNames) {
        return this.m_lifecycleMgr.stopProcesses(processNames);
    }

    public ESBArtifactInfo[] startProcesses(String[] processNames) {
        return this.m_lifecycleMgr.startProcesses(processNames);
    }

    public ESBArtifactInfo[] abortProcesses(String[] processNames) {
        return this.m_lifecycleMgr.abortProcesses(processNames);
    }

    public ESBArtifactInfo[] reloadProcesses(String[] processNames) {
        return this.m_lifecycleMgr.reloadProcesses(processNames);
    }

    public Boolean abortContainer() {
        return this.m_lifecycleMgr.abortContainer();
    }

    public ESBArtifactInfo getServiceInfo(String serviceName) {
        return this.m_lifecycleMgr.getServiceInfo(serviceName);
    }

    public ESBArtifactInfo getProcessInfo(String processName) {
        return this.m_lifecycleMgr.getProcessInfo(processName);
    }

    public String[][] getServicesInfo() throws Exception {
        try {
            if (this.m_appManager != null) {
                return this.m_appManager.getServicesInfo();
            }
        }
        catch (Exception ex) {
            this.m_log.logError((Throwable)ex);
            throw ex;
        }
        return null;
    }

    XQAppManager getXQAppManager() {
        return this.m_appManager;
    }

    private void registerDefaultMetrics() {
        IMetricInfo[] standardInfos = XQServiceMetrics.getMetricInfos();
        for (int i = 0; i < standardInfos.length; ++i) {
            XQContainer.registerInstanceMetric(standardInfos[i]);
        }
    }

    private void registerDefaultNotifications() {
        INotificationInfo[] standardInfos = XQServiceNotifications.getNotificationInfos();
        for (int i = 0; i < standardInfos.length; ++i) {
            XQContainer.addNotificationInfo(standardInfos[i]);
        }
    }

    private void initMetrics(IComponentContext context) {
        ArrayList<IMetricInfo> infos = new ArrayList<IMetricInfo>();
        infos.addAll(s_metricInfos.values());
        IMetricInfo[] infoArray = infos.toArray(new IMetricInfo[0]);
        this.m_metricsRegistrar = context.initMetricsManagement(infoArray);
        this.m_metricsRegistrar.registerAlertNotificationProperties((short)2, null);
    }

    public void enableMetrics(IMetricIdentity[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            IMetricIdentity id = ids[i];
            IMetricInfo info = s_metricInfos.get(id);
            if (info.isInstanceMetric()) {
                this.refreshInstanceMetric(id);
                continue;
            }
            this.m_metricsRegistrar.registerMetric(id, s_globalStatistics.get(id));
        }
    }

    public void disableMetrics(IMetricIdentity[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            IMetricIdentity id = ids[i];
            IMetricInfo info = s_metricInfos.get(id);
            if (info.isInstanceMetric()) {
                this.refreshInstanceMetric(id);
                continue;
            }
            this.m_metricsRegistrar.unregisterMetric(id);
        }
    }

    private void refreshInstanceMetric(IMetricIdentity id) {
        if (this.m_appManager != null) {
            List<String> serviceNames = XQContainer.getServicesForMetric(id);
            for (String name : serviceNames) {
                XQServiceApplication serviceApplication = this.m_appManager.getServiceApplication(name);
                boolean enabled = this.checkInstanceMetricEnabled(id, name);
                if (enabled) {
                    serviceApplication.enableInstanceMetric(this.m_metricsRegistrar, id);
                    continue;
                }
                serviceApplication.disableInstanceMetric(this.m_metricsRegistrar, id);
            }
        }
    }

    private boolean checkInstanceMetricEnabled(IMetricIdentity id, String serviceName) {
        if (this.m_metricsRegistrar != null) {
            return this.m_metricsRegistrar.isInstanceEnabled(MetricsFactory.createMetricIdentity((IMetricIdentity)id, (String)serviceName));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void handleFileChange(IFSElementChange fileChange) {
        ClassLoaderManager classloaderMgr = ClassLoaderManager.getInstance();
        ClassLoader oldLoader = ClassLoaderManager.setThreadContextClassLoader((ClassLoader)classloaderMgr.getDefaultClassLoader());
        try {
            s_fileChangeMgr.handleFileChange(fileChange);
        }
        finally {
            ClassLoaderManager.setThreadContextClassLoader((ClassLoader)oldLoader);
        }
    }

    public void setTraceMask(Integer traceMask) {
        if (traceMask == null) {
            throw new IllegalArgumentException("null argument not supported");
        }
        super.setTraceMask(traceMask);
        if (this.m_log != null) {
            ((XQLogImpl)this.m_log).setTraceMask(traceMask);
        }
    }

    public String getTraceMaskValues() {
        return super.getTraceMaskValues() + "," + "16=Enable Debug Messages,32=WS Invocation Service Tracing,64=ESB Invocation Script Tracing,128=Message Dispatch Tracing,256=JMS Endpoint Tracing,512=ESB Container Tracing,1024=ESB Service Tracing,2048=Commons Logging Debug Tracing,4096=Commons Logging Informational Messages,8192=Commons Logging Warning Messages,16384=WS-RM Tracing,32768=Process Engine Tracing";
    }

    public Map<String, Map<String, Short>> getSubComponentStates() {
        ESBArtifactInfo[] artifacts = this.getArtifacts();
        HashMap<String, Map<String, Short>> outerMap = new HashMap<String, Map<String, Short>>();
        for (ESBArtifactInfo artifact : artifacts) {
            String type = artifact.getTypeAsString();
            HashMap<String, Short> innerMap = (HashMap<String, Short>)outerMap.get(type);
            if (innerMap == null) {
                innerMap = new HashMap<String, Short>();
                outerMap.put(type, innerMap);
            }
            innerMap.put(artifact.getName(), new Short((short)artifact.getCurrentState()));
        }
        return outerMap;
    }

    static {
        s_xqContainerName = null;
        s_xqConfigContainerName = null;
        s_mfContainerName = null;
        s_mfComponentName = null;
        s_domainName = null;
        s_location = null;
        s_bUseIntraContainer = true;
        s_testContainerMode = false;
        s_defaultWSANamespace = null;
        s_cacheEnabledFlagSet = false;
        s_cacheEnabled = true;
        s_actionalEnabled = false;
        s_payloadCaptureEnabled = false;
        s_legacyPayloadReportingModeEnabled = false;
        s_enhancedStepReportingModeEnabled = true;
        s_displayUnmanagedJmsNodes = false;
        s_intraContainerMessageAcceptedOnStop = true;
        s_waitForServiceToStartBeforeICMDispatch = true;
        s_enterpriseLicense = false;
        s_jmsDefaultConnConfig = null;
        s_httpDefaultConnConfig = null;
        s_intrinsicServicesHelper = null;
        s_serviceTypeHelper = null;
        s_reloadable = Boolean.TRUE;
        ATTRIBUTE_INFOS = new ArrayList();
        OPERATION_INFOS = new ArrayList();
        NOTIFICATION_INFOS = new ArrayList();
        s_metricInfos = new HashMap<IMetricIdentity, IMetricInfo>();
        s_globalStatistics = new HashMap<IMetricIdentity, IStatistic>();
        s_instanceMetrics = new HashMap();
        s_mitigationCtxFactory = null;
        EP_CALL_FORCE_ALO = new EndpointCallBehaviour("FORCE_ALO");
        EP_CALL_FORCE_ALOF = new EndpointCallBehaviour("FORCE_ALOF");
        EP_CALL_FORCE_BE = new EndpointCallBehaviour("FORCE_BE");
        EP_CALL_FORCE_BED = new EndpointCallBehaviour("FORCE_BED");
        EP_CALL_USE_EP_DEFINITION = new EndpointCallBehaviour("USE_EP_DEF");
        System.setProperty("java.naming.factory.initial", "com.sonicsw.xqimpl.jndi.spi.XQTNSContextFactory");
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("ContainerName", String.class.getName(), "The name of the container.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("Reloadable", Boolean.class.getName(), "Determines if the container is reloadable", true, false, false));
        MBeanParameterInfo[] mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("serviceId", String[].class.getName(), "serviceId[0] is service app name, serviceId[1] is service type name."), new MBeanParameterInfo("methodName", String.class.getName(), "Name of method to invoke."), new MBeanParameterInfo("paramTypes", String[].class.getName(), "String names of the parameter types of the signature of the method to be invoked."), new MBeanParameterInfo("paramVals", Object[].class.getName(), "The values of the parameters to pass into the method to be invoked.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("invokeMethod", "This operation executes a method of a service deployed in the ESB container.", mbParamInfos, Object.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("methodName", String.class.getName(), ""), new MBeanParameterInfo("paramVals", Object[].class.getName(), "")};
        OPERATION_INFOS.add(new MBeanOperationInfo("invokeLifecycleMethod", "This operation is deprecated.", mbParamInfos, Object.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("getServicesInfo", "This operation gets app names and type names of services deployed in the container.  Returns String[][] ret, where ret[i][0] is the app name and ret[i][1] is the type name for app i", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, String[][].class.getName(), 0));
        OPERATION_INFOS.add(new MBeanOperationInfo("getArtifacts", "This operation gets all the artifacts (services and processes) deployed in this ESB container.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, ESBArtifactInfo[].class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("serviceNames", String[].class.getName(), "An array of service names.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("stopServices", "This operation stops ESB services in the container.", mbParamInfos, ESBArtifactInfo[].class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("startServices", "This operation starts ESB services in the container.", mbParamInfos, ESBArtifactInfo[].class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("abortServices", "This operation aborts ESB services in the container.", mbParamInfos, ESBArtifactInfo[].class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("reloadServices", "This operation reloads ESB services in the container.", mbParamInfos, ESBArtifactInfo[].class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("processNames", String[].class.getName(), "An array of process names.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("stopProcesses", "This operation stops processes in the container.", mbParamInfos, ESBArtifactInfo[].class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("startProcesses", "This operation starts processes in the container.", mbParamInfos, ESBArtifactInfo[].class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("abortProcesses", "This operation aborts processes in the container.", mbParamInfos, ESBArtifactInfo[].class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("reloadProcesses", "This operation reloads processes in the container.", mbParamInfos, ESBArtifactInfo[].class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("abortContainer", "This operation aborts the ESB container.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Boolean.TYPE.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("serviceName", String.class.getName(), "The service name.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getServiceInfo", "This operation gets runtime information about a service deployed in the container.", mbParamInfos, ESBArtifactInfo.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("processName", String.class.getName(), "The process name.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getProcessInfo", "This operation gets runtime information about a process deployed in the container.", mbParamInfos, ESBArtifactInfo.class.getName(), 0));
        XQContainerBusConnectionLookup = new XQConfigManager.IBusConnectionLookup(){

            public String getBusConnectionName() {
                return XQContainer.getJMSDefaultConnection();
            }
        };
    }

    public static class EndpointCallBehaviour {
        private String name;
        private static final Map<String, EndpointCallBehaviour> name2Const = new HashMap<String, EndpointCallBehaviour>();

        public EndpointCallBehaviour(String name) {
            this.name = name;
            name2Const.put(name, this);
        }

        public static EndpointCallBehaviour getForName(String name) {
            return name2Const.get(name);
        }

        public String getName() {
            return this.name;
        }
    }
}

