/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.connector.jms.messagingbean;

import com.sonicsw.xq.connector.jms.messagingbean.MessagingBean;
import com.sonicsw.xq.connector.jms.messagingbean.Session;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.JMSException;

public final class SessionCollection {
    private final Map<String, Session> session_tbl = new HashMap<String, Session>();

    public Session addSession(Connection connection, Connection restrictedConnection, MessagingBean messagingBean, String sessionName, int nAckMode, boolean bTransacted, int flowToDisk) throws JMSException {
        if (messagingBean == null) {
            throw new JMSException("SessionCollection.addSession: connection is null");
        }
        Session session = new Session(sessionName, messagingBean, connection, restrictedConnection, nAckMode, bTransacted, flowToDisk);
        this.session_tbl.put(sessionName, session);
        return session;
    }

    public void closeAllSessions(boolean reconnect) {
        for (Session session : this.session_tbl.values()) {
            session.closeSession(reconnect);
        }
        this.session_tbl.clear();
    }

    public Session getSession(String sessionName) {
        if (sessionName == null) {
            return null;
        }
        return this.session_tbl.get(sessionName);
    }

    public String toString() {
        return "SessionCollection[num sessions=" + this.session_tbl.size() + "]";
    }
}

