/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.client.impl.interior;

import com.sonicsw.esb.client.FaultAndRMEReceiveOption;
import com.sonicsw.esb.client.impl.util.Utils;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressNotFoundException;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.container.Coordinator;
import com.sonicsw.xqimpl.container.ICorrelatedListener;
import com.sonicsw.xqimpl.container.IRegistration;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.envelope.AbstractAddressImpl;
import com.sonicsw.xqimpl.envelope.EnvelopeFactory;
import com.sonicsw.xqimpl.envelope.ProcessAddressImpl;
import com.sonicsw.xqimpl.envelope.ServiceAddressImpl;
import com.sonicsw.xqimpl.envelope.XQAddressImpl;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.util.log.XQLogImpl;

public class ExchangeDirector {
    private String m_templateEndpointName;
    private String m_apiId;
    private String m_tempExitEndpointName = null;
    private IRegistration m_tempExitEndpoint;
    private String m_tempFaultEndpointName = null;
    private IRegistration m_tempFaultEndpoint;
    private String m_tempRMEEndpointName = null;
    private IRegistration m_tempRMEEndpoint;
    private String m_tempReplyToEndpointName = null;
    private IRegistration m_tempReplyToEndpoint;
    private XQLog m_log = XQLogImpl.getCategoryLog((int)1024);
    private static String defaultTempEndpointType = "TOPIC";

    ExchangeDirector(String apiId, String templateEndpointName) {
        try {
            this.m_apiId = apiId;
            this.m_templateEndpointName = templateEndpointName;
            this.createTempEndpoints();
        }
        catch (Exception e) {
            this.m_log.logError((Throwable)e);
        }
    }

    public XQEnvelope createExchangeEnvelope(XQMessage msg, String correlationId, XQAddress addressee, FaultAndRMEReceiveOption option) throws XQServiceException, XQMessageException {
        XQAddress tempExitAddress = this.getTempAddress(this.m_tempExitEndpointName);
        XQAddress tempFaultAddress = this.getTempAddress(this.m_tempFaultEndpointName);
        XQAddress tempRMEAddress = this.getTempAddress(this.m_tempRMEEndpointName);
        XQAddress tempReplyToAddress = this.getTempAddress(this.m_tempReplyToEndpointName);
        AbstractAddressImpl processAddress = null;
        msg.setReplyTo(tempReplyToAddress);
        msg.setCorrelationId(correlationId);
        try {
            switch (addressee.getType()) {
                case 2: {
                    processAddress = new ProcessAddressImpl(addressee.getName());
                    break;
                }
                case 1: {
                    processAddress = new ServiceAddressImpl(addressee.getName());
                    break;
                }
                case 0: {
                    msg.setReplyTo(tempReplyToAddress);
                    XQEnvelope newEnv = new EnvelopeFactory().createTargetedEnvelope(addressee, msg);
                    return newEnv;
                }
                default: {
                    throw new IllegalArgumentException("Only service, process, or endpoint address types are supported.");
                }
            }
        }
        catch (XQAddressNotFoundException e) {
            throw new XQServiceException((Throwable)e);
        }
        processAddress.removeAllExitEndpoints();
        processAddress.addExitEndpoint(tempExitAddress);
        switch (option) {
            case FAULTS_AND_RMES: {
                processAddress.setFaultAddress(tempFaultAddress);
                processAddress.setRMEAddress(tempRMEAddress);
                break;
            }
            case RMES: {
                processAddress.setRMEAddress(tempRMEAddress);
                break;
            }
            case FAULTS: {
                processAddress.setFaultAddress(tempFaultAddress);
                break;
            }
        }
        XQEnvelope newEnv = new EnvelopeFactory().createTargetedEnvelope(processAddress, msg);
        return newEnv;
    }

    private XQAddress getTempAddress(String endpointName) {
        return new XQAddressImpl(endpointName, 0);
    }

    private void createTempEndpoints() throws Exception {
        String tempExitEndpointType = defaultTempEndpointType;
        this.m_tempExitEndpointName = this.m_apiId + ".Client." + "AsynchTmp.Exit";
        this.m_tempExitEndpoint = this.createTempEndpoint(this.m_tempExitEndpointName, tempExitEndpointType);
        String m_tempFaultEndpointType = defaultTempEndpointType;
        this.m_tempFaultEndpointName = this.m_apiId + ".Client." + "AsynchTmp.Fault";
        this.m_tempFaultEndpoint = this.createTempEndpoint(this.m_tempFaultEndpointName, m_tempFaultEndpointType);
        String m_tempRMEEndpointType = defaultTempEndpointType;
        this.m_tempRMEEndpointName = this.m_apiId + ".Client." + "AsynchTmp.RME";
        this.m_tempRMEEndpoint = this.createTempEndpoint(this.m_tempRMEEndpointName, m_tempRMEEndpointType);
        String m_tempReplyToEndpointType = defaultTempEndpointType;
        this.m_tempReplyToEndpointName = this.m_apiId + ".Client." + "AsynchTmp" + "." + "ReplyTo";
        this.m_tempReplyToEndpoint = this.createTempEndpoint(this.m_tempReplyToEndpointName, m_tempReplyToEndpointType);
    }

    private IRegistration createTempEndpoint(String epName, String destinationType) throws Exception {
        if (this.m_log.isDebugLoggingEnabled()) {
            this.m_log.logDebug("Creating temp destination " + destinationType + " " + epName);
        }
        XQConfigManager configManager = XQConfigManager.getInstance(null);
        XQEndpointConfig endpointConfig = null;
        if (this.m_templateEndpointName != null) {
            try {
                XQEndpointConfig templateConfig = (XQEndpointConfig)configManager.lookup(this.m_templateEndpointName, "endpoint");
                endpointConfig = Utils.createTempEndpointConfig(templateConfig, epName, destinationType);
            }
            catch (Exception templateConfig) {
                // empty catch block
            }
        }
        if (endpointConfig == null) {
            XQConnectionConfig conConfig = XQContainer.getJMSDefaultConnConfig();
            endpointConfig = EndpointManager.getInstance().createXQEndpointConfig(epName, epName, destinationType, conConfig.getName());
        }
        return Coordinator.getInstance().registerTmpDestination(endpointConfig);
    }

    public void setupMessageHandler(String correlationId, ICorrelatedListener handler) {
        this.m_tempExitEndpoint.registerMessageHandler(correlationId, handler);
        this.m_tempFaultEndpoint.registerMessageHandler(correlationId, handler);
        this.m_tempRMEEndpoint.registerMessageHandler(correlationId, handler);
        this.m_tempReplyToEndpoint.registerMessageHandler(correlationId, handler);
    }

    public void cleanupMessageHandler(String correlationId) {
        this.m_tempExitEndpoint.unRegisterMessageHandler(correlationId);
        this.m_tempFaultEndpoint.unRegisterMessageHandler(correlationId);
        this.m_tempRMEEndpoint.unRegisterMessageHandler(correlationId);
        this.m_tempReplyToEndpoint.unRegisterMessageHandler(correlationId);
    }
}

