/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.continuation;

import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQProcessContext;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.XQRuntimeProcess;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class ItineraryRuntimeInfo
implements XQRuntimeProcess {
    private ProcessInstanceProps m_procInstProps;

    public ItineraryRuntimeInfo() throws IOException {
        this.m_procInstProps = new ProcessInstanceProps(new Properties(), null);
    }

    public ItineraryRuntimeInfo(ProcessInstanceProps procInstProps) {
        this.m_procInstProps = procInstProps;
    }

    public ItineraryRuntimeInfo(XQProcessContext procCtx) {
        ItineraryRuntimeInfo.populateProcessInstanceProps(this.m_procInstProps, (XQRuntimeProcess)procCtx);
        this.m_procInstProps.setRootProcessName(procCtx.getTopProcessName());
        this.m_procInstProps.setProcessName(procCtx.getName());
    }

    ProcessInstanceProps getProcessInstanceProps() {
        return this.m_procInstProps;
    }

    public XQAddress getEventAddress() {
        return this.m_procInstProps.getTrackingEndpoint();
    }

    public Iterator<XQAddress> getExitEndpoints() {
        return this.m_procInstProps.getExitAddresses().iterator();
    }

    public XQAddress getFaultAddress() {
        return this.m_procInstProps.getFaultAddress();
    }

    public Properties getInflightProperties() {
        return this.m_procInstProps.getInflightProps();
    }

    public XQQualityofService getQualityofService() {
        return this.m_procInstProps.getQualityOfService();
    }

    public XQAddress getRMEAddress() {
        return this.m_procInstProps.getRMEAddress();
    }

    public String getStepName() {
        return this.m_procInstProps.getStepName();
    }

    public long getTTL() {
        return this.m_procInstProps.getTTL();
    }

    public String getTrackingID() {
        return this.m_procInstProps.getTrackingId();
    }

    public int getTrackingLevel() {
        return this.m_procInstProps.getTrackingLevel();
    }

    public void addExitEndpoint(XQAddress address) {
        Set<XQAddress> exits = this.m_procInstProps.getExitAddresses();
        exits.add(address);
    }

    public void removeAllExitEndpoints() {
        Set<XQAddress> exits = this.m_procInstProps.getExitAddresses();
        exits.clear();
    }

    public void removeExitEndpoint(XQAddress address) {
        Set<XQAddress> exits = this.m_procInstProps.getExitAddresses();
        exits.remove(address);
    }

    public void setEventAddress(XQAddress eventAddress) {
        this.m_procInstProps.setTrackingEndpoint(eventAddress);
    }

    public void setFaultAddress(XQAddress faultAddress) {
        this.m_procInstProps.setFaultAddress(faultAddress);
    }

    public void setInflightProperties(Properties props) {
        this.m_procInstProps.setInflightProperties(props);
    }

    public void setRMEAddress(XQAddress rmeAddress) {
        this.m_procInstProps.setRMEAddress(rmeAddress);
    }

    public void setTTL(long newTTL) {
        this.m_procInstProps.setTTL(newTTL);
    }

    public void setTrackingID(String newID) {
        this.m_procInstProps.setTrackingId(newID);
    }

    public void setTrackingLevel(int newLevel) {
        this.m_procInstProps.setTrackingLevel(newLevel);
    }

    static void populateProcessInstanceProps(ProcessInstanceProps procInstProps, XQRuntimeProcess itinRuntime) {
        Iterator iter = itinRuntime.getExitEndpoints();
        HashSet<XQAddress> exitAddresses = new HashSet<XQAddress>();
        while (iter != null && iter.hasNext()) {
            exitAddresses.add((XQAddress)iter.next());
        }
        procInstProps.setExitAddresses(exitAddresses);
        procInstProps.setFaultAddress(itinRuntime.getFaultAddress());
        procInstProps.setRMEAddress(itinRuntime.getRMEAddress());
        procInstProps.setInflightProperties(itinRuntime.getInflightProperties());
        procInstProps.setTrackingEndpoint(itinRuntime.getEventAddress());
        procInstProps.setTrackingId(itinRuntime.getTrackingID());
        procInstProps.setTrackingLevel(itinRuntime.getTrackingLevel());
        procInstProps.setTTL(itinRuntime.getTTL());
        procInstProps.setStepName(itinRuntime.getStepName());
        Properties inflightProps = procInstProps.getInflightProps();
        if (inflightProps != null) {
            procInstProps.setInflightProperties(inflightProps);
            procInstProps.insertInflightProps(procInstProps.getAllProcessProps());
        }
    }
}

