/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.engine;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.itinerary.model.EsbStepNode;
import com.sonicsw.esb.itinerary.model.FaultNode;
import com.sonicsw.esb.itinerary.model.ItineraryEndNode;
import com.sonicsw.esb.itinerary.model.ResubmitNode;
import com.sonicsw.esb.itinerary.model.RethrowNode;
import com.sonicsw.esb.itinerary.model.TerminateStepNode;
import com.sonicsw.esb.process.engine.ProcessChangeListener;
import com.sonicsw.esb.process.engine.ProcessState;
import com.sonicsw.esb.process.model.ActivityEdge;
import com.sonicsw.esb.process.model.ActivityNode;
import com.sonicsw.esb.process.model.TerminateNode;
import com.sonicsw.esb.process.model.Token;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;

public class ProcessTrackerNotifier
implements ProcessChangeListener {
    @Override
    public void activityClosed(Token token, ActivityNode node) {
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (procInst.getTrackingLevel() >= 2 && procInst.getTrackingLevel() != 5 && (node instanceof FaultNode || node instanceof ResubmitNode || node instanceof RethrowNode || node instanceof TerminateNode || node instanceof ItineraryEndNode && !((ItineraryEndNode)node).isImplicit())) {
            this.sendTrackingMessage(token, "SERVICE_EXIT", ((EsbMessageExchange)token.getData()).getInputMessage(), procInst, 2);
        }
    }

    @Override
    public void activityStarted(Token token, ActivityNode activity) {
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (procInst.getTrackingLevel() >= 2 && procInst.getTrackingLevel() != 5 && (activity instanceof EsbStepNode && ((EsbStepNode)activity).getEndpointRef(token).getType() != 2 || activity instanceof TerminateStepNode || activity instanceof ItineraryEndNode && !((ItineraryEndNode)activity).isImplicit())) {
            this.sendTrackingMessage(token, "SERVICE_ENTRY", ((EsbMessageExchange)token.getData()).getInputMessage(), procInst, 2);
        }
    }

    @Override
    public void activityTerminated(Token token, ActivityNode activity) {
    }

    @Override
    public void errorOccurred(Token token, String message) {
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (procInst != null && procInst.getTrackingLevel() >= 1) {
            this.sendTrackingMessage(token, "SERVICE_ERROR", ((EsbMessageExchange)token.getData()).getInputMessage(), procInst, 1);
        }
    }

    @Override
    public void processStateChanged(Token token, ProcessState newState) {
        XQProcessInstance procInst = (XQProcessInstance)token.getProcessInstance();
        if (procInst.getTrackingLevel() >= 1) {
            if (newState == ProcessState.OPEN) {
                this.processInstanceStarted(token, procInst);
            } else if (newState == ProcessState.CLOSED || newState == ProcessState.ABANDONED) {
                this.processInstanceComplete(token, procInst);
            } else if (newState == ProcessState.ERROR) {
                this.processInstanceError(token);
            } else if (newState == ProcessState.TERMINATED) {
                this.sendTrackingMessage(token, "PROCESS_TERMINATED", null, procInst, 1);
            }
        }
    }

    @Override
    public void transitionFired(Token token, ActivityEdge transition) {
    }

    private void processInstanceStarted(Token token, XQProcessInstance procInst) {
        String processName = procInst.getProcessDefinition().getProcessName();
        XQParameters params = ((EsbMessageExchange)token.getData()).getXQParameters();
        params.setParameter("SonicXQ.ProcessName", 1, processName);
        try {
            ActivityNode firstNode = procInst.getProcessDefinition().getInitialNode().getOutgoingEdges()[0].getDestination();
            params.setParameter("SonicXQ.ProcessStep", 1, procInst.getCompleteStepName(firstNode.getDisplayName()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.sendTrackingMessage(token, "PROCESS_ENTRY", ((EsbMessageExchange)token.getData()).getInputMessage(), procInst, 1);
    }

    private void processInstanceComplete(Token token, XQProcessInstance procInst) {
        if (token.removeProperty("MULTIPLE_TOKEN") == null) {
            String processName = procInst.getProcessDefinition().getProcessName();
            ((EsbMessageExchange)token.getData()).getXQParameters().setParameter("SonicXQ.ProcessName", 1, processName);
            this.sendTrackingMessage(token, "PROCESS_EXIT", null, procInst, 1);
        }
    }

    public void processInstanceError(Token token) {
    }

    protected void sendTrackingMessage(Token token, String msgText, XQMessage message, XQProcessInstance procInst, int minimumTrackingLevel) {
        EsbMessageExchange mex = (EsbMessageExchange)token.getData();
        procInst.getprocessTracker().sendTrackingMessage(msgText, message, null, mex, minimumTrackingLevel);
    }
}

