/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.endpoint.container.jca;

import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQConnectionTypeConfig;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.config.XQJCADeploymentHelper;
import com.sonicsw.xqimpl.endpoint.container.jca.JCA1_0Connection;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAConnection;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAConnectionManager;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAInterimConnection;
import java.net.URLClassLoader;

public class JCAConnectionFactory {
    private URLClassLoader m_parentClassLoader;
    private XQLog m_log;
    private XQMessageFactory m_messageFactory;

    public JCAConnectionFactory(URLClassLoader parentClassLoader, XQLog log, XQMessageFactory messageFactory) {
        this.m_parentClassLoader = parentClassLoader;
        this.m_log = log;
        this.m_messageFactory = messageFactory;
    }

    public JCAConnection createConnection(XQEndpointConfig config, JCAConnectionManager connectionManager) throws XQEndpointCreationException {
        try {
            XQConfigManager configManager = XQConfigManager.getInstance(null);
            XQConnectionConfig connectionConfig = this.lookupConnection(configManager, config);
            XQConnectionTypeConfig typeConfig = this.lookupConnectionType(configManager, connectionConfig);
            XQJCADeploymentHelper jcaDeployment = typeConfig.getJCADeployment();
            if (jcaDeployment == null) {
                throw new XQEndpointCreationException("Bad connection configuration: ");
            }
            String specVersion = jcaDeployment.getSpecVersion();
            if (specVersion.equals("JCA 1.0")) {
                return new JCA1_0Connection(this.m_parentClassLoader, connectionConfig, typeConfig, this.m_log, connectionManager, this.m_messageFactory);
            }
            if (specVersion.equals("JCA Interim")) {
                return new JCAInterimConnection(this.m_parentClassLoader, connectionConfig, typeConfig, this.m_log, connectionManager, this.m_messageFactory);
            }
            throw new XQEndpointCreationException("Unsupported JCA Specification Version: ");
        }
        catch (XQConfigurationException ne) {
            throw new XQEndpointCreationException("Bad connection configuration: ", (Throwable)ne);
        }
    }

    private XQConnectionTypeConfig lookupConnectionType(XQConfigManager configManager, XQConnectionConfig config) throws XQConfigurationException {
        return configManager.lookupConnectionTypeConfig(config.getConnectionTypeName());
    }

    private XQConnectionConfig lookupConnection(XQConfigManager configManager, XQEndpointConfig config) throws XQConfigurationException {
        return configManager.lookupConnectionConfig(config.getConnection());
    }
}

