/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script.wsdl;

import com.ibm.wsdl.extensions.soap.SOAPConstants;
import com.sonicsw.esb.ws.invocation.ESBWSFaultInfo;
import com.sonicsw.wsdl4j.ElementExtensible;
import com.sonicsw.xqimpl.script.wsdl.Policy;
import com.sonicsw.xqimpl.script.wsdl.SOAPInfo;
import com.sonicsw.xqimpl.script.wsdl.WSDLFaultInfo;
import com.sonicsw.xqimpl.script.wsdl.WSDLHelperException;
import com.sonicsw.xqimpl.script.wsdl.WSDLServiceHelper;
import com.sonicsw.xqimpl.ws.addressing.AddressingUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

class PortInfo {
    private static List SUPPORTED_PROVIDERS = new ArrayList();
    private static int UNKNOWN_BINDING;
    private static int SOAP_BINDING;
    private static int ESB_BINDING;
    protected WSDLServiceHelper m_svcHelper;
    private Port m_port = null;
    private Binding m_binding = null;
    private String m_displayName = null;
    private PortType m_portType = null;
    private int m_bindingType = UNKNOWN_BINDING;
    private static QName ESB_BINDING_QNAME;
    private static QName SOAP_BINDING_QNAME;
    private static final int INPUT = 0;
    private static final int OUTPUT = 1;
    private static final int FAULT = 2;

    PortInfo(WSDLServiceHelper svcHelper, String displayName, Binding binding) throws WSDLHelperException {
        this.m_binding = binding;
        this.initialize(svcHelper, displayName, this.m_binding.getPortType());
    }

    PortInfo(WSDLServiceHelper svcHelper, String displayName, Port port) throws WSDLHelperException {
        this.m_port = port;
        this.m_binding = port.getBinding();
        this.initialize(svcHelper, displayName, this.m_binding.getPortType());
    }

    PortInfo(WSDLServiceHelper svcHelper, String displayName, PortType portType) throws WSDLHelperException {
        this.initialize(svcHelper, displayName, portType);
    }

    private void initialize(WSDLServiceHelper svcHelper, String displayName, PortType portType) throws WSDLHelperException {
        this.m_svcHelper = svcHelper;
        this.m_displayName = displayName;
        this.m_portType = portType;
        this.m_bindingType = this.computeBindingType();
        this.checkPortType();
    }

    private void checkPortType() throws WSDLHelperException {
        if (this.m_binding == null) {
            return;
        }
        List bindingExList = this.m_binding.getExtensibilityElements();
        if (bindingExList.isEmpty()) {
            return;
        }
        for (int i = 0; i < bindingExList.size(); ++i) {
            ExtensibilityElement bindingEx = (ExtensibilityElement)bindingExList.get(i);
            QName bindingNS = bindingEx.getElementType();
            if (!SUPPORTED_PROVIDERS.contains(bindingNS)) continue;
            return;
        }
        throw new WSDLHelperException("port-not-supported", new Object[]{this.m_binding.getQName()});
    }

    boolean isSOAPBinding() {
        return this.m_bindingType == SOAP_BINDING;
    }

    boolean isESBBinding() {
        return this.m_bindingType == ESB_BINDING;
    }

    String getPortName() {
        return this.m_port == null ? null : this.m_port.getName();
    }

    QName getPortTypeName() {
        return this.m_portType.getQName();
    }

    QName getBindingName() {
        return this.m_binding == null ? null : this.m_binding.getQName();
    }

    String getDisplayName() {
        return this.m_displayName;
    }

    List getOperations() {
        if (this.m_portType == null) {
            return new ArrayList();
        }
        return this.m_portType.getOperations();
    }

    List getBindingOperations() {
        if (this.m_binding == null) {
            return new ArrayList();
        }
        return this.m_binding.getBindingOperations();
    }

    private int computeBindingType() {
        if (this.m_binding != null) {
            for (Object o : this.m_binding.getExtensibilityElements()) {
                QName elType;
                if (o instanceof SOAPBinding) {
                    return SOAP_BINDING;
                }
                if (!(o instanceof UnknownExtensibilityElement) || (elType = ((UnknownExtensibilityElement)o).getElementType()) == null) continue;
                if (elType.equals(ESB_BINDING_QNAME)) {
                    return ESB_BINDING;
                }
                if (!elType.equals(SOAP_BINDING_QNAME)) continue;
                return SOAP_BINDING;
            }
        }
        return UNKNOWN_BINDING;
    }

    private Object[] findExtensibilityElements(List extElems, QName extType) {
        ArrayList list = new ArrayList();
        if (extElems != null) {
            for (Object o : extElems) {
                ExtensibilityElement e;
                if (!(o instanceof ExtensibilityElement) || !(e = (ExtensibilityElement)o).getElementType().equals(extType)) continue;
                list.add(o);
            }
        }
        if (!list.isEmpty()) {
            return list.toArray();
        }
        return null;
    }

    private Object[] findExtensibilityElements(BindingOperation op, String direction, QName extType) throws WSDLHelperException {
        BindingOutput o;
        BindingInput i;
        List inElems = new ArrayList();
        List outElems = new ArrayList();
        if ((direction.equals("IN") || direction.equals("INOUT")) && (i = op.getBindingInput()) != null) {
            inElems = i.getExtensibilityElements();
        }
        if ((direction.equals("OUT") || direction.equals("INOUT")) && (o = op.getBindingOutput()) != null) {
            outElems = o.getExtensibilityElements();
        }
        ArrayList extElems = new ArrayList();
        extElems.addAll(inElems);
        extElems.addAll(outElems);
        return this.findExtensibilityElements(extElems, extType);
    }

    String getNamespaceURI(Operation targetOp, Part part, String direction, boolean isHeader) throws WSDLHelperException {
        List bindingOps = this.getBindingOperations();
        for (BindingOperation op : bindingOps) {
            if (op.getOperation() != targetOp) continue;
            if (isHeader) {
                Object[] o = this.findExtensibilityElements(op, direction, SOAPConstants.Q_ELEM_SOAP_HEADER);
                return this.findNamespaceURIFromHeaders(o, part);
            }
            Object[] o = this.findExtensibilityElements(op, direction, SOAPConstants.Q_ELEM_SOAP_BODY);
            if (o != null) {
                return ((SOAPBody)o[0]).getNamespaceURI();
            }
            return null;
        }
        return null;
    }

    private String findNamespaceURIFromHeaders(Object[] headers, Part part) {
        if (headers != null) {
            for (int count = 0; count < headers.length; ++count) {
                SOAPHeader header = (SOAPHeader)headers[count];
                String partRef = header.getPart();
                QName messageName = header.getMessage();
                Message message = this.m_svcHelper.getWSDLHelper().getDefinition().getMessage(messageName);
                Part messagePart = null;
                if (message != null && partRef != null && partRef.length() > 0) {
                    messagePart = message.getPart(partRef);
                }
                if (messagePart == null || !messagePart.getName().equals(part.getName())) continue;
                return header.getNamespaceURI();
            }
        }
        return null;
    }

    SOAPInfo getSOAPInfo(Operation targetOp) throws WSDLHelperException {
        List bindingOps = this.getBindingOperations();
        Iterator iter = bindingOps.iterator();
        SOAPInfo soapInfo = null;
        while (iter.hasNext()) {
            BindingOperation op = (BindingOperation)iter.next();
            if (op.getOperation() != targetOp) continue;
            soapInfo = this.getOperationSOAPProperties(op);
            break;
        }
        if (this.m_port != null) {
            String endpointURL = null;
            Object[] o = this.findExtensibilityElements(this.m_port.getExtensibilityElements(), SOAPConstants.Q_ELEM_SOAP_ADDRESS);
            if (o != null) {
                SOAPAddress soapAddr = (SOAPAddress)o[0];
                endpointURL = soapAddr.getLocationURI();
                if (soapInfo == null) {
                    soapInfo = new SOAPInfo();
                }
                soapInfo.setProperty("endpoint", endpointURL);
            }
        }
        return soapInfo;
    }

    private SOAPInfo getOperationSOAPProperties(BindingOperation op) throws WSDLHelperException {
        Hashtable map = new Hashtable();
        String operationStyle = null;
        Object[] o = this.findExtensibilityElements(op.getExtensibilityElements(), SOAPConstants.Q_ELEM_SOAP_OPERATION);
        if (o != null) {
            SOAPOperation soapOp = (SOAPOperation)o[0];
            operationStyle = soapOp.getStyle();
            this.addToMap(map, "soapActionURI", soapOp.getSoapActionURI());
        }
        if (operationStyle == null) {
            operationStyle = this.getBindingOperationStyle();
        }
        this.addToMap(map, "operationStyle", operationStyle);
        SOAPBody inputBody = null;
        o = this.findExtensibilityElements(op, "IN", SOAPConstants.Q_ELEM_SOAP_BODY);
        if (o != null) {
            inputBody = (SOAPBody)o[0];
            this.addToMap(map, "use", inputBody.getUse());
            this.addToMap(map, "inputNamespace", inputBody.getNamespaceURI());
        }
        if (inputBody != null) {
            Iterator iter;
            List styles = inputBody.getEncodingStyles();
            this.checkEncodingStyle(styles);
            if (styles != null && (iter = styles.iterator()).hasNext()) {
                String s = (String)iter.next();
                this.addToMap(map, "inputEncodingStyle", s);
            }
        }
        if ((o = this.findExtensibilityElements(op, "OUT", SOAPConstants.Q_ELEM_SOAP_BODY)) != null) {
            Iterator iter;
            SOAPBody outputBody = (SOAPBody)o[0];
            List styles = outputBody.getEncodingStyles();
            this.checkEncodingStyle(styles);
            if (styles != null && (iter = styles.iterator()).hasNext()) {
                String s = (String)iter.next();
                this.addToMap(map, "outputEncodingStyle", s);
            }
        }
        List headerFaults = this.getSOAPHeaderFaults(op);
        return new SOAPInfo(map, headerFaults);
    }

    private void addToMap(Map m, Object key, Object value) {
        if (value != null) {
            m.put(key, value);
        }
    }

    private List getSOAPHeaderFaults(BindingOperation op) throws WSDLHelperException {
        ArrayList faultList = new ArrayList();
        if (op.getBindingInput() != null) {
            faultList.addAll(this.getSOAPHeaderFaults(op.getBindingInput().getExtensibilityElements()));
        }
        if (op.getBindingOutput() != null) {
            faultList.addAll(this.getSOAPHeaderFaults(op.getBindingOutput().getExtensibilityElements()));
        }
        ArrayList<WSDLFaultInfo> output = new ArrayList<WSDLFaultInfo>();
        if (!faultList.isEmpty()) {
            for (WSDLFaultInfo info : faultList) {
                output.add(info);
            }
        }
        return output;
    }

    private List getSOAPHeaderFaults(List extElems) throws WSDLHelperException {
        ArrayList<WSDLFaultInfo> faultList = new ArrayList<WSDLFaultInfo>();
        for (Object o : extElems) {
            if (!(o instanceof SOAPHeader)) continue;
            SOAPHeader header = (SOAPHeader)o;
            this.checkEncodingStyle(header.getEncodingStyles());
            List headerFaults = header.getSOAPHeaderFaults();
            if (headerFaults == null) continue;
            for (SOAPHeaderFault f : headerFaults) {
                this.checkEncodingStyle(f.getEncodingStyles());
                Message m = this.m_svcHelper.getWSDLHelper().getDefinition().getMessage(f.getMessage());
                faultList.add(new WSDLFaultInfo(this.m_svcHelper, f, m));
            }
        }
        return faultList;
    }

    private void checkEncodingStyle(List styles) throws WSDLHelperException {
        if (styles == null || styles.isEmpty()) {
            return;
        }
        if (styles.size() > 1) {
            throw new WSDLHelperException("too-many-encoding-styles", null);
        }
        String s = (String)styles.get(0);
        if (!s.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            throw new WSDLHelperException("unsupported-encoding-style", new Object[]{s});
        }
    }

    private String getBindingOperationStyle() {
        Object[] o = this.findExtensibilityElements(this.m_binding.getExtensibilityElements(), SOAPConstants.Q_ELEM_SOAP_BINDING);
        return o == null ? null : ((SOAPBinding)o[0]).getStyle();
    }

    List getEffectiveInputPolicy(Operation targetOp) throws WSDLHelperException {
        return this.getNormalizedPolicies(targetOp, 0);
    }

    List getEffectiveOutputPolicy(Operation targetOp) throws WSDLHelperException {
        return this.getNormalizedPolicies(targetOp, 1);
    }

    public List getNormalizedPolicies(Operation targetOp, int type) throws WSDLHelperException {
        return this.computeNormalizedPolicies(targetOp, type, null);
    }

    public List getNormalizedPolicies(Operation targetOp, ESBWSFaultInfo fault) throws WSDLHelperException {
        return this.computeNormalizedPolicies(targetOp, 2, fault);
    }

    private List computeNormalizedPolicies(Operation targetOp, int type, ESBWSFaultInfo fault) throws WSDLHelperException {
        List policies = this.getBindingPolicies(this.m_binding);
        policies.addAll(this.getOperationPolicies(targetOp, type, fault));
        policies.addAll(this.getBindingOperationPolicies(targetOp, type, fault));
        policies.addAll(this.getPortTypePolicies());
        return policies;
    }

    private List getBindingPolicies(Binding binding) throws WSDLHelperException {
        ArrayList policies = new ArrayList();
        if (binding != null) {
            List bindingPolicies = Policy.getPolicyElements(this.m_svcHelper, binding.getExtensibilityElements());
            policies.addAll(bindingPolicies);
            bindingPolicies = Policy.getPolicyFromAttributes(this.m_svcHelper, binding.getExtensionAttributes());
            policies.addAll(bindingPolicies);
        }
        return policies;
    }

    private List getBindingOperationPolicies(Operation targetOp, int type, ESBWSFaultInfo fault) throws WSDLHelperException {
        ArrayList policies = new ArrayList();
        BindingOperation bindingOp = this.getBindingOperation(targetOp);
        if (bindingOp != null) {
            policies.addAll(Policy.getPolicyElements(this.m_svcHelper, bindingOp.getExtensibilityElements()));
            policies.addAll(Policy.getPolicyFromAttributes(this.m_svcHelper, bindingOp.getExtensionAttributes()));
            switch (type) {
                case 0: {
                    BindingInput in = bindingOp.getBindingInput();
                    if (in == null) break;
                    policies.addAll(Policy.getPolicyElements(this.m_svcHelper, in.getExtensibilityElements()));
                    break;
                }
                case 1: {
                    BindingOutput out = bindingOp.getBindingOutput();
                    if (out == null) break;
                    policies.addAll(Policy.getPolicyElements(this.m_svcHelper, out.getExtensibilityElements()));
                    break;
                }
                case 2: {
                    BindingFault flt = null;
                    if (fault == null) {
                        Map faultList = bindingOp.getBindingFaults();
                        if (!faultList.isEmpty()) {
                            Object firstKey = faultList.keySet().iterator().next();
                            flt = (BindingFault)faultList.get(firstKey);
                        }
                    } else {
                        flt = bindingOp.getBindingFault(fault.getName());
                    }
                    if (flt == null) break;
                    policies.addAll(Policy.getPolicyElements(this.m_svcHelper, flt.getExtensibilityElements()));
                    break;
                }
            }
        }
        return policies;
    }

    private List getOperationPolicies(Operation targetOp, int type, ESBWSFaultInfo fault) throws WSDLHelperException {
        ArrayList policies = new ArrayList();
        switch (type) {
            case 0: {
                Input in = targetOp.getInput();
                if (in == null) break;
                policies.addAll(this.getMessagePolicyElements(in.getMessage()));
                break;
            }
            case 1: {
                Output out = targetOp.getOutput();
                if (out == null) break;
                policies.addAll(this.getMessagePolicyElements(out.getMessage()));
                break;
            }
            case 2: {
                Fault flt = null;
                if (fault == null) {
                    Map faultList = targetOp.getFaults();
                    if (!faultList.isEmpty()) {
                        Object firstKey = faultList.keySet().iterator().next();
                        flt = (Fault)faultList.get(firstKey);
                    }
                } else {
                    flt = targetOp.getFault(fault.getName());
                }
                if (flt == null) break;
                policies.addAll(this.getMessagePolicyElements(flt.getMessage()));
                break;
            }
        }
        return policies;
    }

    private List getMessagePolicyElements(Message msg) throws WSDLHelperException {
        ArrayList policies = new ArrayList();
        if (msg instanceof ElementExtensible) {
            policies.addAll(Policy.getPolicyElements(this.m_svcHelper, ((ElementExtensible)msg).getExtensibilityElements()));
        }
        if (msg == null) {
            return policies;
        }
        policies.addAll(Policy.getPolicyFromAttributes(this.m_svcHelper, msg.getExtensionAttributes()));
        Map parts = msg.getParts();
        for (Object key : parts.keySet()) {
            Part p = (Part)parts.get(key);
            if (p instanceof ElementExtensible) {
                policies.addAll(Policy.getPolicyElements(this.m_svcHelper, ((ElementExtensible)p).getExtensibilityElements()));
            }
            policies.addAll(Policy.getPolicyFromAttributes(this.m_svcHelper, p.getExtensionAttributes()));
        }
        return policies;
    }

    private List<?> getPortTypePolicies() throws WSDLHelperException {
        ArrayList policies = new ArrayList();
        if (this.m_port != null) {
            policies.addAll(Policy.getPolicyElements(this.m_svcHelper, this.m_port.getExtensibilityElements()));
            policies.addAll(Policy.getPolicyFromAttributes(this.m_svcHelper, this.m_port.getExtensionAttributes()));
        }
        if (this.m_portType != null) {
            policies.addAll(Policy.getPolicyFromAttributes(this.m_svcHelper, this.m_portType.getExtensionAttributes()));
        }
        return policies;
    }

    private BindingOperation getBindingOperation(Operation targetOp) {
        List bindingOps = this.getBindingOperations();
        for (BindingOperation op : bindingOps) {
            if (op.getOperation() != targetOp) continue;
            return op;
        }
        return null;
    }

    Element getEndpointReference() {
        if (this.m_port == null) {
            return null;
        }
        Iterator iter = AddressingUtils.getAddressingURIs();
        List elems = this.m_port.getExtensibilityElements();
        while (iter.hasNext()) {
            QName qname = new QName((String)iter.next(), "EndpointReference");
            Object[] o = this.findExtensibilityElements(elems, qname);
            if (o == null || o.length <= 0) continue;
            UnknownExtensibilityElement e = (UnknownExtensibilityElement)o[0];
            return e.getElement();
        }
        return null;
    }

    static {
        SUPPORTED_PROVIDERS.add(new QName("http://schemas.xmlsoap.org/wsdl/soap/", "binding"));
        SUPPORTED_PROVIDERS.add(new QName("http://schemas.xmlsoap.org/soap/envelope/", "binding"));
        SUPPORTED_PROVIDERS.add(new QName("http://www.sonicsw.com/sonicxq/", "binding"));
        UNKNOWN_BINDING = 0;
        SOAP_BINDING = 1;
        ESB_BINDING = 2;
        ESB_BINDING_QNAME = new QName("http://www.sonicsw.com/sonicxq/", "binding");
        SOAP_BINDING_QNAME = new QName("http://schemas.xmlsoap.org/soap/envelope/", "binding");
    }
}

