/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.el;

import com.sonicsw.esb.expression.Expression;
import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.expression.ExpressionException;
import com.sonicsw.esb.expression.ExpressionFactory;
import com.sonicsw.esb.expression.def.ExpressionDefProcessorFactory;
import com.sonicsw.esb.expression.def.el.ELExpressionDefProcessFactory;
import com.sonicsw.esb.expression.el.CompositeTypeConverter;
import com.sonicsw.esb.expression.el.ELExpression;
import com.sonicsw.esb.expression.el.ELExpressionContext;
import com.sonicsw.esb.expression.el.XQELExpressionContext;
import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.tree.TreeBuilder;
import de.odysseus.el.tree.TreeCache;
import de.odysseus.el.tree.TreeStore;
import de.odysseus.el.tree.impl.Builder;
import de.odysseus.el.tree.impl.Cache;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;

public class ELExpressionFactory
implements ExpressionFactory {
    private final javax.el.ExpressionFactory target;
    private final CompositeTypeConverter converter = new CompositeTypeConverter();
    protected boolean stripBlankPrefixSuffixFromExpression;
    protected static ExpressionDefProcessorFactory s_expressionDefProcessorFactory = new ELExpressionDefProcessFactory();
    private Class<? extends ELExpressionContext> contextClass = XQELExpressionContext.class;

    public ELExpressionFactory() {
        TreeStore store = new TreeStore((TreeBuilder)new Builder(), (TreeCache)new Cache(1000));
        this.target = new ExpressionFactoryImpl(store, (TypeConverter)this.converter);
        this.stripBlankPrefixSuffixFromExpression = "true".equals(System.getProperty("com.sonic.esb.el.stripBlankPrefixSuffixFromExpression", "true"));
    }

    @Override
    public ExpressionContext createContext() {
        try {
            return this.contextClass.newInstance();
        }
        catch (Exception excp) {
            throw new ExpressionException("Failed to create context", excp);
        }
    }

    @Override
    public Expression createExpression(ExpressionContext context, String expression) {
        return this.createExpression(context, expression, Object.class);
    }

    @Override
    public Expression createExpression(ExpressionContext context, String expression, Class<?> expectedType) {
        String expStr = this.stripBlankPrefixSuffixFromESBExpression(expression);
        try {
            ValueExpression result = this.target.createValueExpression((ELContext)context, expStr, expectedType);
            return new ELExpression(result);
        }
        catch (ELException excp) {
            throw new ExpressionException("Failed to create expression: " + expStr, excp);
        }
    }

    private String stripBlankPrefixSuffixFromESBExpression(String expression) {
        if (!this.stripBlankPrefixSuffixFromExpression || expression == null) {
            return expression;
        }
        String expString = expression.trim();
        int expStringLength = expString.length();
        if (expStringLength <= 2) {
            return expression;
        }
        String expStringScheme = expString.substring(2);
        if (s_expressionDefProcessorFactory.isValidExpression(expString) && ELExpressionDefProcessFactory.startWithSupportedExpressionPrefix(expStringScheme)) {
            return expString;
        }
        return expression;
    }

    public void addTypeConverter(TypeConverter newConverter) {
        this.converter.add(newConverter);
    }

    public void setContextClass(Class<? extends ELExpressionContext> clazz) {
        this.contextClass = clazz;
    }
}

