/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.continuation;

import com.sonicsw.esb.itinerary.continuation.ItineraryRuntimeInfo;
import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.xq.XQProcessContinuation;
import com.sonicsw.xq.XQRuntimeProcess;
import java.io.StringWriter;

public class ItineraryContinuation
implements XQProcessContinuation {
    private static final long serialVersionUID = 387612205984165253L;
    private String m_id;
    private Object m_instanceData;
    private String m_processName;
    private String m_stepName;
    private transient XQRuntimeProcess m_processRuntime;
    private String m_topProcessName;
    private XQProcessContinuation.Level m_level;

    protected ItineraryContinuation() {
    }

    public ItineraryContinuation(XQProcessInstance procInst, XQProcessContinuation.Level level) {
        this.init(level, procInst.getProcessInstanceProperties());
    }

    public ItineraryContinuation(ProcessInstanceProps procInstProps, XQProcessContinuation.Level level) {
        this.init(level, procInstProps);
    }

    protected final void init(XQProcessContinuation.Level level, ProcessInstanceProps procInstProps) {
        String trackingID;
        this.m_level = level;
        this.m_processName = procInstProps.getProcessName();
        this.m_topProcessName = procInstProps.getRootProcessName();
        this.m_stepName = procInstProps.getStepName();
        if (level.isGreaterThan(XQProcessContinuation.Level.STATELESS)) {
            this.m_processRuntime = new ItineraryRuntimeInfo(procInstProps);
        }
        this.setID((trackingID = procInstProps.getTrackingId()) != null ? trackingID : System.currentTimeMillis() + "");
    }

    public void setID(String id) {
        this.m_id = id;
    }

    public String getID() {
        return this.m_id;
    }

    public void setProcessInstanceData(Object instanceData) {
        this.m_instanceData = instanceData;
    }

    public Object getProcessInstanceData() {
        return this.m_instanceData;
    }

    public void setCurrentProcessName(String processName) {
        this.m_processName = processName;
    }

    public String getCurrentProcessName() {
        return this.m_processName;
    }

    public void setRootProcessName(String processName) {
        this.m_topProcessName = processName;
    }

    public String getRootProcessName() {
        return this.m_topProcessName;
    }

    public void setCompositeStepName(String stepName) {
        this.m_stepName = stepName;
    }

    public String getCompositeStepName() {
        return this.m_stepName;
    }

    public void setCurrentProcessStepName(String stepName) {
        int index;
        StringWriter sw = new StringWriter();
        if (this.m_stepName != null && (index = this.m_stepName.lastIndexOf(58)) != -1) {
            sw.write(this.m_stepName.substring(0, index + 1));
        }
        sw.write(stepName);
        this.m_stepName = sw.toString();
    }

    public void setProcessRuntime(XQRuntimeProcess processRuntime) {
        this.m_processRuntime = processRuntime;
    }

    public XQRuntimeProcess getProcessRuntime() {
        return this.m_processRuntime;
    }

    public void setLevel(XQProcessContinuation.Level level) {
        this.m_level = level;
    }

    public XQProcessContinuation.Level getLevel() {
        return this.m_level;
    }
}

