/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.mapping;

import com.sonicsw.esb.expression.ExpressionFactory;
import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.itinerary.mapping.BinaryDecodeAction;
import com.sonicsw.esb.itinerary.mapping.BinaryEncodeAction;
import com.sonicsw.esb.itinerary.mapping.DefaultFaultMappingRule;
import com.sonicsw.esb.itinerary.mapping.DefaultInputMappingRule;
import com.sonicsw.esb.itinerary.mapping.DefaultOutputMappingRule;
import com.sonicsw.esb.itinerary.mapping.FaultMapperHelper;
import com.sonicsw.esb.itinerary.mapping.InputMapperHelper;
import com.sonicsw.esb.itinerary.mapping.MappingUtils;
import com.sonicsw.esb.itinerary.mapping.NoOpMappingAction;
import com.sonicsw.esb.itinerary.mapping.OutputMapperHelper;
import com.sonicsw.esb.itinerary.mapping.WrapInXmlMappingAction;
import com.sonicsw.esb.itinerary.mapping.XPathMappingAction;
import com.sonicsw.esb.itinerary.mapping.XQMsgBulkOperationAction;
import com.sonicsw.esb.itinerary.mapping.XsltMappingAction;
import com.sonicsw.esb.process.mapping.FaultMappingRule;
import com.sonicsw.esb.process.mapping.InputMappingRule;
import com.sonicsw.esb.process.mapping.MappingAction;
import com.sonicsw.esb.process.mapping.MappingContext;
import com.sonicsw.esb.process.mapping.MappingRuleList;
import com.sonicsw.esb.process.mapping.MessageMapper;
import com.sonicsw.esb.process.mapping.OutputMappingRule;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xqimpl.util.xml.Namespace;
import java.util.Map;
import java.util.Properties;

public class DefaultMessageMapper
implements MessageMapper {
    private InputMapperHelper m_inputMapper;
    private OutputMapperHelper m_outputMapper;
    private FaultMapperHelper m_faultMapper;
    private Properties m_properties = new Properties();
    private ExpressionFactory m_expressionFactory = MappingUtils.getStaticExpressionFactory();
    private Map<String, Namespace> m_namespaceMap;
    public static final MappingAction NO_ACTION = new NoOpMappingAction();
    public static final MappingAction XSLT_ACTION = new XsltMappingAction();
    public static final MappingAction XPATH_ACTION = new XPathMappingAction();
    public static final MappingAction WRAP_ACTION = new WrapInXmlMappingAction();
    public static final MappingAction XQMSG_BULK_DELETE_ACTION = new XQMsgBulkOperationAction(true);
    public static final MappingAction XQMSG_BULK_INCLUDE_ACTION = new XQMsgBulkOperationAction(false);
    public static final MappingAction BINARY_ENCODE_ACTION = new BinaryEncodeAction();
    public static final MappingAction BINARY_DECODE_ACTION = new BinaryDecodeAction();

    public DefaultMessageMapper() {
        this.m_inputMapper = new InputMapperHelper();
        this.m_outputMapper = new OutputMapperHelper();
        this.m_faultMapper = new FaultMapperHelper();
    }

    public void addInputMapping(InputMappingRule mappingRule) {
        this.m_inputMapper.addInputMappingRule(mappingRule);
    }

    public void addOutputMapping(OutputMappingRule mappingRule) {
        this.m_outputMapper.addOutputMappingRule(mappingRule);
    }

    public void addFaultMapping(String name, FaultMappingRule mappingRule) {
        this.m_faultMapper.addFaultMappingRule(name, mappingRule);
    }

    public void addProperty(String name, String value) {
        this.m_properties.put(name, value);
    }

    @Override
    public Properties getProperties() {
        return this.m_properties;
    }

    public String getProperty(String name) {
        return this.m_properties.getProperty(name);
    }

    @Override
    public Map<String, Namespace> getNamespaceMap() {
        return this.m_namespaceMap;
    }

    public void setNamespaceMap(Map<String, Namespace> map) {
        this.m_namespaceMap = map;
    }

    @Override
    public void executeInputMapping(XQMessage msg, MappingContext mappingCtx) {
        mappingCtx.addObject(MessageMapper.class, this);
        this.m_inputMapper.mapInput(msg, mappingCtx);
    }

    @Override
    public void executeOutputMapping(XQMessage message, MappingContext mapCtx) {
        this.m_outputMapper.mapFromOutput(message, mapCtx);
    }

    @Override
    public boolean executeFaultMapping(String faultName, XQMessage message, MappingContext mapCtx) {
        return this.m_faultMapper.mapFromFault(faultName, message, mapCtx);
    }

    public ExpressionFactory getExpressionFactory() {
        return this.m_expressionFactory;
    }

    public static MappingAction stringToAction(String actionStr) {
        if (actionStr == null || actionStr.length() == 0 || actionStr.equalsIgnoreCase("none")) {
            return NO_ACTION;
        }
        if (actionStr.equalsIgnoreCase("xslt")) {
            return XSLT_ACTION;
        }
        if (actionStr.equalsIgnoreCase("xpath")) {
            return XPATH_ACTION;
        }
        if (actionStr.equalsIgnoreCase("wrapInXml")) {
            return WRAP_ACTION;
        }
        if (actionStr.equalsIgnoreCase("XQMsgBulkDelete")) {
            return XQMSG_BULK_DELETE_ACTION;
        }
        if (actionStr.equalsIgnoreCase("XQMsgBulkInclude")) {
            return XQMSG_BULK_INCLUDE_ACTION;
        }
        if (actionStr.equalsIgnoreCase("decodeToBinary")) {
            return BINARY_DECODE_ACTION;
        }
        if (actionStr.equalsIgnoreCase("encodeFromBinary")) {
            return BINARY_ENCODE_ACTION;
        }
        throw new UnsupportedOperationException("Action `" + actionStr + "` not supported!");
    }

    public static String actionToString(MappingAction action) {
        if (action == NO_ACTION) {
            return "none";
        }
        if (action == XSLT_ACTION) {
            return "xslt";
        }
        if (action == XPATH_ACTION) {
            return "xpath";
        }
        if (action == WRAP_ACTION) {
            return "wrapInXml";
        }
        if (action == XQMSG_BULK_DELETE_ACTION) {
            return "XQMsgBulkDelete";
        }
        if (action == XQMSG_BULK_INCLUDE_ACTION) {
            return "XQMsgBulkInclude";
        }
        if (action == BINARY_DECODE_ACTION) {
            return "decodeToBinary";
        }
        if (action == BINARY_ENCODE_ACTION) {
            return "encodeFromBinary";
        }
        throw new UnsupportedOperationException("Action `" + action.getClass() + "` not supported!");
    }

    @Override
    public Map<String, MappingRuleList> getFaultMappingRules() {
        return this.m_faultMapper.getFaultRules();
    }

    @Override
    public MappingRuleList getInputMappingRules() {
        return this.m_inputMapper.getInputRules();
    }

    @Override
    public MappingRuleList getOutputMappingRules() {
        return this.m_outputMapper.getOutputRules();
    }

    public InputMappingRule createInputMappingRule(String source, String target, MappingAction action, String[] actionResources) {
        return new DefaultInputMappingRule(this.m_expressionFactory, source, target, action, actionResources);
    }

    public OutputMappingRule createOutputMappingRule(String source, String target, MappingAction action, String[] actionResources) {
        return new DefaultOutputMappingRule(this.m_expressionFactory, source, target, action, actionResources);
    }

    public FaultMappingRule createFaultMappingRule(String source, String target, MappingAction action, String[] actionResources) {
        return new DefaultFaultMappingRule(this.m_expressionFactory, source, target, action, actionResources);
    }

    public static void mapInputMessage(MessageMapper msgMapper, EsbMessageExchange esbMex) {
        MappingContext mappingCtx = new MappingContext();
        mappingCtx.addObject(XQParameters.class, esbMex.getXQParameters());
        msgMapper.executeInputMapping(esbMex.getInputMessage(), mappingCtx);
        XQMessage msg = (XQMessage)mappingCtx.getObject(DefaultOutputMappingRule.RESPONSE_MSG, true);
        esbMex.setInputMessage(msg);
    }
}

