/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.jeri.esb;

import com.sonicsw.esb.jeri.IExporterSource;
import com.sonicsw.esb.jeri.esb.ESBServerEndpoint;
import com.sonicsw.xq.XQEndpoint;
import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.connector.jms.JMSEndpoint;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import java.util.Hashtable;
import java.util.Map;
import net.jini.export.Exporter;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;

public class ESBPreferredEndpointTracker
implements IExporterSource {
    private static ThreadLocal m_trackerLocal = new ThreadLocal();
    private Map m_uuidMap = new Hashtable();

    public static synchronized ESBPreferredEndpointTracker getInstance() {
        ESBPreferredEndpointTracker tracker = (ESBPreferredEndpointTracker)m_trackerLocal.get();
        if (tracker == null) {
            tracker = new ESBPreferredEndpointTracker();
            m_trackerLocal.set(tracker);
        }
        return tracker;
    }

    public void addUuidMap(String uuid, String entryEndpointName) {
        this.m_uuidMap.put(uuid, entryEndpointName);
    }

    public void removeUUID(String uuid) {
        this.m_uuidMap.remove(uuid);
    }

    public boolean containsUUID(String uuid) {
        return this.m_uuidMap.containsKey(uuid);
    }

    public XQEndpoint getEndpoint(String uuid) {
        String endpointName = (String)this.m_uuidMap.get(uuid);
        if (endpointName == null) {
            return null;
        }
        XQEndpoint endpoint = null;
        try {
            endpoint = EndpointManager.getInstance().getEndpoint(endpointName);
        }
        catch (XQEndpointCreationException e) {
            e.printStackTrace();
        }
        return endpoint;
    }

    public Exporter getExporter(String uuid) {
        String entryEndpoint = (String)this.m_uuidMap.get(uuid);
        try {
            JMSEndpoint endpoint = (JMSEndpoint)EndpointManager.getInstance().getEndpoint(entryEndpoint);
            return new BasicJeriExporter((ServerEndpoint)new ESBServerEndpoint(endpoint, uuid), (InvocationLayerFactory)new BasicILFactory(), false, false);
        }
        catch (XQEndpointCreationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

