/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.cbr;

import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xq.service.cbr.CBR;
import com.sonicsw.xqimpl.util.XQFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class CBRFactory
implements XQFactory {
    protected static final String NameSeparator = ": ";
    protected static final String Constructor = "Constructor";
    protected static final String NotFound = " not found.";
    protected XQParameters m_initParams;
    private boolean m_isCacheEnabled;

    protected CBRFactory() {
    }

    public String getType() {
        return "CBR";
    }

    public Object create() throws XQServiceException {
        CBR cbr = new CBR();
        cbr.init(this.m_initParams, this.m_isCacheEnabled);
        return cbr;
    }

    public void setInitInfo(XQParameters initParams, boolean isCacheEnabled) {
        this.m_initParams = initParams;
        this.m_isCacheEnabled = isCacheEnabled;
    }

    public Object create(String factoryClass, String factoryMethod, Object[] parameters) throws ClassNotFoundException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, Throwable {
        Class<?> type = null;
        Object object = null;
        try {
            type = Class.forName(factoryClass, true, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException(factoryClass + NameSeparator + e.getMessage());
        }
        catch (NullPointerException e) {
            throw new ClassNotFoundException(factoryClass + NameSeparator + e.getMessage());
        }
        try {
            Class[] paramTypes = null;
            if (parameters != null) {
                int paramCount = parameters.length;
                if (paramCount > 0) {
                    paramTypes = new Class[paramCount];
                }
                while (paramCount-- > 0) {
                    if (parameters[paramCount] != null) {
                        paramTypes[paramCount] = parameters[paramCount].getClass();
                        continue;
                    }
                    paramTypes[paramCount] = null;
                }
            }
            boolean methodNotFound = true;
            if (factoryMethod != null && factoryMethod.length() > 0) {
                Method[] methods = type.getMethods();
                int methodCount = methods.length;
                while (methodCount-- > 0) {
                    if (!factoryMethod.equals(methods[methodCount].getName()) || !Modifier.isStatic(methods[methodCount].getModifiers()) || !this.parametersMatch(paramTypes, methods[methodCount].getParameterTypes())) continue;
                    object = methods[methodCount].invoke(null, parameters);
                    methodNotFound = false;
                    break;
                }
            } else {
                Constructor<?>[] constructors = type.getConstructors();
                int constructorCount = constructors.length;
                while (constructorCount-- > 0) {
                    if (!this.parametersMatch(paramTypes, constructors[constructorCount].getParameterTypes())) continue;
                    object = constructors[constructorCount].newInstance(parameters);
                    methodNotFound = false;
                    break;
                }
            }
            if (methodNotFound) {
                String method = factoryMethod == null || factoryMethod.length() < 1 ? Constructor : factoryMethod;
                throw new NoSuchMethodException(method + NotFound);
            }
        }
        catch (SecurityException e) {
            throw new SecurityException(factoryClass + NameSeparator + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodException(factoryClass + NameSeparator + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessException(factoryClass + NameSeparator + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return object;
    }

    private boolean parametersMatch(Class[] inputParams, Class[] actualParams) {
        int inputParamCount;
        boolean parametersMatch = true;
        int actualParamCount = actualParams == null ? 0 : actualParams.length;
        int n = inputParamCount = inputParams == null ? 0 : inputParams.length;
        if (actualParamCount == inputParamCount) {
            while (actualParamCount-- > 0) {
                if (actualParams[actualParamCount].isAssignableFrom(inputParams[actualParamCount])) continue;
                parametersMatch = false;
                break;
            }
        } else {
            parametersMatch = false;
        }
        return parametersMatch;
    }
}

