/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.xq.XQException;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xqimpl.script.Command;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.script.ScriptObject;
import com.sonicsw.xqimpl.script.Util;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public abstract class ScriptEngine {
    protected DirectoryServiceProxy m_proxy;
    protected IComponentContext m_context;
    private Integer m_traceMask;
    private static ThreadLocal s_scriptObjectCacheThreadLocal = new ThreadLocal();

    public ScriptEngine(DirectoryServiceProxy proxy) {
        this.m_proxy = proxy;
    }

    public ScriptEngine(IComponentContext context) {
        this.m_context = context;
    }

    public XQMessage executeCommand(XQMessage messageParam, XQParameters params) throws Exception {
        XQMessage message = messageParam;
        message = (XQMessage)message.clone();
        ScriptObject script = this.createScriptFromXQMessage(message, params);
        script.initRuntimeContext(params, message);
        Command command = new Command(message, params, script);
        command.execute();
        return message;
    }

    public Command createCommand(XQMessage messageParam, XQParameters params) throws Exception {
        XQMessage message = messageParam;
        message = (XQMessage)message.clone();
        ScriptObject script = this.createScriptFromXQMessage(message, params);
        script.initRuntimeContext(params, message);
        Command command = new Command(message, params, script);
        return command;
    }

    public List getInputParameters(String commandXML) throws ScriptEngineException {
        try {
            ScriptObject script = this.createScriptFromCommand(commandXML);
            Command command = new Command(commandXML, script);
            return command.getInputParameterValues();
        }
        catch (XQMessageException e) {
            ScriptEngineException se = new ScriptEngineException(e.getMessage(), 0);
            se.setLinkedException(e);
            throw se;
        }
    }

    public Map getOutputVariableValues(String commandXML, List outputValues) throws ScriptEngineException {
        ScriptObject script = this.createScriptFromCommand(commandXML);
        Command command = new Command(commandXML, script);
        return command.getOutputVariableValues(outputValues);
    }

    public List executeCommand(String commandXML) throws Exception {
        ScriptObject script = this.createScriptFromCommand(commandXML);
        Command command = new Command(commandXML, script);
        return command.executeScriptCommand();
    }

    public abstract ScriptObject createScriptObject(Element var1) throws ScriptEngineException;

    public ScriptObject createScriptObject() throws ScriptEngineException {
        return null;
    }

    private ScriptObject createScriptFromCommand(String command) throws ScriptEngineException {
        try {
            Element commandEl = DOMUtils.getDocumentBuilder().parse(new InputSource(new StringReader(command))).getDocumentElement();
            return this.createScriptFromCommand(commandEl);
        }
        catch (Exception e) {
            throw Util.createParserException(e, command);
        }
    }

    private ScriptObject createScriptFromCommand(Element commandEl) throws ScriptEngineException {
        try {
            Element tempEl = DOMUtils.getImmediateChildElementByName((Element)commandEl, (String)"scriptURL");
            ScriptObject scriptObject = null;
            if (tempEl != null) {
                Text t = DOMUtils.getFirstTextChild((Element)tempEl);
                if (t == null) {
                    throw new ScriptEngineException("script-url-value-not-found", 1);
                }
                String scriptURL = t.getData().trim();
                scriptObject = this.getScript(scriptURL);
            } else {
                tempEl = DOMUtils.getImmediateChildElementByName((Element)commandEl, (String)"script");
                if (tempEl != null) {
                    scriptObject = this.createScript(tempEl);
                } else {
                    throw new ScriptEngineException("unable-to-locate-script", new Object[]{"scriptURL", "script"}, 1);
                }
            }
            return scriptObject;
        }
        catch (ScriptEngineException e) {
            throw e;
        }
        catch (Exception e) {
            ScriptEngineException se = new ScriptEngineException(e.getMessage(), 0);
            se.setLinkedException(e);
            throw se;
        }
    }

    private ScriptObject createScriptFromXQMessage(XQMessage message, XQParameters params) throws XQException, ScriptEngineException {
        String command = null;
        if (message.containsHeader("command")) {
            command = message.getStringHeader("command");
            return this.createScriptFromCommand(command);
        }
        Element commandElem = (Element)params.getParameterObject("command", 2);
        if (commandElem == null) {
            throw new ScriptEngineException("command-not-found", 1);
        }
        if (message instanceof XQMessageInternal) {
            ((XQMessageInternal)message).addSidebandProperty("ScriptCommandElement", commandElem);
        }
        return this.createScriptFromCommand(commandElem);
    }

    protected ScriptObject getScript(String scriptURL) throws ScriptEngineException {
        return this.createScript(scriptURL);
    }

    protected ScriptObject getScriptFromCache(String scriptURL) throws ScriptEngineException {
        if (XQContainer.isCacheEnabled()) {
            HashMap<String, ScriptObject> scriptObjectCache = (HashMap<String, ScriptObject>)s_scriptObjectCacheThreadLocal.get();
            if (scriptObjectCache == null) {
                scriptObjectCache = new HashMap<String, ScriptObject>();
                s_scriptObjectCacheThreadLocal.set(scriptObjectCache);
            }
            ScriptObject scriptObject = null;
            scriptObject = (ScriptObject)scriptObjectCache.get(scriptURL);
            if (scriptObject == null) {
                scriptObject = this.createScript(scriptURL);
                scriptObjectCache.put(scriptURL, scriptObject);
            }
            return scriptObject;
        }
        return this.createScript(scriptURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScriptObject createScript(String scriptURL) throws ScriptEngineException {
        ScriptObject scriptObject;
        InputStream inputStream = URLUtil.getInputStream((URL)new URL(scriptURL));
        if (inputStream == null) {
            throw new ScriptEngineException("script-url-unable-to-load", new Object[]{scriptURL}, 1);
        }
        try {
            Element scriptElm = DOMUtils.getDocumentBuilder().parse(inputStream).getDocumentElement();
            ScriptObject result = this.createScriptObject(scriptElm);
            result.setURL(scriptURL);
            scriptObject = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (ScriptEngineException e) {
                throw e;
            }
            catch (Exception e) {
                ScriptEngineException se = new ScriptEngineException(e.getMessage(), 0);
                se.setLinkedException(e);
                throw se;
            }
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return scriptObject;
    }

    private ScriptObject createScript(Element scriptElm) throws ScriptEngineException {
        ScriptObject result = this.createScriptObject(scriptElm);
        return result;
    }
}

