/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.esb.framework.EsbMessageExchange;
import com.sonicsw.esb.visitor.ESBVisitor;
import com.sonicsw.esb.visitor.ESBVisitorChain;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQDispatch;
import com.sonicsw.xq.XQDispatchException;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xqimpl.endpoint.container.EndpointManager;
import com.sonicsw.xqimpl.envelope.EnvelopeFactory;
import com.sonicsw.xqimpl.service.MessageSendingHelper;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.service.XQServiceMetrics;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class XQDispatchImpl
implements XQDispatch {
    private String m_serviceName;
    private XQMessageFactory m_messageFactory;
    private XQParameters m_environment;
    private boolean m_started;
    private boolean m_stopped;
    private XQServiceMetrics m_metricsHelper;
    private XQServiceMetrics.Statistic m_messagesDispatchedStatistic;
    private static XQLog log = XQLogImpl.getCategoryLog((int)128);

    public void init(String serviceName, XQMessageFactory messageFactory, XQParameters environment, XQServiceMetrics metricsHelper) {
        this.m_serviceName = serviceName;
        this.m_messageFactory = messageFactory;
        this.m_environment = environment;
        this.m_metricsHelper = metricsHelper;
        this.m_started = false;
        this.m_messagesDispatchedStatistic = this.m_metricsHelper.getStatistic(XQServiceMetrics.MESSAGES_SENT_WITH_DISPATCH);
    }

    public void start() {
        this.m_started = true;
        this.m_stopped = false;
    }

    public void stop() {
        this.m_started = false;
        this.m_stopped = true;
    }

    public void destroy() {
        this.m_started = false;
        this.m_stopped = true;
        this.m_serviceName = null;
        this.m_messageFactory = null;
        this.m_environment = null;
    }

    public void dispatch(XQEnvelope envelope) throws XQDispatchException {
        this.dispatch(envelope, XQQualityofService.BEST_EFFORT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(XQEnvelope envelope, XQQualityofService qos) throws XQDispatchException {
        if (!this.m_started) {
            String msg = "Unable to perform asynchronous dispatch. Dispatcher " + (this.m_stopped ? "is in stopped" : "not in started") + " state !";
            throw new XQDispatchException(msg);
        }
        if (envelope == null) {
            throw new XQDispatchException("Unable to perform asynchronous dispatch. Dispatch envelope is null !");
        }
        Iterator addresses = envelope.getAddresses();
        if (!addresses.hasNext()) {
            throw new XQDispatchException("Unable to perform asynchronous dispatch. No addresses specified on the dispatch envelope !");
        }
        XQMessage origMessage = envelope.getMessage();
        if (origMessage == null) {
            throw new XQDispatchException("Unable to perform asynchronous dispatch. The dispatch envelope does not contain a message !");
        }
        HashMap<String, XQMessage> params = new HashMap<String, XQMessage>();
        String sessionName = null;
        ArrayList<XQEnvelope> failedEnvelopeList = null;
        ArrayList<Throwable> exceptionList = null;
        EnvelopeFactory envelopeFactory = null;
        while (addresses.hasNext()) {
            XQAddress dispatchAddress = null;
            ESBVisitor visitor = null;
            boolean notifiedBeforeDispatch = false;
            try {
                XQMessage message;
                dispatchAddress = (XQAddress)addresses.next();
                if (log.isDebugLoggingEnabled()) {
                    log.logDebug("XQDispatchImpl: dispatching message immediately with QoS = " + qos.toString() + " to " + dispatchAddress.getName());
                }
                if ((visitor = this.createVisitor(message = MessageSendingHelper.isDestinationIntraContainer(dispatchAddress) ? (XQMessage)origMessage.clone() : origMessage)) != null) {
                    params.put("ESBVisitor.PARAM_XQ_MESSAGE", message);
                    visitor.beforeDispatch(params);
                    notifiedBeforeDispatch = true;
                }
                boolean commit = qos == XQQualityofService.EXACTLY_ONCE ? !addresses.hasNext() : true;
                EsbMessageExchange mex = EsbMessageExchange.createImmediate(sessionName, dispatchAddress, this.m_messageFactory, message, this.m_environment, qos, commit, EndpointManager.getInvocationEndpointRegistry());
                MessageSendingHelper.sendToAddress(mex, "XQDispatch request from " + this.m_serviceName);
                HashMap<String, String> sessionMap = MessageSendingHelper.getConnectionMap();
                if (qos == XQQualityofService.EXACTLY_ONCE && sessionName == null && sessionMap != null) {
                    sessionName = sessionMap.get("sessionName");
                }
                this.m_messagesDispatchedStatistic.increment();
            }
            catch (Throwable e) {
                if (qos == XQQualityofService.EXACTLY_ONCE) {
                    throw new XQDispatchException(e, envelope);
                }
                if (failedEnvelopeList == null) {
                    failedEnvelopeList = new ArrayList<XQEnvelope>();
                    exceptionList = new ArrayList<Throwable>();
                    envelopeFactory = new EnvelopeFactory();
                }
                XQEnvelope failedEnvelope = envelopeFactory.createTargetedEnvelope(dispatchAddress);
                failedEnvelope.setMessage(origMessage);
                failedEnvelopeList.add(failedEnvelope);
                exceptionList.add(e);
                log.logError(e);
            }
            finally {
                if (!notifiedBeforeDispatch || visitor == null) continue;
                visitor.afterDispatch(params);
            }
        }
        if (failedEnvelopeList != null && !failedEnvelopeList.isEmpty()) {
            throw new XQDispatchException(exceptionList, (ArrayList)failedEnvelopeList);
        }
    }

    private ESBVisitor createVisitor(XQMessage message) {
        XQMessageInternal msgInternal = (XQMessageInternal)message;
        ESBVisitor visitor = msgInternal.getVisitor();
        if (visitor == null) {
            visitor = ESBVisitorChain.getInstance().createVisitor();
            msgInternal.setVisitor(visitor);
        }
        return visitor;
    }
}

