/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.esb.client.ESBInteractorFactory;
import com.sonicsw.esb.interceptor.XQInterceptorService;
import com.sonicsw.esb.interceptor.XQInterceptorServiceContext;
import com.sonicsw.esb.mgmtapi.config.IEndpointConfig;
import com.sonicsw.xq.XQAccessorFactory;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQAddressFactory;
import com.sonicsw.xq.XQDispatch;
import com.sonicsw.xq.XQDispatchException;
import com.sonicsw.xq.XQEndpoint;
import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQEndpointException;
import com.sonicsw.xq.XQEndpointManager;
import com.sonicsw.xq.XQEndpointNotFoundException;
import com.sonicsw.xq.XQEndpointTimeoutException;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQEnvelopeFactory;
import com.sonicsw.xq.XQException;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQInvocationContext;
import com.sonicsw.xq.XQLifeCycleManager;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQMitigationContext;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQProcessContext;
import com.sonicsw.xq.XQProcessContinuation;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xq.XQService;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xq.XQServiceEx;
import com.sonicsw.xq.XQServiceException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.jms.Connection;
import javax.jms.Session;

public class XQServiceChain
implements XQServiceEx {
    private XQService m_targetService;
    private LinkedList<XQService> m_interceptorServices;
    private Hashtable<Object, IteratorItem> m_invocations = new Hashtable();

    public XQServiceChain(XQService targetService) {
        this.m_targetService = targetService;
        this.m_interceptorServices = new LinkedList();
    }

    public void stop() {
        if (this.m_targetService instanceof XQServiceEx) {
            ((XQServiceEx)this.m_targetService).stop();
        }
    }

    public void start() {
        if (this.m_targetService instanceof XQServiceEx) {
            ((XQServiceEx)this.m_targetService).start();
        }
    }

    public void init(XQInitContext initial) throws XQServiceException {
        this.m_targetService.init((XQInitContext)new XQInitContextWrapper(initial));
    }

    public XQService getTargetService() {
        return this.m_targetService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(XQServiceContext context) throws XQServiceException {
        if (!(context instanceof XQInterceptorServiceContext)) {
            throw new XQServiceException("Invalid service context type.");
        }
        if (!this.m_interceptorServices.isEmpty()) {
            XQServiceContextWrapper wrappedContext = new XQServiceContextWrapper((XQInterceptorServiceContext)context);
            IteratorItem item = new IteratorItem(this.m_interceptorServices.listIterator());
            this.m_invocations.put(wrappedContext, item);
            try {
                item.next();
                this.m_interceptorServices.getFirst().service((XQServiceContext)wrappedContext);
            }
            finally {
                item.prev();
                this.m_invocations.remove(wrappedContext);
            }
        } else {
            this.m_targetService.service(context);
        }
    }

    public void destroy() {
        this.m_targetService.destroy();
    }

    public void addInterceptorService(XQInterceptorService service) {
        XQInterceptorServiceWrapper wrappedService = new XQInterceptorServiceWrapper(service);
        this.m_interceptorServices.addLast((XQService)wrappedService);
    }

    private class XQInitContextWrapper
    implements XQInitContext {
        private XQInitContext m_initContext;

        public XQInitContextWrapper(XQInitContext initContext) {
            this.m_initContext = initContext;
        }

        public XQAddressFactory getAddressFactory() {
            return this.m_initContext.getAddressFactory();
        }

        public XQDispatch getDispatcher() {
            return new XQDispatchWrapper(this.m_initContext.getDispatcher());
        }

        public XQEndpointManager getEndpointManager() {
            return new XQEndpointManagerWrapper(this.m_initContext.getEndpointManager());
        }

        public XQEnvelopeFactory getEnvelopeFactory() {
            return this.m_initContext.getEnvelopeFactory();
        }

        public XQLog getLog() {
            return this.m_initContext.getLog();
        }

        public XQMessageFactory getMessageFactory() {
            return this.m_initContext.getMessageFactory();
        }

        public XQParameters getParameters() {
            return this.m_initContext.getParameters();
        }

        public XQLifeCycleManager getLifeCycle() {
            return this.m_initContext.getLifeCycle();
        }

        public ESBInteractorFactory getInteractorFactory() {
            return this.m_initContext.getInteractorFactory();
        }
    }

    private class XQEndpointManagerWrapper
    implements XQEndpointManager {
        private XQEndpointManager m_wrappedEndpointManager;

        public XQEndpointManagerWrapper(XQEndpointManager manager) {
            this.m_wrappedEndpointManager = manager;
        }

        public void releaseTransientEndpoints() {
            this.m_wrappedEndpointManager.releaseTransientEndpoints();
        }

        public XQEndpoint getEndpoint(String name) throws XQEndpointCreationException, XQEndpointNotFoundException {
            return new XQEndpointWrapper(this.m_wrappedEndpointManager.getEndpoint(name));
        }

        public boolean isEndpointConfigured(String name) {
            return this.m_wrappedEndpointManager.isEndpointConfigured(name);
        }

        public boolean isEndpointTransient(String name) {
            return this.m_wrappedEndpointManager.isEndpointTransient(name);
        }

        public boolean isEndpointDefined(String name) {
            return this.m_wrappedEndpointManager.isEndpointDefined(name);
        }

        public void removeEndpoint(String name) throws XQEndpointNotFoundException {
            this.m_wrappedEndpointManager.removeEndpoint(name);
        }

        public IEndpointConfig cloneEndpointConfig(String existingEndpointName, String transientEndpointName) throws XQEndpointNotFoundException {
            return this.m_wrappedEndpointManager.cloneEndpointConfig(existingEndpointName, transientEndpointName);
        }

        public IEndpointConfig cloneEntryEndpointConfig(String newEndpointName) throws XQEndpointNotFoundException {
            return this.m_wrappedEndpointManager.cloneEntryEndpointConfig(newEndpointName);
        }

        public XQEndpoint createTransientEndpoint(IEndpointConfig config) throws XQEndpointCreationException {
            return this.m_wrappedEndpointManager.createTransientEndpoint(config);
        }

        public void registerAsEntryEndpoint(XQEndpoint endpoint, int numListeners) throws XQException {
            XQEndpoint wrapped = endpoint;
            if (endpoint instanceof XQEndpointWrapper) {
                wrapped = ((XQEndpointWrapper)endpoint).m_endpoint;
            }
            this.m_wrappedEndpointManager.registerAsEntryEndpoint(wrapped, numListeners);
        }

        public void unregisterAsEntryEndpoint(XQEndpoint endpoint) throws XQException {
            if (endpoint instanceof XQEndpointWrapper) {
                this.m_wrappedEndpointManager.unregisterAsEntryEndpoint(endpoint);
            }
        }

        public String getEntryEndpoint(XQMessage msg) {
            return this.m_wrappedEndpointManager.getEntryEndpoint(msg);
        }
    }

    private class XQEndpointWrapper
    implements XQEndpoint {
        private XQEndpoint m_endpoint;

        XQEndpointWrapper(XQEndpoint endpoint) {
            this.m_endpoint = endpoint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XQMessage call(XQMessage request, long timeout) throws XQEndpointException, XQEndpointTimeoutException {
            IteratorItem callIter = (IteratorItem)XQServiceChain.this.m_invocations.get(this);
            boolean responsibleForRemove = false;
            if (callIter == null) {
                callIter = new IteratorItem(XQServiceChain.this.m_interceptorServices.listIterator());
                callIter.goToEnd();
                XQServiceChain.this.m_invocations.put(this, callIter);
                responsibleForRemove = true;
            }
            try {
                XQInterceptorService interceptor = (XQInterceptorService)callIter.getCurrentItem();
                if (interceptor == null) {
                    XQMessage xQMessage = this.m_endpoint.call(request, timeout);
                    return xQMessage;
                }
                XQMessage xQMessage = interceptor.call(this, request, timeout);
                return xQMessage;
            }
            finally {
                if (responsibleForRemove) {
                    XQServiceChain.this.m_invocations.remove(this);
                }
            }
        }

        public XQMessage createMessage() throws XQEndpointException {
            return this.m_endpoint.createMessage();
        }

        public String getName() {
            return this.m_endpoint.getName();
        }
    }

    private class XQDispatchWrapper
    implements XQDispatch {
        private XQDispatch m_dispatch;

        XQDispatchWrapper(XQDispatch dispatch) {
            this.m_dispatch = dispatch;
        }

        public void dispatch(XQEnvelope envelope) throws XQDispatchException {
            this.dispatch(envelope, null, false);
        }

        public void dispatch(XQEnvelope envelope, XQQualityofService qos) throws XQDispatchException {
            this.dispatch(envelope, qos, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatch(XQEnvelope envelope, XQQualityofService qos, boolean useQoS) throws XQDispatchException {
            IteratorItem dispatchIter = (IteratorItem)XQServiceChain.this.m_invocations.get(this);
            boolean responsibleForRemove = false;
            if (dispatchIter == null) {
                dispatchIter = new IteratorItem(XQServiceChain.this.m_interceptorServices.listIterator());
                dispatchIter.goToEnd();
                XQServiceChain.this.m_invocations.put(this, dispatchIter);
                responsibleForRemove = true;
            }
            try {
                XQInterceptorService interceptor = (XQInterceptorService)dispatchIter.getCurrentItem();
                if (interceptor == null) {
                    if (useQoS) {
                        this.m_dispatch.dispatch(envelope, qos);
                    } else {
                        this.m_dispatch.dispatch(envelope);
                    }
                    return;
                }
                if (useQoS) {
                    interceptor.dispatch(this, envelope, qos);
                } else {
                    interceptor.dispatch(this, envelope);
                }
            }
            finally {
                if (responsibleForRemove) {
                    XQServiceChain.this.m_invocations.remove(this);
                }
            }
        }
    }

    private class XQInterceptorServiceWrapper
    implements XQInterceptorService {
        private XQInterceptorService m_interceptorService;

        public XQInterceptorServiceWrapper(XQInterceptorService service) {
            this.m_interceptorService = service;
        }

        public void init(XQInitContext initial) throws XQServiceException {
        }

        public void service(XQServiceContext context) throws XQServiceException {
            this.intercept((XQInterceptorServiceContext)context);
        }

        public void destroy() {
        }

        @Override
        public void intercept(XQInterceptorServiceContext context) throws XQServiceException {
            IteratorItem item = (IteratorItem)XQServiceChain.this.m_invocations.get(context);
            item.next();
            try {
                this.m_interceptorService.intercept(context);
            }
            finally {
                item.prev();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch(XQDispatch dispatch, XQEnvelope envelope) throws XQDispatchException {
            IteratorItem item = (IteratorItem)XQServiceChain.this.m_invocations.get(dispatch);
            item.prev();
            try {
                this.m_interceptorService.dispatch(dispatch, envelope);
            }
            finally {
                item.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch(XQDispatch dispatch, XQEnvelope envelope, XQQualityofService qos) throws XQDispatchException {
            IteratorItem item = (IteratorItem)XQServiceChain.this.m_invocations.get(dispatch);
            item.prev();
            try {
                this.m_interceptorService.dispatch(dispatch, envelope, qos);
            }
            finally {
                item.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public XQMessage call(XQEndpoint endpoint, XQMessage request, long timeout) throws XQEndpointException, XQEndpointTimeoutException {
            IteratorItem item = (IteratorItem)XQServiceChain.this.m_invocations.get(endpoint);
            item.prev();
            try {
                XQMessage xQMessage = this.m_interceptorService.call(endpoint, request, timeout);
                return xQMessage;
            }
            finally {
                item.next();
            }
        }

        public void stop() {
        }

        public void start() {
        }
    }

    private class XQServiceContextWrapper
    implements XQInterceptorServiceContext {
        private XQInterceptorServiceContext m_context;

        public XQServiceContextWrapper(XQInterceptorServiceContext context) {
            this.m_context = context;
        }

        @Override
        public XQService getWrappedService() {
            IteratorItem item = (IteratorItem)XQServiceChain.this.m_invocations.get(this);
            return (XQService)item.getCurrentItem();
        }

        public void addFault(XQEnvelope fault) {
            this.m_context.addFault(fault);
        }

        public void addFault(XQMessage fault) {
            this.m_context.addFault(fault);
        }

        public void addOutgoing(XQEnvelope outgoing) {
            this.m_context.addOutgoing(outgoing);
        }

        public void addOutgoing(XQMessage outgoing) {
            this.m_context.addOutgoing(outgoing);
        }

        public void clearFaults() {
            this.m_context.clearFaults();
        }

        public void clearOutgoing() {
            this.m_context.clearOutgoing();
        }

        @Override
        public ListIterator faultboxIterator() {
            return this.m_context.faultboxIterator();
        }

        public XQAccessorFactory getAccessorFactory() {
            return this.m_context.getAccessorFactory();
        }

        public XQAddressFactory getAddressFactory() {
            return this.m_context.getAddressFactory();
        }

        public int getCurrentListener() {
            return this.m_context.getCurrentListener();
        }

        public XQDispatch getDispatcher() {
            XQDispatchWrapper wrappedDispatch = new XQDispatchWrapper(this.m_context.getDispatcher());
            return wrappedDispatch;
        }

        public XQEndpointManager getEndpointManager() {
            return new XQEndpointManagerWrapper(this.m_context.getEndpointManager());
        }

        public String getEntryEndpoint() {
            return this.m_context.getEntryEndpoint();
        }

        public XQEnvelopeFactory getEnvelopeFactory() {
            return this.m_context.getEnvelopeFactory();
        }

        public XQEnvelope getFirstIncoming() {
            return this.m_context.getFirstIncoming();
        }

        public XQLog getLog() {
            return this.m_context.getLog();
        }

        public XQMessageFactory getMessageFactory() {
            return this.m_context.getMessageFactory();
        }

        public XQEnvelope getNextIncoming() {
            return this.m_context.getNextIncoming();
        }

        public XQParameters getParameters() {
            return this.m_context.getParameters();
        }

        public XQProcessContext getProcessContext() {
            return this.m_context.getProcessContext();
        }

        public Connection getCurrentJMSConnection() {
            return this.m_context.getCurrentJMSConnection();
        }

        public Session getCurrentJMSSession() {
            return this.m_context.getCurrentJMSSession();
        }

        public XQQualityofService getQoS() {
            return this.m_context.getQoS();
        }

        public XQAddress getRMEAddress() {
            return this.m_context.getRMEAddress();
        }

        public boolean hasNextIncoming() {
            return this.m_context.hasNextIncoming();
        }

        @Override
        public ListIterator inboxIterator() {
            return this.m_context.inboxIterator();
        }

        @Override
        public ListIterator outboxIterator() {
            return this.m_context.outboxIterator();
        }

        public XQMitigationContext getMitigationContext() {
            return this.m_context.getMitigationContext();
        }

        public XQLifeCycleManager getLifeCycle() {
            return this.m_context.getLifeCycle();
        }

        public XQInvocationContext getInvocationContext() {
            return this.m_context.getInvocationContext();
        }

        public XQAddress getProcessContinuationAddress(XQProcessContinuation continuation) {
            return this.m_context.getProcessContinuationAddress(continuation);
        }

        public ESBInteractorFactory getInteractorFactory() {
            return this.m_context.getInteractorFactory();
        }
    }

    private class IteratorItem {
        private Object m_item;
        private ListIterator<?> m_iter;

        IteratorItem(ListIterator<?> iter) {
            this.m_iter = iter;
            this.m_item = null;
        }

        public Object getCurrentItem() {
            return this.m_item;
        }

        public void next() {
            this.m_item = this.m_iter.hasNext() ? this.m_iter.next() : XQServiceChain.this.m_targetService;
        }

        public void prev() {
            this.m_item = this.m_iter.hasPrevious() ? this.m_iter.previous() : null;
        }

        public void goToEnd() {
            while (this.m_iter.hasNext()) {
                this.next();
            }
            this.prev();
        }
    }
}

