/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.info.INotificationInfo;
import com.sonicsw.mf.common.info.InfoFactory;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xqimpl.config.XQConfigManager;
import java.util.ArrayList;

public class XQServiceNotifications {
    public static final String SERVICE_STARTED = "Started";
    public static final String SERVICE_START_FAILURE = "StartFailure";
    public static final String SERVICE_STOPPED = "Stopped";
    public static final String SERVICE_STOP_FAILURE = "StopFailure";
    public static final String SERVICE_ABORT = "Abort";
    private static final String CATEGORY_SERVICE = "service";
    private final IComponentContext m_componentContext = XQConfigManager.getInstance(null).getComponentContext();
    private XQParameters m_environment;

    public static INotificationInfo[] getNotificationInfos() {
        ArrayList<INotificationInfo> list = new ArrayList<INotificationInfo>();
        list.add(InfoFactory.createNotificationInfo((short)2, (String)CATEGORY_SERVICE, (String)SERVICE_STARTED, (String)"Service started sucessfully."));
        list.add(InfoFactory.createNotificationInfo((short)2, (String)CATEGORY_SERVICE, (String)SERVICE_START_FAILURE, (String)"Service failed to start."));
        list.add(InfoFactory.createNotificationInfo((short)2, (String)CATEGORY_SERVICE, (String)SERVICE_STOPPED, (String)"Service stopped sucessfully."));
        list.add(InfoFactory.createNotificationInfo((short)2, (String)CATEGORY_SERVICE, (String)SERVICE_STOP_FAILURE, (String)"Service failed to stop."));
        list.add(InfoFactory.createNotificationInfo((short)2, (String)CATEGORY_SERVICE, (String)SERVICE_ABORT, (String)"Service abort initiated."));
        return list.toArray(new INotificationInfo[list.size()]);
    }

    public void sendNotification(String event) {
        INotification notification = this.createNotification(event, 0);
        this.m_componentContext.sendNotification(notification);
    }

    public void sendErrorNotification(String event, Throwable excp) {
        INotification notification = this.createNotification(event, 2);
        if (excp != null) {
            notification.setAttribute("Error", (Object)excp.getMessage());
        }
        this.m_componentContext.sendNotification(notification);
    }

    public INotification createNotification(String event, int severityLevel) {
        INotification notification = this.m_componentContext.createNotification((short)2, CATEGORY_SERVICE, event, severityLevel);
        this.setAttributes(notification);
        return notification;
    }

    private void setAttributes(INotification notification) {
        notification.setAttribute("ESBContainer", (Object)this.m_environment.getParameter("SonicXQ.xqContainerName", 1));
        notification.setAttribute("ServiceName", (Object)this.m_environment.getParameter("SonicXQ.ServiceName", 1));
        notification.setAttribute("ServiceType", (Object)this.m_environment.getParameter("SonicXQ.ServiceType", 1));
    }

    public void setEnvironment(XQParameters environment) {
        this.m_environment = environment;
    }
}

