/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.expression.def.el;

import com.sonicsw.esb.expression.def.ExpressionDef;
import com.sonicsw.esb.expression.def.ExpressionDefProcessor;
import com.sonicsw.esb.expression.def.URLReaderExpressionDef;
import com.sonicsw.esb.expression.def.UnsupportedExpressionDef;
import com.sonicsw.esb.expression.def.el.ExpressionDefProcessorBase;
import com.sonicsw.esb.expression.def.el.FunctionDef;

public class URLReaderExpressionDefProcessor
extends ExpressionDefProcessorBase
implements ExpressionDefProcessor {
    private URLReaderExpressionDef m_expressionDef;

    public URLReaderExpressionDefProcessor() {
    }

    public URLReaderExpressionDefProcessor(String remaining) {
        super(remaining);
        this.m_expressionDef = new URLReaderExpressionDef();
    }

    @Override
    public ExpressionDef getExpressionDef(String strExpression, boolean isRValue) {
        if (isRValue) {
            return new UnsupportedExpressionDef("URL reader expressions cannot be R-Values");
        }
        this.m_expressionDef.setRValue(isRValue);
        this.setSource(this.m_remaining);
        return this.m_expressionDef;
    }

    @Override
    public String getStringRepresentation(ExpressionDef expressionDef) {
        String readDynamicFunction;
        String readFunction;
        assert (expressionDef instanceof URLReaderExpressionDef);
        URLReaderExpressionDef urlReaderExpressionDef = (URLReaderExpressionDef)expressionDef;
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("${");
        boolean isByteArray = urlReaderExpressionDef.isByteArray();
        if (isByteArray) {
            readFunction = "xq:readURLAsByteArray";
            readDynamicFunction = "xq:readURLAsByteArrayDynamic";
        } else {
            readFunction = "xq:readURL";
            readDynamicFunction = "xq:readURLDynamic";
        }
        FunctionDef.addFunction(sbuf, urlReaderExpressionDef.isDynamic() ? readDynamicFunction : readFunction, urlReaderExpressionDef.getURL());
        sbuf.append("}");
        return sbuf.toString();
    }

    public void setSource(String source) {
        FunctionDef functionDef = FunctionDef.parse(source);
        String functionName = functionDef.getName();
        this.m_expressionDef.setDynamic(functionName.contains("Dynamic"));
        this.m_expressionDef.setByteArray(functionName.contains("ByteArray"));
        Object[] params = functionDef.getParams();
        this.m_expressionDef.setURL(params[0]);
    }

    public void setFunction(String function) {
    }

    public void setIndex(int index) {
    }
}

