/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.def;

import com.sonicsw.esb.itinerary.def.Common;
import com.sonicsw.esb.itinerary.model.EsbStepNode;
import com.sonicsw.esb.process.caching.CacheReferences;
import com.sonicsw.esb.process.caching.CachingDefinition;
import com.sonicsw.esb.process.model.ProcessModelException;
import com.sonicsw.xqimpl.util.xml.Namespace;
import com.sonicsw.xqimpl.util.xml.XMLUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Caching {
    public static final String CACHING = "caching";
    public static final String CACHE = "cache";
    public static final String NAME = "name";
    public static final String KEY = "key";
    public static final String CONTEXT = "context";
    public static final String KEY_ID = "keyId";

    public static void parse(Element cachingElem, EsbStepNode esbStepNode) {
        CachingDefinition definition = new CachingDefinition();
        Map nsMap = XMLUtils.getNamespaceDefinitions((Element)cachingElem);
        Caching.putNsMapInDefinition(definition, nsMap);
        NodeList childNodes = cachingElem.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!(childNodes.item(i) instanceof Element)) continue;
            Element stepChildElem = (Element)childNodes.item(i);
            String stepChildElemName = stepChildElem.getLocalName();
            if (CACHE.equals(stepChildElemName)) {
                String cacheName = stepChildElem.getAttribute(NAME);
                String keyExpression = stepChildElem.getAttribute(KEY);
                String keyContext = stepChildElem.getAttribute(CONTEXT);
                String keyId = stepChildElem.getAttribute(KEY_ID);
                definition.addCacheReferences(new CacheReferences(cacheName, keyExpression, keyContext, keyId));
                continue;
            }
            throw new ProcessModelException("Invalid process model. Caching element contains unknown child " + stepChildElemName);
        }
        if (definition.isEmpty()) {
            throw new ProcessModelException("Invalid process model. Caching element requires at least one cache child element.");
        }
        esbStepNode.setCachingDefinition(definition);
    }

    public static void parse(XMLStreamReader xsr, EsbStepNode esbStepNode) throws XMLStreamException {
        CachingDefinition definition = new CachingDefinition();
        Map nsMap = XMLUtils.getNamespaceDefinitionsStax((XMLStreamReader)xsr);
        Caching.putNsMapInDefinition(definition, nsMap);
        while (xsr.hasNext()) {
            String stepChildElemName;
            int eventType = xsr.next();
            if (eventType == 1) {
                stepChildElemName = xsr.getLocalName();
                if (CACHE.equals(stepChildElemName)) {
                    String cacheName = xsr.getAttributeValue(null, NAME);
                    String keyExpression = xsr.getAttributeValue(null, KEY);
                    String keyContext = xsr.getAttributeValue(null, CONTEXT);
                    String keyId = xsr.getAttributeValue(null, KEY_ID);
                    definition.addCacheReferences(new CacheReferences(cacheName, keyExpression, keyContext, keyId));
                    continue;
                }
                throw new ProcessModelException("Invalid process model. Caching element contains unknown child " + stepChildElemName);
            }
            if (eventType != 2 || !CACHING.equals(stepChildElemName = xsr.getLocalName())) continue;
            break;
        }
        if (definition.isEmpty()) {
            throw new ProcessModelException("Invalid process model. Caching element requires at least one cache child element.");
        }
        esbStepNode.setCachingDefinition(definition);
    }

    private static void putNsMapInDefinition(CachingDefinition definition, Map<String, Namespace> nsMap) {
        if (null != nsMap) {
            definition.getNamespaceMap().putAll(nsMap);
        }
    }

    public static void serialize(EsbStepNode esbStepNode, Writer writer) throws IOException {
        CachingDefinition definition = esbStepNode.getCachingDefinition();
        if (null != definition) {
            writer.write("<xq:caching");
            XMLUtils.serializeNamespaceDefinitions(definition.getNamespaceMap(), (Writer)writer);
            writer.write(">");
            for (CacheReferences reference : definition.getCaches().values()) {
                writer.write("<xq:cache");
                Common.marshallAttribute(NAME, reference.getCacheName(), writer);
                Common.marshallAttribute(KEY, reference.getKeyExpression(), writer);
                Common.marshallAttribute(CONTEXT, reference.getKeyContext(), writer);
                Common.marshallAttribute(KEY_ID, reference.getKeyId(), writer);
                writer.write("/>");
            }
            Common.marshallCloseElement("xq:caching", writer);
        }
    }
}

