/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.engine;

import com.sonicsw.esb.itinerary.engine.XQProcessInstanceGenerator;
import com.sonicsw.esb.process.engine.ProcessInstanceGenerator;
import com.sonicsw.esb.process.engine.ProcessInstanceGeneratorFactory;

public class XQProcessInstanceGeneratorFactory
implements ProcessInstanceGeneratorFactory {
    private boolean m_staxEnabled = true;
    private String m_generatorClassName;

    @Override
    public void setGeneratorClassName(String name) {
        this.m_generatorClassName = name;
    }

    @Override
    public ProcessInstanceGenerator createProcessInstanceGenerator() {
        ProcessInstanceGenerator procInstGen = null;
        if (this.m_generatorClassName == null) {
            procInstGen = new XQProcessInstanceGenerator();
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> implClass = cl.loadClass(this.m_generatorClassName);
                procInstGen = (ProcessInstanceGenerator)implClass.newInstance();
            }
            catch (Throwable e) {
                throw new RuntimeException("Error creating ProcessInstance Generator for class " + this.m_generatorClassName, e);
            }
        }
        if (procInstGen instanceof XQProcessInstanceGenerator) {
            procInstGen.setStaxEnabled(this.m_staxEnabled);
        }
        return procInstGen;
    }

    public void setStaxEnabled(boolean enableStax) {
        this.m_staxEnabled = enableStax;
    }

    public boolean isStaxEnabled() {
        return this.m_staxEnabled;
    }
}

