/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.itinerary.mapping;

import com.sonicsw.esb.expression.Expression;
import com.sonicsw.esb.expression.ExpressionContext;
import com.sonicsw.esb.expression.ExpressionFactory;
import com.sonicsw.esb.expression.model.InflightPropertiesCollection;
import com.sonicsw.esb.expression.model.XQMessageBulkOperation;
import com.sonicsw.esb.itinerary.mapping.BaseMappingRule;
import com.sonicsw.esb.process.mapping.InputMappingRule;
import com.sonicsw.esb.process.mapping.MappingAction;
import com.sonicsw.esb.process.mapping.MappingContext;
import com.sonicsw.esb.process.mapping.ParameterValue;
import java.util.ArrayList;

public class DefaultInputMappingRule
extends BaseMappingRule
implements InputMappingRule {
    protected String targetParent;
    protected String targetParentEstablished;
    protected ExpressionFactory expFactoryField;

    public DefaultInputMappingRule(ExpressionFactory expFactory, String source, String target, MappingAction action, String[] actionResource) {
        super(expFactory, source, target, action, actionResource);
        this.expFactoryField = expFactory;
        if (target.endsWith(".append}")) {
            this.targetParent = target.substring(0, target.lastIndexOf(".append}")) + "}";
            this.targetParentEstablished = this.targetParent + "Established";
        }
    }

    @Override
    public ParameterValue mapToInput(MappingContext mapCtx) {
        if (s_debugLogEnabled) {
            s_log.logDebug("Executing input mapping rule " + this);
        }
        ExpressionContext exprCtx = (ExpressionContext)mapCtx.getObject(ExpressionContext.class, true);
        Object lhsValue = this.m_sourceExpression.getValue(exprCtx);
        if (this.targetParent != null && mapCtx.getObject(this.targetParentEstablished, false) == null) {
            Expression targetParentExpression;
            Expression expression = targetParentExpression = this.expFactoryField != null ? this.expFactoryField.createExpression(exprCtx, this.targetParent) : null;
            if (null != targetParentExpression) {
                targetParentExpression.setValue(exprCtx, new ArrayList());
            }
            mapCtx.addObject(this.targetParentEstablished, "true");
        }
        if (this.m_isCollection) {
            int count = 0;
            while (lhsValue != null) {
                mapCtx.addObject("sourceCursorIndex", count + "");
                if (s_debugLogEnabled) {
                    s_log.logDebug("Source value for collection element [" + count + "] is " + lhsValue);
                }
                Object modifiedLhsValue = this.m_action.doAction(lhsValue, this.m_actionResources, exprCtx);
                if (s_debugLogEnabled) {
                    s_log.logDebug("Performed action on collection element [" + count + "] and assigning this value to the target expression " + modifiedLhsValue);
                }
                this.m_targetExpression.setValue(exprCtx, modifiedLhsValue);
                lhsValue = this.m_sourceExpression.getValue(exprCtx);
                ++count;
            }
        } else {
            if (s_debugLogEnabled) {
                s_log.logDebug("Found source value " + lhsValue);
            }
            Object modifiedLhsValue = this.m_action.doAction(lhsValue, this.m_actionResources, exprCtx);
            if (s_debugLogEnabled) {
                s_log.logDebug("Performed action and assigning this value to the target expression " + modifiedLhsValue);
            }
            this.m_targetExpression.setValue(exprCtx, modifiedLhsValue);
            if (s_debugLogEnabled) {
                s_log.logDebug("Sccessfully executed input mapping rule");
            }
        }
        mapCtx.removeObject(XQMessageBulkOperation.class);
        mapCtx.removeObject(InflightPropertiesCollection.class);
        return null;
    }
}

