/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.cbr;

import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQInitContext;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQService;
import com.sonicsw.xq.XQServiceContext;
import com.sonicsw.xq.XQServiceException;
import com.sonicsw.xq.service.cbr.CBR;
import com.sonicsw.xq.service.cbr.CBRFactory;
import com.sonicsw.xq.service.xcbr.XCBRService;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.util.ObjectPool;
import com.sonicsw.xqimpl.util.XQFactory;

public class CBRService
implements XQService {
    private ObjectPool m_objectPool = null;
    private XCBRService m_xcbrService = null;

    public void init(XQInitContext initialContext) throws XQServiceException {
        CBRFactory factory = new CBRFactory();
        factory.setInitInfo(initialContext.getParameters(), XQContainer.isCacheEnabled());
        int poolSize = Integer.parseInt(initialContext.getParameters().getParameter("SonicXQ.ConcurrentCalls", 1, "16"));
        poolSize = poolSize == -1 ? 16 : poolSize;
        this.m_objectPool = new ObjectPool((XQFactory)factory, poolSize);
        this.m_xcbrService = new XCBRService();
        this.m_xcbrService.init(initialContext);
    }

    public void destroy() {
        this.m_objectPool = null;
        this.m_xcbrService = null;
    }

    public void service(XQServiceContext ctx) throws XQServiceException {
        CBR cbr = null;
        XQEnvelope env = null;
        if (this.m_xcbrService.isXCBR(ctx)) {
            this.m_xcbrService.service(ctx);
            return;
        }
        if (ctx == null) {
            throw new XQServiceException("Service Context cannot be null.");
        }
        try {
            cbr = (CBR)this.m_objectPool.getInstance(true, "CBR");
            if (cbr != null) {
                XQParameters runtimeParams = ctx.getParameters();
                cbr.setServiceContext(ctx);
                while (ctx.hasNextIncoming()) {
                    env = ctx.getNextIncoming();
                    if (env != null) {
                        cbr.setEnvelope(env);
                        cbr.setMessage(env.getMessage());
                    }
                    cbr.processRules(runtimeParams);
                }
            }
        }
        catch (XQServiceException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new XQServiceException("Error encountered processing content based routing rules: " + t.getMessage(), t);
        }
        finally {
            try {
                if (cbr != null) {
                    cbr.clear();
                    this.m_objectPool.putInstance((Object)cbr);
                }
            }
            catch (Throwable t) {
                throw new XQServiceException("Unable to return the CBR instance to Pool: " + t.getMessage(), t);
            }
        }
    }
}

