/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.configuration.impl;

import com.sonicsw.xq.service.xcbr.RoutingRuleException;
import com.sonicsw.xq.service.xcbr.configuration.RoutingExpressionConfiguration;
import com.sonicsw.xq.service.xcbr.configuration.RoutingListConfiguration;
import com.sonicsw.xq.service.xcbr.configuration.RoutingRuleConfiguration;
import com.sonicsw.xq.service.xcbr.configuration.impl.DistinctRoutingExpressionConfigurationImpl;
import com.sonicsw.xq.service.xcbr.configuration.impl.RoutingExpressionOperatorConfigurationImpl;
import com.sonicsw.xq.service.xcbr.configuration.impl.RoutingListConfigurationImpl;
import com.sonicsw.xq.service.xcbr.schema.DistinctRule;
import com.sonicsw.xq.service.xcbr.schema.Operator;
import com.sonicsw.xq.service.xcbr.schema.RoutingRule;
import java.util.ArrayList;
import java.util.Hashtable;

public class RoutingRuleConfigurationImpl
implements RoutingRuleConfiguration {
    private RoutingRule rule_;
    private RoutingExpressionConfiguration configuration_;
    private RoutingListConfiguration routingList_;

    public RoutingRuleConfigurationImpl(RoutingRule argRule) throws RoutingRuleException {
        try {
            this.rule_ = argRule;
            if (argRule.getRoutingRuleChoice().getDistinctRule() != null) {
                DistinctRule rule = argRule.getRoutingRuleChoice().getDistinctRule();
                int numberOfArguments = rule.getArguments().getArgumentCount();
                Hashtable<String, String> args = new Hashtable<String, String>();
                ArrayList<String> argNames = new ArrayList<String>();
                for (int i = 0; i < numberOfArguments; ++i) {
                    String argumentName = rule.getArguments().getArgument(i).getName();
                    argNames.add(argumentName);
                    String argumentValue = rule.getArguments().getArgument(i).getContent();
                    args.put(argumentName, argumentValue);
                }
                this.configuration_ = new DistinctRoutingExpressionConfigurationImpl(rule.getType(), args, argNames);
            } else if (argRule.getRoutingRuleChoice().getOperator() != null) {
                Operator operator = argRule.getRoutingRuleChoice().getOperator();
                ArrayList<DistinctRule> tests = new ArrayList<DistinctRule>();
                int ruleCount = operator.getDistinctRuleCount();
                for (int i = 0; i < ruleCount; ++i) {
                    DistinctRule rule = operator.getDistinctRule(i);
                    tests.add(rule);
                }
                this.configuration_ = new RoutingExpressionOperatorConfigurationImpl(operator.getType(), tests);
            }
            this.routingList_ = new RoutingListConfigurationImpl(argRule.getDestinations());
        }
        catch (RoutingRuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RoutingRuleException(e);
        }
    }

    @Override
    public String getDescription() throws RoutingRuleException {
        return this.rule_.getDescription();
    }

    @Override
    public RoutingListConfiguration getRoutingList() throws RoutingRuleException {
        return this.routingList_;
    }

    @Override
    public RoutingExpressionConfiguration getRoutingExpression() throws RoutingRuleException {
        return this.configuration_;
    }
}

