/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.routingRules.routingList;

import com.sonicsw.xq.service.xcbr.RoutingRuleException;
import com.sonicsw.xq.service.xcbr.configuration.RoutingDestination;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.RoutingEndpoint;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.impl.BaseRoutingEndpointImpl;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.impl.ESBEndpointByPropertyNameImpl;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.impl.ESBEndpointRoutingEndpointImpl;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.impl.ESBProcessByPropertyNameImpl;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.impl.ESBProcessNullEndpointImpl;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.impl.ESBProcessRoutingEndpoint;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.impl.ESBProcessStepRoutingEndpointImpl;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.impl.ESBServiceByPropertyNameImpl;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.impl.ESBServiceRoutingEndpointImpl;
import com.sonicsw.xq.service.xcbr.routingRules.routingList.impl.ESBStepByPropertyNameImpl;

public class RoutingEndpointFactory {
    public static RoutingEndpoint create(RoutingDestination destination) throws RoutingRuleException {
        BaseRoutingEndpointImpl returnValue = null;
        if (destination.getType().compareToIgnoreCase("Endpoint") == 0) {
            returnValue = new ESBEndpointRoutingEndpointImpl(destination.getName());
        } else if (destination.getType().compareToIgnoreCase("Service") == 0) {
            returnValue = new ESBServiceRoutingEndpointImpl(destination.getName());
        } else if (destination.getType().compareToIgnoreCase("Process") == 0) {
            returnValue = new ESBProcessRoutingEndpoint(destination.getName());
        } else if (destination.getType().compareToIgnoreCase("Step") == 0) {
            returnValue = new ESBProcessStepRoutingEndpointImpl(destination.getName());
        } else if (destination.getType().compareToIgnoreCase("reply_to") == 0) {
            returnValue = new ESBEndpointRoutingEndpointImpl(destination.getName(), true);
        } else if (destination.getType().compareToIgnoreCase("ESBEndpoint") == 0) {
            returnValue = new ESBEndpointRoutingEndpointImpl(destination.getName());
        } else if (destination.getType().compareToIgnoreCase("ESBService") == 0) {
            returnValue = new ESBServiceRoutingEndpointImpl(destination.getName());
        } else if (destination.getType().compareToIgnoreCase("ESBProcess") == 0) {
            returnValue = new ESBProcessRoutingEndpoint(destination.getName());
        } else if (destination.getType().compareToIgnoreCase("ESBStep") == 0) {
            returnValue = new ESBProcessStepRoutingEndpointImpl(destination.getName());
        } else if (destination.getType().compareToIgnoreCase("NULL") == 0) {
            returnValue = new ESBProcessNullEndpointImpl();
        } else if (destination.getType().compareToIgnoreCase("ESBEndpointByPropertyName") == 0) {
            returnValue = new ESBEndpointByPropertyNameImpl(destination.getName());
        } else if (destination.getType().compareToIgnoreCase("ESBServiceByPropertyName") == 0) {
            returnValue = new ESBServiceByPropertyNameImpl(destination.getName());
        } else if (destination.getType().compareToIgnoreCase("ESBProcessByPropertyName") == 0) {
            returnValue = new ESBProcessByPropertyNameImpl(destination.getName());
        } else if (destination.getType().compareToIgnoreCase("ESBStepByPropertyName") == 0) {
            returnValue = new ESBStepByPropertyNameImpl(destination.getName());
        } else {
            throw new RoutingRuleException("Cannot route to destination of type " + destination.getType() + " of name " + destination.getName());
        }
        return returnValue;
    }
}

