/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.endpoint.container;

import com.sonicsw.xq.XQEndpoint;
import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQEndpointNotFoundException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.connector.jms.JMSEndpoint;
import com.sonicsw.xq.connector.jms.messagingbean.MessagingBean;
import com.sonicsw.xqimpl.config.IXQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigManager;
import com.sonicsw.xqimpl.config.XQConfigurationException;
import com.sonicsw.xqimpl.config.XQConnectionConfig;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.endpoint.container.Endpoint;
import com.sonicsw.xqimpl.endpoint.container.EndpointCleaner;
import com.sonicsw.xqimpl.endpoint.container.EndpointContextContainer;
import com.sonicsw.xqimpl.endpoint.container.IEndpointCleanerFuture;
import com.sonicsw.xqimpl.endpoint.container.IEndpointRegistry;
import com.sonicsw.xqimpl.endpoint.container.RefCountableEndpoint;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAConnection;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAConnectionFactory;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAConnectionManager;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.util.EsbClassLoader;
import com.sonicsw.xqimpl.util.XQParametersImpl;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;

public class EndpointManager
extends JCAConnectionManager
implements IEndpointRegistry {
    private static final EndpointManager m_instance = new EndpointManager();
    private static XQLog systemLog = XQLogImpl.getInstance();
    private static XQLog log = XQLogImpl.getCategoryLog((int)512);
    private HashMap<String, localData> m_endpoints;
    private HashMap<String, Object> m_connections;
    private HashMap<String, Integer> m_connectionRefCount;
    private XQConfigManager m_configManager;
    private JCAConnectionFactory m_jcaFactory;
    private Map<String, EndpointRefCount> m_RefCountEndpoints;

    protected EndpointManager() {
        this.initConnections();
        this.m_RefCountEndpoints = new HashMap<String, EndpointRefCount>();
    }

    public static EndpointManager getInstance() {
        return m_instance;
    }

    public static IEndpointRegistry getInvocationEndpointRegistry() {
        return EndpointContextContainer.getInvocationEndpointRegistry();
    }

    public synchronized void releaseResources() {
        EndpointCleaner ec = new EndpointCleaner(new EndpointRemover());
        try {
            ec.cleanEndpoint("Release resources");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (ec.getException() instanceof RuntimeException) {
            throw (RuntimeException)ec.getException();
        }
        this.initConnections();
    }

    private void initConnections() {
        this.m_endpoints = new HashMap();
        this.m_connections = new HashMap();
        this.m_connectionRefCount = new HashMap();
    }

    public void disconnect() {
        for (localData ld : this.m_endpoints.values()) {
            ld.m_endpoint.destroy();
        }
        this.m_connections.clear();
        this.m_connectionRefCount.clear();
    }

    public void init(EsbClassLoader classLoader, XQMessageFactory messageFactory, XQConfigManager xqConfigMgr) {
        this.init(classLoader, messageFactory, (Hashtable)null);
        this.m_configManager = xqConfigMgr;
    }

    public void init(EsbClassLoader classLoader, XQMessageFactory messageFactory, Hashtable props) {
        XQLog log = XQLogImpl.getInstance();
        super.init(log);
        this.m_configManager = XQConfigManager.getInstance((Hashtable)props);
        this.m_jcaFactory = new JCAConnectionFactory((URLClassLoader)classLoader, systemLog, messageFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEndpointDefined(String name) {
        RefCountableEndpoint endpoint = this.retrieveRefEndpoint(name);
        boolean regEndpoint = false;
        HashMap<String, localData> hashMap = this.m_endpoints;
        synchronized (hashMap) {
            regEndpoint = this.m_endpoints.containsKey(name);
        }
        return regEndpoint || endpoint != null;
    }

    public boolean isConnectionDefined(String name) {
        return this.m_connections.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XQEndpoint getEndpoint(String name) throws XQEndpointCreationException {
        Endpoint endpoint = null;
        endpoint = this.retrieveRefEndpoint(name);
        if (endpoint == null) {
            HashMap<String, localData> hashMap = this.m_endpoints;
            synchronized (hashMap) {
                if (!this.isEndpointDefined(name)) {
                    endpoint = this.createEndpoint(name);
                } else {
                    localData data = this.m_endpoints.get(name);
                    endpoint = data.m_endpoint;
                }
            }
        }
        if (log.isDebugLoggingEnabled()) {
            System.out.println("endpoint: " + name + " = " + endpoint);
        }
        return endpoint;
    }

    public Endpoint createEndpoint(String name) throws XQEndpointCreationException {
        Endpoint endpoint = null;
        try {
            if (name != null) {
                XQEndpointConfig xsEndpointCfg = this.m_configManager.lookupEndpointConfig(name);
                endpoint = this.createEndpoint(xsEndpointCfg, false);
            }
        }
        catch (Throwable e) {
            if (e instanceof XQEndpointCreationException) {
                throw (XQEndpointCreationException)e;
            }
            throw new XQEndpointCreationException(e);
        }
        return endpoint;
    }

    public Endpoint createHttpEndpoint(String endpointName, String routingNodeParam) throws XQEndpointCreationException {
        String routingNode = routingNodeParam;
        Endpoint endpoint = null;
        XQEndpointConfig endpointConfig = null;
        XQConnectionConfig conConfig = null;
        try {
            conConfig = XQContainer.getHTTPDefaultConnConfig();
            if (routingNode == null) {
                routingNode = "sonic.http::Q";
            }
            endpointConfig = this.createXQEndpointConfig(endpointName, routingNode.indexOf("::") > -1 ? routingNode : routingNode + "::Q", "QUEUE", conConfig.getName());
            endpoint = this.createEndpoint(endpointConfig, false);
        }
        catch (Throwable e) {
            if (e instanceof XQEndpointCreationException) {
                throw (XQEndpointCreationException)e;
            }
            throw new XQEndpointCreationException(e);
        }
        return endpoint;
    }

    public JMSEndpoint createBusEndpoint(String endpointName, String type) throws XQEndpointCreationException {
        XQEndpointConfig endpointConfig = null;
        XQConnectionConfig conConfig = null;
        try {
            conConfig = XQContainer.getJMSDefaultConnConfig();
            endpointConfig = this.createXQEndpointConfig("BUS-" + type + ":" + endpointName, "BOGUS", type, conConfig.getName());
            return (JMSEndpoint)this.createEndpoint(endpointConfig, false);
        }
        catch (Throwable e) {
            if (e instanceof XQEndpointCreationException) {
                throw (XQEndpointCreationException)e;
            }
            throw new XQEndpointCreationException(e);
        }
    }

    public XQEndpointConfig createXQEndpointConfig(String endpointName, String destinationName, String destinationType, String connectionName) throws XQEndpointCreationException {
        XQEndpointConfig endpointConfig = new XQEndpointConfig((IXQConfigManager)this.m_configManager);
        endpointConfig.setName(endpointName);
        endpointConfig.setEndpointType("JMSType");
        endpointConfig.setConnection(connectionName);
        XQParametersImpl params = new XQParametersImpl();
        if (destinationName != null) {
            params.setParameter("destination", 1, destinationName);
        }
        params.setParameter("type", 1, destinationType);
        endpointConfig.setParameters(params);
        return endpointConfig;
    }

    public Endpoint createEndpoint(XQEndpointConfig xsEndpointCfg, boolean removable, boolean isTmpEP) throws XQEndpointCreationException {
        return this.createEndpoint(xsEndpointCfg, removable, null, null, isTmpEP);
    }

    public Endpoint createEndpoint(XQEndpointConfig xsEndpointCfg, boolean removable) throws XQEndpointCreationException {
        return this.createEndpoint(xsEndpointCfg, removable, false);
    }

    public Endpoint createEndpoint(XQEndpointConfig xsEndpointCfg, boolean removable, XQConnectionConfig connection, Hashtable props, boolean isTmpEP) throws XQEndpointCreationException {
        Endpoint endpoint = this.createEndpointInternal(xsEndpointCfg, removable, connection, props, isTmpEP);
        this.m_endpoints.put(endpoint.getName(), new localData(endpoint, removable));
        return endpoint;
    }

    public Endpoint createEndpoint(XQEndpointConfig xsEndpointCfg, boolean temporary, XQConnectionConfig connection, Hashtable props) throws XQEndpointCreationException {
        Endpoint endpoint = this.createEndpoint(xsEndpointCfg, temporary, connection, props, false);
        return endpoint;
    }

    public Endpoint createUnregisteredEndpoint(XQEndpointConfig xsEndpointCfg, boolean temporary, XQConnectionConfig connection, Hashtable props) throws XQEndpointCreationException {
        Endpoint endpoint = this.createEndpointInternal(xsEndpointCfg, temporary, connection, props);
        return endpoint;
    }

    private Endpoint createEndpointInternal(XQEndpointConfig xsEndpointCfg, boolean temporary, XQConnectionConfig connection, Hashtable props) throws XQEndpointCreationException {
        Endpoint endpoint = this.createEndpointInternal(xsEndpointCfg, temporary, connection, props, false);
        return endpoint;
    }

    private Endpoint createEndpointInternal(XQEndpointConfig xsEndpointCfg, boolean temporary, XQConnectionConfig connection, Hashtable props, boolean isTmpEP) throws XQEndpointCreationException {
        Endpoint endpoint = null;
        String endpointType = xsEndpointCfg.getEndpointType();
        endpoint = endpointType.equals("JMSType") ? this.createJMSEndpoint(xsEndpointCfg, connection, props, isTmpEP) : this.createJCAEndpoint(xsEndpointCfg);
        return endpoint;
    }

    public static XQEndpointConfig createTempEndpointConfig(XQEndpointConfig originalConfig, String epName, String destinationType) throws XQEndpointCreationException {
        XQEndpointConfig endpointConfig;
        if (originalConfig != null) {
            endpointConfig = (XQEndpointConfig)originalConfig.clone();
            XQParametersImpl params = endpointConfig.getParameters();
            String originalEndpointDestinationType = params.getParameter("type", 1, "TOPIC");
            params.setParameter("destination", 1, epName);
            params.setParameter("type", 1, destinationType);
            params.removeParameter("messageSelector", 1);
            if (destinationType.equals("TOPIC")) {
                params.setParameter("sharedSubscriptions", 1, Boolean.FALSE.toString());
            }
            if ("QUEUE".equals(originalEndpointDestinationType)) {
                params.setParameter("durableSubscriberName", 1, epName);
            }
            endpointConfig.setName(epName);
        } else {
            XQConnectionConfig conConfig = XQContainer.getJMSDefaultConnConfig();
            endpointConfig = EndpointManager.getInstance().createXQEndpointConfig(epName, epName, destinationType, conConfig.getName());
            if (destinationType.equals("TOPIC")) {
                endpointConfig.getParameters().setParameter("sharedSubscriptions", 1, Boolean.FALSE.toString());
            }
        }
        return endpointConfig;
    }

    public void removeEndpointIfTemporary(String name) {
        localData data;
        if (this.m_endpoints != null && (data = this.m_endpoints.get(name)) != null && data.m_temporary) {
            this.m_endpoints.remove(name);
        }
    }

    public boolean isEndpointTemporary(String name) {
        localData data;
        if (this.m_endpoints != null && (data = this.m_endpoints.get(name)) != null) {
            return data.m_temporary;
        }
        return false;
    }

    private Endpoint createJMSEndpoint(XQEndpointConfig config, XQConnectionConfig connectionConfig, Hashtable props, boolean isTmpEP) throws XQEndpointCreationException {
        try {
            return new JMSEndpoint(config, this.m_configManager.lookupEndpointTypeConfig(config.getEndpointType()), systemLog, connectionConfig, props, isTmpEP);
        }
        catch (XQConfigurationException ne) {
            throw new XQEndpointCreationException("Bad endpoint configuration: ", (Throwable)ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Endpoint createJCAEndpoint(XQEndpointConfig config) throws XQEndpointCreationException {
        JCAConnection connection = null;
        String connName = config.getConnection();
        HashMap<String, Object> hashMap = this.m_connections;
        synchronized (hashMap) {
            if (!this.m_connections.containsKey(connName)) {
                connection = this.m_jcaFactory.createConnection(config, this);
                this.m_connections.put(connName, connection);
            } else {
                connection = (JCAConnection)this.m_connections.get(connName);
            }
        }
        try {
            return connection.createEndpoint(config, this.m_configManager.lookupEndpointTypeConfig(config.getEndpointType()));
        }
        catch (XQConfigurationException ne) {
            throw new XQEndpointCreationException("Bad endpoint configuration: ", (Throwable)ne);
        }
    }

    public void removeEndpoint(String name) throws XQEndpointNotFoundException {
        if (this.m_endpoints != null) {
            localData data = this.m_endpoints.get(name);
            if (data != null) {
                data.m_endpoint.destroy();
                this.m_endpoints.remove(name);
            } else {
                throw new XQEndpointNotFoundException("Endpoint " + name + " does not exist");
            }
        }
    }

    public boolean addConnection(String name, Object connection) throws Exception {
        boolean success = false;
        if (connection != null && !this.m_connections.containsKey(name)) {
            this.m_connections.put(name, connection);
            this.m_connectionRefCount.put(name, new Integer(1));
            success = true;
        }
        return success;
    }

    public Object getConnection(String name) {
        Object connection = null;
        if (this.m_connections.containsKey(name)) {
            connection = this.m_connections.get(name);
            if (this.m_connectionRefCount.containsKey(name)) {
                this.m_connectionRefCount.put(name, new Integer(this.m_connectionRefCount.get(name) + 1));
            }
        }
        return connection;
    }

    public boolean releaseConnection(String name) {
        boolean success = false;
        if (this.m_connectionRefCount.containsKey(name)) {
            this.m_connectionRefCount.put(name, new Integer(this.m_connectionRefCount.get(name) - 1));
            success = true;
        }
        return success;
    }

    public boolean removeConnection(String name) {
        boolean success = false;
        if (this.m_connectionRefCount.containsKey(name) && this.m_connectionRefCount.get(name) == 0) {
            this.m_connections.remove(name);
            this.m_connectionRefCount.remove(name);
            success = true;
        }
        return success;
    }

    public synchronized void setActionalFlag() {
        for (Map.Entry<String, Object> entry : this.m_connections.entrySet()) {
            MessagingBean msgBean = (MessagingBean)entry.getValue();
            try {
                msgBean.setActionalFlag();
            }
            catch (JMSException e) {
                log.logDebug("Error while setting actional flag on connection " + msgBean.getConnectionBrokerURL());
                log.logDebug((Throwable)e);
            }
        }
    }

    public XQEndpointConfig createEndpointConfig(XQEndpointConfig source, Destination destination, boolean isReplyTo) throws JMSException {
        String type = null;
        String name = null;
        if (destination instanceof Topic) {
            type = "TOPIC";
            name = ((Topic)destination).getTopicName();
        } else {
            type = "QUEUE";
            name = ((Queue)destination).getQueueName();
        }
        XQEndpointConfig originalConfig = source;
        XQEndpointConfig endpointConfig = (XQEndpointConfig)originalConfig.clone();
        XQParametersImpl params = endpointConfig.getParameters();
        params.setParameter("destination", 1, name);
        params.setParameterObject("destinationObject", 3, (Object)destination);
        if (isReplyTo) {
            params.setParameter("TemporaryEndpoint", 1, "true");
        }
        params.setParameter("type", 1, type);
        endpointConfig.setName(name);
        return endpointConfig;
    }

    public XQEndpointConfig createNamedEndpointConfig(String epName, XQEndpointConfig baseConfig, Destination destination) throws JMSException {
        XQEndpointConfig newEPConfig = (XQEndpointConfig)baseConfig.clone();
        XQParametersImpl params = newEPConfig.getParameters();
        String type = null;
        String destName = null;
        if (destination instanceof Topic) {
            type = "TOPIC";
            destName = ((Topic)destination).getTopicName();
        } else {
            type = "QUEUE";
            destName = ((Queue)destination).getQueueName();
        }
        params.setParameterObject("destinationObject", 3, (Object)destination);
        params.setParameter("destination", 1, destName);
        params.setParameter("type", 1, type);
        newEPConfig.setName(epName);
        return newEPConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCountableEndpoint getRefEndpoint(String name, XQEndpointConfig cfg, XQConnectionConfig connection, Hashtable props) throws XQEndpointCreationException {
        RefCountableEndpoint ret = null;
        EndpointRefCount epRef = null;
        Object object = this.m_RefCountEndpoints;
        synchronized (object) {
            epRef = this.m_RefCountEndpoints.get(name);
            if (epRef == null) {
                epRef = new EndpointRefCount(name);
                this.m_RefCountEndpoints.put(name, epRef);
            }
            epRef.increaseCount();
        }
        object = epRef;
        synchronized (object) {
            if (!epRef.isValid()) {
                Endpoint endpoint = this.createEndpointInternal(cfg, false, connection, props);
                ret = new RefCountableEndpoint(endpoint, epRef);
                epRef.setEndpoint(ret);
            } else {
                ret = epRef.getEndpoint();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefCountableEndpoint retrieveRefEndpoint(String name) {
        RefCountableEndpoint ret = null;
        Map<String, EndpointRefCount> map = this.m_RefCountEndpoints;
        synchronized (map) {
            EndpointRefCount epRef = this.m_RefCountEndpoints.get(name);
            if (epRef != null) {
                ret = epRef.getEndpoint();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRefEndpoint(String name) {
        int refcount;
        EndpointRefCount epRef = null;
        Map<String, EndpointRefCount> map = this.m_RefCountEndpoints;
        synchronized (map) {
            epRef = this.m_RefCountEndpoints.get(name);
            if (epRef == null) {
                return;
            }
            refcount = epRef.decreaseCount();
        }
        if (refcount > 0) {
            return;
        }
        map = epRef;
        synchronized (map) {
            refcount = epRef.getCount();
            if (refcount > 0) {
                return;
            }
            epRef.destroy();
            epRef.setEndpoint(null);
        }
        map = this.m_RefCountEndpoints;
        synchronized (map) {
            refcount = epRef.getCount();
            if (refcount <= 0) {
                this.m_RefCountEndpoints.remove(name);
            }
        }
    }

    class EndpointRefCount {
        private String m_name;
        private RefCountableEndpoint m_endpoint = null;
        private boolean m_valid = false;
        private int m_count = 0;

        public EndpointRefCount(String name) {
            this.m_name = name;
        }

        public synchronized int increaseCount() {
            return ++this.m_count;
        }

        public synchronized int decreaseCount() {
            return --this.m_count;
        }

        public int getCount() {
            return this.m_count;
        }

        boolean isValid() {
            return this.m_valid;
        }

        public void setEndpoint(RefCountableEndpoint endpoint) {
            this.m_endpoint = endpoint;
            this.m_valid = endpoint != null;
        }

        public void destroy() {
            this.m_endpoint.destroy();
        }

        public RefCountableEndpoint getEndpoint() {
            if (!this.m_valid) {
                throw new RuntimeException("Attempt to retrieve invalid endpoint");
            }
            return this.m_endpoint;
        }

        public void endpointDestroyed() {
            EndpointManager.this.releaseRefEndpoint(this.m_name);
        }
    }

    class localData {
        protected Endpoint m_endpoint;
        boolean m_temporary;

        public localData(Endpoint endpoint, boolean temporary) {
            this.m_endpoint = endpoint;
            this.m_temporary = temporary;
        }
    }

    private class EndpointRemover
    implements IEndpointCleanerFuture {
        private volatile Endpoint m_currentEndpoint = null;

        private EndpointRemover() {
        }

        @Override
        public Endpoint getCurrentEndpoint() {
            return this.m_currentEndpoint;
        }

        @Override
        public void clean() throws Exception {
            Iterator endpoints = EndpointManager.this.m_endpoints.keySet().iterator();
            while (endpoints.hasNext()) {
                try {
                    String endpointName = (String)endpoints.next();
                    localData ld = (localData)EndpointManager.this.m_endpoints.get(endpointName);
                    this.m_currentEndpoint = ld.m_endpoint;
                    EndpointManager.this.removeEndpoint(endpointName);
                }
                catch (XQEndpointNotFoundException xQEndpointNotFoundException) {
                    // empty catch block
                }
                endpoints = EndpointManager.this.m_endpoints.keySet().iterator();
            }
        }
    }
}

