/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap;

import com.sonicsw.xqimpl.invkimpl.WSInvocationException;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.GeneralWSInvocationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.soap.SOAPException;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeader;
import org.apache.wsif.WSIFException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class HRefUtils {
    public static boolean isMultiRef(Element elem) {
        Node rootAttr = elem.getAttributes().getNamedItemNS("http://schemas.xmlsoap.org/soap/encoding/", "root");
        if (rootAttr == null) {
            return false;
        }
        String rootVal = rootAttr.getNodeValue();
        if (rootVal != null) {
            return "0".equals(rootVal);
        }
        return false;
    }

    public static SOAPEnvelope flattenResponse(SOAPEnvelope envParam) throws WSInvocationException {
        SOAPEnvelope env = envParam;
        if (env == null) {
            return null;
        }
        try {
            SOAPBody body = (SOAPBody)env.getBody();
            DeserializationContext ds = body.getDeserializationContext();
            if (ds.hasElementsByID()) {
                IndexedStack stack = new IndexedStack();
                MessageElement newEl = HRefUtils.flatten((MessageElement)env, ds, stack);
                env = (SOAPEnvelope)newEl;
            }
            return env;
        }
        catch (Exception e) {
            throw new GeneralWSInvocationException(e.getMessage(), null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MessageElement flatten(MessageElement elParam, DeserializationContext ds, IndexedStack stack) throws WSIFException, SOAPException {
        MessageElement el = elParam;
        boolean wasPushed = false;
        if (!el.isRoot()) {
            return null;
        }
        try {
            MessageElement newEl = null;
            if (el.getHref() != null) {
                MessageElement el2 = ds.getElementByID(el.getHref());
                newEl = (MessageElement)el2.cloneNode(false);
                String href = el.getHref();
                if (stack.contains(href)) {
                    throw new GeneralWSInvocationException("cyclic-reference-found", null);
                }
                stack.push(href);
                wasPushed = true;
                newEl.removeAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "root");
                newEl.setName(el.getName());
                newEl.setNamespaceURI(el.getNamespaceURI());
                newEl.setPrefix(el.getPrefix());
                el = el2;
                newEl.setDirty(true);
            } else {
                newEl = (MessageElement)el.cloneNode(false);
                stack.push(stack.EMPTY);
                wasPushed = true;
            }
            Iterator i = el.getChildElements();
            while (i.hasNext()) {
                Object next = i.next();
                if (next instanceof MessageElement) {
                    MessageElement kid = (MessageElement)next;
                    MessageElement child = HRefUtils.flatten(kid, ds, stack);
                    if (child == null) continue;
                    if (newEl instanceof SOAPEnvelope) {
                        SOAPEnvelope soapEnvelope = (SOAPEnvelope)newEl;
                        if (child instanceof SOAPBody) {
                            soapEnvelope.setBody((SOAPBody)child);
                        } else if (child instanceof SOAPHeader) {
                            soapEnvelope.setHeader((SOAPHeader)child);
                        } else {
                            newEl.addChild(child);
                        }
                    } else {
                        newEl.addChild(child);
                    }
                    newEl.setDirty(true);
                    continue;
                }
                newEl.addTextNode(((Text)next).getData());
                newEl.setDirty(true);
            }
            MessageElement messageElement = newEl;
            return messageElement;
        }
        finally {
            if (wasPushed) {
                stack.pop();
            }
        }
    }

    public static Element CreateRPCWrapper(Document doc, String namespace, String name, String encoding) {
        Element element = doc.createElementNS(namespace, name);
        if (encoding != null) {
            element.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "soapenv:encodingStyle", encoding);
        }
        return element;
    }

    static class IndexedStack {
        protected Object EMPTY = new Object();
        private Stack m_stack = new Stack();
        private HashSet m_set = new HashSet();

        IndexedStack() {
        }

        public void push(Object obj) {
            this.m_stack.push(obj);
            this.m_set.add(obj);
        }

        public Object pop() {
            Object result = this.m_stack.pop();
            this.m_set.remove(result);
            return result;
        }

        public boolean contains(Object obj) {
            return this.m_set.contains(obj);
        }
    }
}

