/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap;

import com.sonicsw.esb.ws.invocation.ESBWSCommand;
import com.sonicsw.esb.ws.invocation.ESBWSParameter;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.GeneralWSInvocationException;
import com.sonicsw.xqimpl.script.XMLTypeUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SoapParameters {
    private static final String s_xmlNsNamespace = "http://www.w3.org/2000/xmlns/";
    private static final String s_xsiNamespace = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String s_soapNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String s_soapPrefix = "SONIC_ESB_WS_SOAP";
    private static final String s_xsiPrefix = "SONIC_ESB_WS_XSI";
    private static final String s_defaultHeaderElementPrefix = "SONIC_ESB_WS_HeaderElement";
    private static final String s_defaultHeaderTypePrefix = "SONIC_ESB_WS_HeaderType";
    private ESBWSCommand m_command;
    private Map m_inputNameInfoMap = new HashMap();
    private Map m_outputNameInfoMap = new HashMap();
    private Map m_outputSoapHeaderQNameInfoMap = new HashMap();

    public SoapParameters(ESBWSCommand command) {
        this.m_command = command;
        List list = this.m_command.getParameters();
        for (ESBWSParameter pv : list) {
            ParameterInfo pi = new ParameterInfo();
            pi.m_partName = pv.getName();
            pi.m_displayType = pv.getDisplayType();
            pi.m_isElement = pv.isElement();
            pi.m_targetNamespace = pv.getNamespaceURI();
            pi.m_typeNamespace = pv.getTypeURI();
            pi.m_isSoapHeader = pv.isSoapHeader();
            if (pv.getParameterDirection() == "IN" || pv.getParameterDirection() == "INOUT") {
                this.m_inputNameInfoMap.put(pv.getName(), pi);
            }
            if (pv.getParameterDirection() != "INOUT" && pv.getParameterDirection() != "OUT") continue;
            this.m_outputNameInfoMap.put(pv.getName(), pi);
            if (!pi.m_isSoapHeader) continue;
            this.m_outputSoapHeaderQNameInfoMap.put(this.createQName(pi), pi);
        }
    }

    public Element createElementFromSimple(String paramName, String value, boolean isRPC, Document doc) {
        ParameterInfo pi = (ParameterInfo)this.m_inputNameInfoMap.get(paramName);
        if (pi == null) {
            return null;
        }
        return this.createElementFromType(value, pi, isRPC, doc);
    }

    public Element createElementFromComplexParam(String paramName, Element value, Document doc) throws GeneralWSInvocationException {
        ParameterInfo pi = (ParameterInfo)this.m_inputNameInfoMap.get(paramName);
        if (pi == null) {
            return null;
        }
        if (pi.m_isElement) {
            return this.createParameterFromElement(paramName, value, doc);
        }
        return this.createParameterFromTypeElement(paramName, value, null, doc);
    }

    public Element createElementFromComplexDoc(String paramName, Element value, Document doc) throws GeneralWSInvocationException {
        ParameterInfo pi = (ParameterInfo)this.m_inputNameInfoMap.get(paramName);
        if (pi == null) {
            return null;
        }
        if (pi.m_isElement) {
            return value;
        }
        return this.createParameterFromTypeElement(paramName, value, pi.m_targetNamespace, doc);
    }

    private Element createParameterFromElement(String paramName, Element value, Document doc) {
        ParameterInfo pi = (ParameterInfo)this.m_inputNameInfoMap.get(paramName);
        if (pi == null) {
            return null;
        }
        Element param = doc.createElementNS(null, paramName);
        Node importedElement = doc.importNode(value, true);
        param.appendChild(importedElement);
        return param;
    }

    private Element createParameterFromTypeElement(String paramName, Element value, String namespace, Document doc) {
        ParameterInfo pi = (ParameterInfo)this.m_inputNameInfoMap.get(paramName);
        if (pi == null) {
            return null;
        }
        Element parentElement = value;
        String elementLocalName = parentElement.getLocalName();
        if (elementLocalName == null) {
            elementLocalName = parentElement.getNodeName();
        }
        if (namespace == null && parentElement.getNamespaceURI() != null || namespace != null && !namespace.equals(parentElement.getNamespaceURI()) || !elementLocalName.equals(pi.m_partName)) {
            Element newElement = doc.createElementNS(namespace, pi.m_partName);
            String prefix = XMLTypeUtils.getTypePrefix(pi.m_displayType);
            newElement.setAttributeNS(s_xsiNamespace, "SONIC_ESB_WS_XSI:type", pi.m_displayType);
            newElement.setAttributeNS(s_xmlNsNamespace, "xmlns:SONIC_ESB_WS_XSI", s_xsiNamespace);
            if (prefix != null) {
                newElement.setAttributeNS(s_xmlNsNamespace, "xmlns:" + prefix, pi.m_typeNamespace);
            }
            NamedNodeMap map = parentElement.getAttributes();
            for (int count = 0; count < map.getLength(); ++count) {
                QName attributeQName;
                Node attribute = map.item(count);
                Node importedAttribute = doc.importNode(attribute, true);
                if (importedAttribute.getLocalName() != null && ((attributeQName = new QName(importedAttribute.getNamespaceURI(), importedAttribute.getLocalName())).equals(new QName(s_xsiNamespace, "type")) || attributeQName.equals(new QName(s_xmlNsNamespace, s_xsiPrefix)) || attributeQName.equals(new QName(s_xmlNsNamespace, prefix)) || namespace == null && attributeQName.equals(new QName(null, "xmlns"))) || namespace == null && "xmlns".equals(attribute.getNodeName())) continue;
                newElement.setAttributeNodeNS((Attr)importedAttribute);
            }
            NodeList children = parentElement.getChildNodes();
            for (int count = 0; count < children.getLength(); ++count) {
                Node child = children.item(count);
                Node importedChild = doc.importNode(child, true);
                newElement.appendChild(importedChild);
            }
            return newElement;
        }
        return (Element)doc.importNode(value, true);
    }

    public String getNameFromSoapHeaderOutputQName(QName name) {
        ParameterInfo pi = (ParameterInfo)this.m_outputSoapHeaderQNameInfoMap.get(name);
        if (pi == null) {
            return null;
        }
        return pi.m_partName;
    }

    private QName createQName(ParameterInfo pi) {
        String prefix = XMLTypeUtils.getTypePrefix(pi.m_displayType);
        String localName = XMLTypeUtils.getTypeName(pi.m_displayType);
        if (prefix == null) {
            prefix = s_defaultHeaderTypePrefix;
        }
        if (pi.m_isElement) {
            if (pi.m_typeNamespace != null && pi.m_typeNamespace.length() > 0) {
                return new QName(pi.m_typeNamespace, localName);
            }
            return new QName(null, localName);
        }
        if (pi.m_targetNamespace != null && pi.m_typeNamespace.length() > 0) {
            return new QName(pi.m_targetNamespace, pi.m_partName);
        }
        return new QName(null, pi.m_partName);
    }

    private Element createElementFromType(String value, ParameterInfo pi, boolean isRPC, Document doc) {
        Text textValue = doc.createTextNode(value);
        return this.createElementFromSimpleType(textValue, pi, isRPC, doc);
    }

    private Element createElementFromSimpleType(Node value, ParameterInfo pi, boolean isRPC, Document doc) {
        String prefix = XMLTypeUtils.getTypePrefix(pi.m_displayType);
        String localName = XMLTypeUtils.getTypeName(pi.m_displayType);
        if (prefix == null) {
            prefix = s_defaultHeaderTypePrefix;
        }
        Element element = null;
        if (pi.m_isElement) {
            if (pi.m_typeNamespace != null && pi.m_typeNamespace.length() > 0) {
                element = doc.createElementNS(pi.m_typeNamespace, prefix + ":" + localName);
                element.setAttributeNS(s_xmlNsNamespace, "xmlns:" + prefix, pi.m_typeNamespace);
            } else {
                element = doc.createElementNS(null, localName);
            }
        } else {
            String targetNamespace = pi.m_targetNamespace;
            if (isRPC) {
                targetNamespace = null;
            }
            if (targetNamespace != null && targetNamespace.length() > 0) {
                element = doc.createElementNS(pi.m_targetNamespace, "SONIC_ESB_WS_HeaderElement:" + pi.m_partName);
                element.setAttributeNS(s_xmlNsNamespace, "xmlns:SONIC_ESB_WS_HeaderElement", pi.m_targetNamespace);
            } else {
                element = doc.createElementNS(null, pi.m_partName);
            }
            if (pi.m_typeNamespace != null && pi.m_typeNamespace.length() > 0) {
                element.setAttributeNS(s_xmlNsNamespace, "xmlns:" + prefix, pi.m_typeNamespace);
            }
            element.setAttributeNS(s_xsiNamespace, "SONIC_ESB_WS_XSI:type", pi.m_displayType);
            element.setAttributeNS(s_xmlNsNamespace, "xmlns:SONIC_ESB_WS_XSI", s_xsiNamespace);
        }
        element.appendChild(value);
        if (!isRPC) {
            return element;
        }
        if (pi.m_isElement) {
            Element wrapperElement = doc.createElementNS(null, pi.m_partName);
            wrapperElement.appendChild(element);
            return wrapperElement;
        }
        return element;
    }

    public boolean isOutputParamElement(String paramName) {
        ParameterInfo pi = (ParameterInfo)this.m_outputNameInfoMap.get(paramName);
        if (pi == null) {
            return false;
        }
        return pi.m_isElement;
    }

    private static final class ParameterInfo {
        String m_partName;
        String m_displayType;
        String m_typeNamespace;
        String m_targetNamespace;
        boolean m_isElement;
        boolean m_isSoapHeader;

        private ParameterInfo() {
        }
    }
}

