/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl.wsif.providers.common;

import com.sonicsw.esb.ws.invocation.ESBWSCommand;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.BaseEsbWsifJmsDestination;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.BaseWsifPort;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.GeneralWSInvocationException;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.base.WSIFDefaultOperation;
import org.apache.wsif.providers.WSIFDynamicTypeMap;

public abstract class BaseEsbWsifOperation
extends WSIFDefaultOperation {
    protected Operation m_portTypeOperation;
    protected BindingOperation m_bindingOperation;
    protected Map m_responseMessageParameters;
    protected WSIFDynamicTypeMap m_typeMap;
    protected ESBWSCommand m_scriptCommand = null;
    protected String m_inputEncodingStyle;
    protected String m_inputNamespace;
    protected String m_outputEncodingStyle;
    protected String m_operationStyle;
    protected String m_operationName;
    protected String m_targetNamespace;
    protected boolean m_faultAsSoap;
    protected BaseWsifPort m_wsifPort;
    private static XQLog log = XQLogImpl.getCategoryLog((int)32);

    protected void initializeCall(WSIFMessage context) throws WSIFException {
        this.m_scriptCommand = (ESBWSCommand)context.getObjectPart("ScriptCommand");
        if (this.m_scriptCommand == null) {
            throw new GeneralWSInvocationException("script-command-not-found", null);
        }
        this.m_faultAsSoap = false;
        try {
            Boolean faultAsSoap = (Boolean)context.getObjectPart("com_sonicsw_xqimpl_service_wsinvk_WSInvocationScriptConstants_FAULT_AS_SOAP");
            if (faultAsSoap != null) {
                this.m_faultAsSoap = faultAsSoap;
            }
        }
        catch (WSIFException wSIFException) {
            // empty catch block
        }
        this.m_operationStyle = this.m_scriptCommand.getSOAPInfo().getOperationStyle();
        this.m_inputNamespace = this.m_scriptCommand.getSOAPInfo().getInputNamespace();
        this.m_inputEncodingStyle = this.m_scriptCommand.getSOAPInfo().getInputEncodingStyle();
        this.m_outputEncodingStyle = this.m_scriptCommand.getSOAPInfo().getOutputEncodingStyle();
        this.m_operationName = this.m_scriptCommand.getOperationName();
        this.m_targetNamespace = this.m_scriptCommand.getTargetNamespace();
    }

    public BindingOperation getBindingOperation() {
        return this.m_bindingOperation;
    }

    public String getOperationStyle() {
        return this.m_operationStyle;
    }

    public String getStyle() {
        return this.m_operationStyle;
    }

    public void setPortTypeOperation(Operation portTypeOperation) {
        this.m_portTypeOperation = portTypeOperation;
    }

    public void setResponseMessageParameters(Map responseMessageParameters) {
        this.m_responseMessageParameters = responseMessageParameters;
    }

    public WSIFDynamicTypeMap getTypeMap() {
        return this.m_typeMap;
    }

    public void setTypeMap(WSIFDynamicTypeMap typeMap) {
        this.m_typeMap = typeMap;
    }

    public BaseWsifPort getWsifPort() {
        return this.m_wsifPort;
    }

    public void setWsifPort(BaseWsifPort wsifPort) {
        this.m_wsifPort = wsifPort;
    }

    public BaseEsbWsifOperation(BaseWsifPort wsifPort, Operation portTypeOperation, BindingOperation bindingOperation, WSIFDynamicTypeMap typeMap) {
        this.m_wsifPort = wsifPort;
        this.m_typeMap = typeMap;
        this.m_bindingOperation = bindingOperation;
        this.m_portTypeOperation = portTypeOperation;
        this.m_inputEncodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        this.m_outputEncodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
    }

    public BaseEsbWsifOperation(BaseWsifPort wsifPort, BindingOperation bindingOperation, WSIFDynamicTypeMap typeMap) {
        this(wsifPort, bindingOperation.getOperation(), bindingOperation, typeMap);
    }

    public BaseEsbWsifOperation(BaseWsifPort wsifPort, Operation operation, WSIFDynamicTypeMap typeMap) {
        this(wsifPort, operation, null, typeMap);
    }

    protected List getParts(Message m, List partNames) throws WSIFException {
        ArrayList<Part> al = new ArrayList<Part>();
        List parts = null;
        if (m != null) {
            parts = m.getOrderedParts(null);
        }
        if (log.isDebugLoggingEnabled()) {
            if (partNames != null) {
                for (int j = 0; j < partNames.size(); ++j) {
                    log.logDebug("Message partName=" + partNames.get(j));
                }
            }
            if (parts == null) {
                log.logDebug("Message parts=null");
            } else {
                for (int z = 0; z < parts.size(); ++z) {
                    log.logDebug("Message part=" + ((Part)parts.get(z)).getName());
                }
            }
        }
        if ((parts == null || parts.isEmpty()) && partNames != null && !partNames.isEmpty()) {
            throw new GeneralWSInvocationException("part-not-defined", new Object[]{partNames.get(0), m});
        }
        if (partNames == null) {
            if (parts != null) {
                al.addAll(parts);
            }
        } else {
            for (String partName : partNames) {
                Part p = m.getPart(partName);
                if (p == null) {
                    throw new GeneralWSInvocationException("part-not-found-in-soap-body", new Object[]{partName, m});
                }
                if (al.contains(p)) continue;
                al.add(p);
            }
        }
        return al;
    }

    public Definition getDefinition() {
        return this.m_wsifPort.getDefinition();
    }

    public Operation getOperation() {
        Operation o = this.getPortTypeOperation();
        return o;
    }

    public String getInputEncodingStyle() {
        return this.m_inputEncodingStyle;
    }

    public String getInputNamespace() {
        return this.m_inputNamespace;
    }

    public String getName() {
        return this.m_operationName;
    }

    public String getTargetNamespaceURI() {
        return this.m_targetNamespace;
    }

    protected Part getPart(QName message, String partName) {
        Part p = null;
        Definition def = this.m_wsifPort.getDefinition();
        Message m = def.getMessage(message);
        if (m != null) {
            p = m.getPart(partName);
        }
        return p;
    }

    public Operation getPortTypeOperation() {
        return this.m_portTypeOperation;
    }

    public String getOutputEncodingStyle() {
        return this.m_outputEncodingStyle;
    }

    protected Map getResponseMessageParameters() {
        return this.m_responseMessageParameters;
    }

    public WSIFPort getWSIFPort() {
        return this.m_wsifPort;
    }

    protected final boolean invokeRequestResponseOperation(WSIFMessage inMsg, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        return this.invokeRequestResponseOperation(inMsg, outMsg);
    }

    protected abstract boolean invokeRequestResponseOperation(WSIFMessage var1, WSIFMessage var2) throws WSIFException;

    protected WSIFMessage getContextNoClone() throws WSIFException {
        if (this.context != null) {
            return this.context;
        }
        return this.getContext();
    }

    public void executeInputOnlyOperation(WSIFMessage inMsg) throws WSIFException {
        if (inMsg == null) {
            throw new IllegalArgumentException("Input message is null");
        }
        this.initializeCall(this.getContextNoClone());
        this.invokeRequestResponseOperation(inMsg, null, null);
    }

    public final boolean executeRequestResponseOperation(WSIFMessage inMsg, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        if (inMsg == null) {
            throw new IllegalArgumentException("Input message is null");
        }
        if (outMsg == null) {
            throw new IllegalArgumentException("Output message is null");
        }
        this.close();
        this.initializeCall(this.getContextNoClone());
        boolean succ = this.invokeRequestResponseOperation(inMsg, outMsg, null);
        return succ;
    }

    protected void setFaultFromException(Throwable ex, WSIFMessage faultMsg) {
        if (faultMsg == null) {
            return;
        }
        try {
            if (faultMsg.getName() == null) {
                faultMsg.setName("com.sonicsw.xqimpl.invk.fault");
            }
            faultMsg.setObjectPart("com.sonicsw.xqimpl.invk.faultException", (Object)ex);
            faultMsg.setObjectPart("com.sonicsw.xqimpl.invk.faultReason", (Object)ex.getLocalizedMessage());
            StringWriter writer = new StringWriter();
            ex.printStackTrace(new PrintWriter(writer));
            faultMsg.setObjectPart("com.sonicsw.xqimpl.invk.faultStackTrace", (Object)writer.toString());
        }
        catch (WSIFException e) {
            log.logInformation("Unable to set exception info into faultMessage due to " + e.getLocalizedMessage());
            log.logError(ex);
        }
    }

    protected void setDestinationContext(BaseEsbWsifJmsDestination dest) throws WSIFException {
        if (dest == null) {
            return;
        }
        Map jmsProps = this.createDestinationContext();
        this.setDefaultProps(jmsProps);
        if (jmsProps.size() > 0) {
            dest.setProperties(jmsProps);
        }
    }

    protected abstract void setDefaultProps(Map var1);

    public Map createDestinationContext() throws WSIFException {
        HashMap<String, Object> jmsProps = new HashMap<String, Object>();
        WSIFMessage context = this.getContextNoClone();
        Iterator i = context.getPartNames();
        while (i.hasNext()) {
            String partName = (String)i.next();
            try {
                Object value = context.getObjectPart(partName);
                if (log.isDebugLoggingEnabled()) {
                    log.logDebug("MessageContext propName=" + partName);
                    log.logDebug("MessageContext propVal=" + value);
                }
                jmsProps.put(partName, value);
            }
            catch (WSIFException value) {}
        }
        WSIFMessage portContext = this.getWSIFPort().getContext();
        Iterator i2 = portContext.getPartNames();
        while (i2.hasNext()) {
            String partName = (String)i2.next();
            try {
                Object value = portContext.getObjectPart(partName);
                if (log.isDebugLoggingEnabled()) {
                    log.logDebug("PortContext propName=" + partName);
                    log.logDebug("PortContext propVal=" + value);
                }
                jmsProps.put(partName, value);
            }
            catch (WSIFException wSIFException) {}
        }
        return jmsProps;
    }

    public void propagateInput(WSIFMessage inMsg, String partName, BaseEsbWsifJmsDestination dest, List axisInputs) throws WSIFException {
        Object value;
        try {
            value = inMsg.getObjectPart(partName);
        }
        catch (WSIFException e) {
            value = null;
        }
        if (this.inJmsProps.containsKey(partName) && dest != null) {
            String name = (String)this.inJmsProps.get(partName);
            dest.setProperty(name, value);
        } else {
            axisInputs.add(value);
        }
    }

    protected String calculateDefaultAction() {
        String delimiter;
        String tns = this.m_scriptCommand.getTargetNamespace();
        String wsaNS = this.m_scriptCommand.getWSANamespace();
        boolean isW3CWSA = false;
        if (wsaNS != null) {
            isW3CWSA = AddressingUtils.isW3CAddressingNamespaceURI((String)wsaNS);
        }
        if (tns == null || tns.length() == 0) {
            tns = "urn:unknown";
        }
        if (tns.startsWith("urn:") && isW3CWSA) {
            delimiter = ":";
        } else {
            delimiter = "/";
            if (tns.endsWith("/")) {
                tns = tns.substring(0, tns.length() - 1);
            }
        }
        StringBuilder buff = new StringBuilder();
        buff.append(tns);
        buff.append(delimiter);
        buff.append(this.m_scriptCommand.getPortType().getLocalPart());
        buff.append(delimiter);
        if (this.m_scriptCommand.getCommandType() == 2) {
            buff.append(this.m_scriptCommand.getOperationName());
            buff.append(delimiter);
            buff.append("Fault");
            String faultName = this.m_scriptCommand.getOperationMessageName();
            if (faultName != null) {
                buff.append(delimiter);
                buff.append(faultName);
            }
        } else {
            String opName = this.m_scriptCommand.getOperationMessageName();
            if (opName != null && opName.length() > 0) {
                buff.append(opName);
            } else {
                buff.append(this.m_scriptCommand.getOperationName());
                if (this.m_scriptCommand.getCommandType() == 0) {
                    buff.append("Request");
                } else if (this.m_scriptCommand.getCommandType() == 1) {
                    buff.append("Response");
                }
            }
        }
        return buff.toString();
    }

    public void commonCopy(BaseEsbWsifOperation op) {
        op.m_inputEncodingStyle = this.m_inputEncodingStyle;
        op.m_inputNamespace = this.m_inputNamespace;
        op.m_outputEncodingStyle = this.m_outputEncodingStyle;
        op.m_operationStyle = this.m_operationStyle;
        op.m_operationName = this.m_operationName;
        op.m_targetNamespace = this.m_targetNamespace;
        op.setInputJmsProperties(this.getInputJmsProperties());
        op.setOutputJmsProperties(this.getOutputJmsProperties());
        op.setInputJmsPropertyValues(this.getInputJmsPropertyValues());
    }
}

