/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl.wsif.providers.common;

import com.sonicsw.esb.ws.invocation.ESBWSCommand;
import com.sonicsw.esb.ws.invocation.ESBWSFaultInfo;
import com.sonicsw.xqimpl.invkimpl.WSInvocationException;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.CheckedWSInvocationException;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.GeneralWSInvocationException;
import com.sonicsw.xqimpl.script.XMLTypeUtils;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseExceptionCreator {
    private static String s_xsi1999 = "http://www.w3.org/1999/XMLSchema-instance";
    private static String s_xsi2001 = "http://www.w3.org/2001/XMLSchema-instance";
    private static String s_xmlns = "http://www.w3.org/2000/xmlns/";
    protected ESBWSCommand m_scriptCommand = null;

    public BaseExceptionCreator(ESBWSCommand command) {
        this.m_scriptCommand = command;
    }

    protected WSInvocationException definedByElement(Element element, String msg, boolean isHeaderFault, boolean isChildElement) {
        if (isChildElement) {
            return this.isElementDefined(element, msg, isHeaderFault);
        }
        NodeList list = element.getChildNodes();
        if (list != null) {
            for (int count = 0; count < list.getLength(); ++count) {
                Element childElem;
                WSInvocationException exception;
                Node n = list.item(count);
                if (n.getNodeType() != 1 || (exception = this.isElementDefined(childElem = (Element)n, msg, isHeaderFault)) == null) continue;
                return exception;
            }
        }
        return null;
    }

    private WSInvocationException isElementDefined(Element childElem, String msg, boolean isHeaderFault) {
        String childLocal;
        String childNS = childElem.getNamespaceURI();
        QName name = new QName(childNS, childLocal = childElem.getLocalName());
        ESBWSFaultInfo info = this.m_scriptCommand.getFault(name, isHeaderFault, true);
        if (info != null) {
            return new CheckedWSInvocationException(childElem, msg, null);
        }
        return null;
    }

    private WSInvocationException definedByType(Element detailElement, String msg, boolean isHeaderFault, boolean isChildElement) {
        if (isChildElement) {
            return this.isTypeDefined(detailElement, msg, isHeaderFault);
        }
        NodeList list = detailElement.getChildNodes();
        if (list != null) {
            for (int count = 0; count < list.getLength(); ++count) {
                Element elem;
                WSInvocationException exception;
                Node n = list.item(count);
                if (n.getNodeType() != 1 || (exception = this.isTypeDefined(elem = (Element)n, msg, isHeaderFault)) == null) continue;
                return exception;
            }
        }
        return null;
    }

    private WSInvocationException isTypeDefined(Element elem, String msg, boolean isHeaderFault) {
        String value = this.getTypeAttribute(elem);
        if (value != null) {
            String prefix = XMLTypeUtils.getTypePrefix(value);
            String localName = XMLTypeUtils.getTypeName(value);
            String namespace = null;
            if (prefix == null) {
                namespace = this.getDefaultNamespace(elem);
            } else {
                namespace = this.getNamespace(elem, prefix);
                if (namespace == null) {
                    return new GeneralWSInvocationException("unable-to-evaluate-namespace", new Object[]{prefix});
                }
            }
            QName name = new QName(namespace, localName);
            ESBWSFaultInfo info = this.m_scriptCommand.getFault(name, isHeaderFault, false);
            if (info != null) {
                return new CheckedWSInvocationException(elem, msg, null);
            }
        }
        return null;
    }

    protected WSInvocationException getFaultDefinition(Element element, String msg, boolean isHeaderFault) {
        return this.getFaultDefinition(element, msg, isHeaderFault, false);
    }

    protected WSInvocationException getFaultDefinition(Element element, String msg, boolean isHeaderFault, boolean isChildElement) {
        if (element == null) {
            return null;
        }
        WSInvocationException result = this.definedByType(element, msg, isHeaderFault, isChildElement);
        if (result == null) {
            result = this.definedByElement(element, msg, isHeaderFault, isChildElement);
            return result;
        }
        return result;
    }

    protected Element getElementByTagNameNS(Element elem, String namespaceURI, String localName) {
        NodeList list = elem.getElementsByTagNameNS(namespaceURI, localName);
        if (list == null || list.getLength() < 1) {
            return null;
        }
        return (Element)list.item(0);
    }

    protected Element getElementByTagName(Element elem, String localName) {
        NodeList list = elem.getElementsByTagName(localName);
        if (list == null || list.getLength() < 1) {
            return null;
        }
        return (Element)list.item(0);
    }

    private String getTypeAttribute(Element elem) {
        String value = elem.getAttributeNS(s_xsi2001, "type");
        if (value == null) {
            value = elem.getAttributeNS(s_xsi1999, "type");
        }
        return value;
    }

    private String getDefaultNamespace(Element elem) {
        if (elem == null) {
            return null;
        }
        String namespace = elem.getAttribute("xmlns");
        if (namespace != null && namespace.length() > 0) {
            return namespace;
        }
        Node n = elem.getParentNode();
        if (n.getNodeType() == 1) {
            return this.getDefaultNamespace((Element)n);
        }
        return null;
    }

    private String getNamespace(Element elem, String prefix) {
        if (elem == null) {
            return null;
        }
        String namespace = elem.getAttributeNS(s_xmlns, prefix);
        if (namespace != null && namespace.length() > 0) {
            return namespace;
        }
        Node n = elem.getParentNode();
        if (n.getNodeType() == 1) {
            return this.getNamespace((Element)n, prefix);
        }
        return null;
    }
}

