/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script;

import com.sonicsw.xqimpl.script.ParameterValue;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.script.Util;
import com.sonicsw.xqimpl.script.XMLTypeUtils;
import com.sonicsw.xqimpl.util.DOMUtils;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class StringParameterValue
extends ParameterValue {
    private String m_stringValue;
    private Element m_elementValue = null;
    private boolean m_loadDTDs = false;
    private boolean m_isXML = false;

    public StringParameterValue(String paramName, String value, boolean loadDTDs, String baseType) throws ScriptEngineException {
        super(paramName);
        this.m_stringValue = value == null ? "" : value;
        this.m_loadDTDs = loadDTDs;
        this.m_isXML = XMLTypeUtils.isAnyType(baseType);
    }

    @Override
    public byte[] getAsByteArray() throws ScriptEngineException {
        throw new ScriptEngineException("invalid-string-to-byte-array-conversion", 2);
    }

    @Override
    public String getAsString() {
        return this.m_stringValue;
    }

    @Override
    public Element getAsElement() throws ScriptEngineException {
        if (this.m_elementValue != null) {
            return this.m_elementValue;
        }
        String data = this.getAsString();
        if (data == null || "".equals(data)) {
            return null;
        }
        try {
            DocumentBuilder builder = DOMUtils.getDocumentBuilder((boolean)false, (boolean)this.m_loadDTDs);
            Document doc = builder.parse(new InputSource(new StringReader(data)));
            this.m_elementValue = doc.getDocumentElement();
        }
        catch (Exception e) {
            throw Util.createParserException(e, data);
        }
        return this.m_elementValue;
    }

    @Override
    public boolean isXML() {
        return this.m_isXML;
    }
}

