/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script.wsdl;

import com.sonicsw.esb.ws.invocation.ESBWSFaultInfo;
import com.sonicsw.xqimpl.script.wsdl.WSDLHelperException;
import com.sonicsw.xqimpl.script.wsdl.WSDLServiceHelper;
import com.sonicsw.xqimpl.script.wsdl.WSDLUtils;
import java.util.List;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.xml.namespace.QName;

public class WSDLFaultInfo
implements ESBWSFaultInfo {
    private String m_faultName = null;
    private boolean m_isHeaderFault = true;
    private QName m_faultType = null;
    private String m_typeURI = null;
    private String m_nspaceURI = null;
    private boolean m_isElement = true;
    private String m_baseType = null;
    private String m_faultTypePrefixedName = null;
    private Message m_faultMessage = null;
    private String m_stringForm = null;

    WSDLFaultInfo(WSDLServiceHelper svcHelper, String faultName, Message faultMessage) throws WSDLHelperException {
        this(svcHelper, faultMessage);
        this.m_faultName = faultName;
        this.m_isHeaderFault = false;
    }

    WSDLFaultInfo(WSDLServiceHelper svcHelper, SOAPHeaderFault soapFault, Message faultMessage) throws WSDLHelperException {
        this(svcHelper, faultMessage);
        this.m_nspaceURI = soapFault.getNamespaceURI();
    }

    private WSDLFaultInfo(WSDLServiceHelper svcHelper, Message faultMessage) throws WSDLHelperException {
        if (faultMessage != null) {
            this.m_faultMessage = faultMessage;
            List parts = faultMessage.getOrderedParts(null);
            if (parts != null && !parts.isEmpty()) {
                Part firstPart = (Part)parts.get(0);
                this.m_isElement = firstPart.getElementName() != null;
                this.m_faultType = this.m_isElement ? firstPart.getElementName() : firstPart.getTypeName();
                this.m_typeURI = this.m_faultType.getNamespaceURI();
                this.m_baseType = svcHelper.getPartBaseType(firstPart);
                this.m_faultName = firstPart.getName();
                this.m_faultTypePrefixedName = svcHelper.makePrefixedName(this.m_faultType);
            }
        }
    }

    public WSDLFaultInfo(Message faultMessage, Part part, String baseType, String m_PrefixedName) throws WSDLHelperException {
        if (faultMessage != null) {
            this.m_faultMessage = faultMessage;
            if (part != null) {
                this.m_isElement = part.getElementName() != null;
                QName qName = this.m_faultType = this.m_isElement ? part.getElementName() : part.getTypeName();
                if (this.m_faultType != null) {
                    this.m_typeURI = this.m_faultType.getNamespaceURI();
                }
                this.m_baseType = baseType;
                this.m_faultName = part.getName();
                this.m_faultTypePrefixedName = m_PrefixedName;
                this.m_isHeaderFault = false;
            }
        }
    }

    WSDLFaultInfo(String name, boolean isHeaderFault, String typeName, String typeURI, String nspaceURI, boolean isElement, String baseType) {
        this.m_faultName = name;
        this.m_isHeaderFault = isHeaderFault;
        this.m_faultTypePrefixedName = typeName;
        int ix = typeName.indexOf(":");
        if (ix != -1) {
            String localPart = typeName.substring(ix + 1);
            this.m_faultType = new QName(typeURI, localPart);
        } else {
            this.m_faultType = new QName(typeName);
        }
        this.m_nspaceURI = nspaceURI;
        this.m_typeURI = typeURI;
        this.m_isElement = isElement;
        this.m_baseType = baseType;
    }

    Message getFaultMessage() {
        return this.m_faultMessage;
    }

    @Override
    public String getName() {
        return this.m_faultName;
    }

    @Override
    public QName getType() {
        return this.m_faultType;
    }

    @Override
    public String getNamespaceURI() {
        return this.m_nspaceURI;
    }

    @Override
    public String getTypeNamespaceURI() {
        return this.m_typeURI;
    }

    @Override
    public boolean isHeaderFault() {
        return this.m_isHeaderFault;
    }

    @Override
    public boolean isElement() {
        return this.m_isElement;
    }

    @Override
    public String getBaseType() {
        return this.m_baseType;
    }

    public String getXML() {
        if (this.m_stringForm == null) {
            StringBuilder xml = new StringBuilder();
            xml.append("<fault ");
            xml.append("faultName=\"" + this.m_faultName + "\" ");
            xml.append("type=\"" + this.m_faultTypePrefixedName + "\" ");
            xml.append("isElement=\"" + this.m_isElement + "\" ");
            xml.append("typeURI=\"" + WSDLUtils.encode(this.m_typeURI) + "\" ");
            if (this.m_nspaceURI != null) {
                xml.append("namespaceURI=\"" + WSDLUtils.encode(this.m_nspaceURI) + "\" ");
            }
            if (this.m_baseType != null) {
                xml.append(" baseType=\"" + this.m_baseType + "\"");
            }
            xml.append("/>");
            this.m_stringForm = xml.toString();
        }
        return this.m_stringForm;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WSDLFaultInfo f = (WSDLFaultInfo)obj;
        return this.getXML().equals(f.getXML());
    }

    public int hashCode() {
        return this.getXML().hashCode();
    }
}

