/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script.wsdl;

import com.ibm.wsdl.util.xml.DOM2Writer;
import com.sonicsw.esb.ws.invocation.ESBWSCommand;
import com.sonicsw.esb.ws.invocation.ESBWSFaultInfo;
import com.sonicsw.esb.ws.invocation.ESBWSParameter;
import com.sonicsw.esb.ws.invocation.ESBWSSoapInfo;
import com.sonicsw.esb.ws.rm.IWSReliableInvocation;
import com.sonicsw.xqimpl.script.IParameterValue;
import com.sonicsw.xqimpl.script.ParameterDirection;
import com.sonicsw.xqimpl.script.ScriptEngineException;
import com.sonicsw.xqimpl.script.wsdl.Policy;
import com.sonicsw.xqimpl.script.wsdl.SOAPInfo;
import com.sonicsw.xqimpl.script.wsdl.WSDLFaultInfo;
import com.sonicsw.xqimpl.script.wsdl.WSDLHelperException;
import com.sonicsw.xqimpl.script.wsdl.WSDLParameterInfo;
import com.sonicsw.xqimpl.script.wsdl.WSDLUtils;
import com.sonicsw.xqimpl.script.wsdl.WSInvocationParamValueImpl;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.xml.SaxonEnumerationHolder;
import com.sonicsw.xqimpl.util.xml.XMLUtils;
import com.sonicsw.xqimpl.ws.addressing.AddressingUtils;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpression;
import net.sf.saxon.value.SequenceExtent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WSDLScriptCommand
implements ESBWSCommand,
IWSReliableInvocation,
Cloneable {
    private String m_wsdlLocationURL = null;
    private QName m_serviceQName = null;
    private QName m_bindingQName = null;
    private QName m_portTypeQName = null;
    private String m_operationName = null;
    private List m_parameterList = new ArrayList();
    private String m_portName = null;
    private String m_targetNamespace = null;
    private boolean m_isRequestResponse = false;
    private List m_faultList = new ArrayList();
    private int m_esbwsType = 0;
    private Element m_epr = null;
    private String m_wsaAction = null;
    private String m_operationMsgName = null;
    private String m_wsaNamespace = null;
    private boolean m_wsaNamespaceRetrieved = false;
    private String m_policyXML = null;
    private String m_responsePolicyXML = null;
    private String m_faultPolicyXML = null;
    private SOAPInfo m_soapInfo = new SOAPInfo();
    private boolean m_isSOAPBinding = false;
    private static ArrayList ESBWS_TYPE_NAMES = new ArrayList();
    private static XMLUtils m_xmlUtils;

    public static int getESBWSTypeForName(String name) {
        return ESBWS_TYPE_NAMES.indexOf(name);
    }

    private static String getESBWSNameForType(int type) {
        return (String)ESBWS_TYPE_NAMES.get(type);
    }

    public Object clone() throws CloneNotSupportedException {
        return (WSDLScriptCommand)super.clone();
    }

    public WSDLScriptCommand(Element command) {
        this.deserialize(command);
    }

    public WSDLScriptCommand(String commandXML) throws WSDLHelperException {
        try {
            Element commandEl = DOMUtils.getDocumentBuilder().parse(new InputSource(new StringReader(commandXML))).getDocumentElement();
            if (commandEl.getTagName().equals("scriptCommand")) {
                commandEl = DOMUtils.getImmediateChildElementByName((Element)commandEl, (String)"command");
            }
            this.deserialize(commandEl);
        }
        catch (Exception e) {
            throw new WSDLHelperException(e);
        }
    }

    public WSDLScriptCommand(int invocationType) {
        this.m_esbwsType = invocationType;
    }

    private void deserialize(Element command) {
        Element soapElement;
        Element faultInfoListElem;
        Element paramInfoListElem;
        Element policyElem;
        String namespace;
        Element elem = DOMUtils.getImmediateChildElementByName((Element)command, (String)"esbwsType");
        if (elem != null) {
            this.m_esbwsType = WSDLScriptCommand.getESBWSTypeForName(DOMUtils.getFirstTextChildValue((Element)elem));
        }
        if ((elem = DOMUtils.getImmediateChildElementByName((Element)command, (String)"wsdlLocation")) != null) {
            this.m_wsdlLocationURL = DOMUtils.getFirstTextChildValue((Element)elem);
        }
        if ((elem = DOMUtils.getImmediateChildElementByName((Element)command, (String)"serviceName")) != null) {
            String local_serviceName = elem.getAttribute("local_serviceName");
            namespace = elem.getAttribute("namespace");
            this.m_serviceQName = new QName(namespace, local_serviceName);
        }
        if ((elem = DOMUtils.getImmediateChildElementByName((Element)command, (String)"portName")) != null) {
            this.m_portName = DOMUtils.getFirstTextChildValue((Element)elem);
        }
        if ((elem = DOMUtils.getImmediateChildElementByName((Element)command, (String)"targetNamespace")) != null) {
            this.m_targetNamespace = DOMUtils.getFirstTextChildValue((Element)elem);
        }
        if ((elem = DOMUtils.getImmediateChildElementByName((Element)command, (String)"bindingName")) != null) {
            String local_bindingName = elem.getAttribute("local_bindingName");
            namespace = elem.getAttribute("namespace");
            this.m_bindingQName = new QName(namespace, local_bindingName);
        }
        if ((elem = DOMUtils.getImmediateChildElementByName((Element)command, (String)"portType")) != null) {
            String local_portType = elem.getAttribute("local_portType");
            namespace = elem.getAttribute("namespace");
            this.m_portTypeQName = new QName(namespace, local_portType);
        }
        if ((elem = DOMUtils.getImmediateChildElementByName((Element)command, (String)"operationName")) != null) {
            this.m_operationName = DOMUtils.getFirstTextChildValue((Element)elem);
            this.m_operationMsgName = elem.getAttribute("message");
        }
        if ((elem = DOMUtils.getImmediateChildElementByName((Element)command, (String)"targetNamespace")) != null) {
            this.m_targetNamespace = DOMUtils.getFirstTextChildValue((Element)elem);
        }
        if ((elem = DOMUtils.getImmediateChildElementByName((Element)command, (String)"requestResponse")) != null) {
            this.m_isRequestResponse = Boolean.valueOf(DOMUtils.getFirstTextChildValue((Element)elem));
        }
        if ((elem = DOMUtils.getImmediateChildElementByName((Element)command, (String)"policy")) != null) {
            policyElem = DOMUtils.getFirstChildElement((Element)elem);
            this.m_policyXML = DOM2Writer.nodeToString((Node)policyElem);
        }
        if ((elem = DOMUtils.getImmediateChildElementByName((Element)command, (String)"responsePolicy")) != null) {
            policyElem = DOMUtils.getFirstChildElement((Element)elem);
            this.m_responsePolicyXML = DOM2Writer.nodeToString((Node)policyElem);
        }
        if ((elem = DOMUtils.getImmediateChildElementByName((Element)command, (String)"faultPolicy")) != null) {
            policyElem = DOMUtils.getFirstChildElement((Element)elem);
            this.m_faultPolicyXML = DOM2Writer.nodeToString((Node)policyElem);
        }
        if ((paramInfoListElem = DOMUtils.getImmediateChildElementByName((Element)command, (String)"parameterInfoList")) != null) {
            this.deserializeParameters(paramInfoListElem);
        }
        if ((faultInfoListElem = DOMUtils.getImmediateChildElementByName((Element)command, (String)"faults")) != null) {
            this.deserializeFaults(faultInfoListElem);
        }
        if ((soapElement = DOMUtils.getImmediateChildElementByName((Element)command, (String)"soap")) != null) {
            this.deserializeSOAPProperties(soapElement);
        }
        if ((elem = DOMUtils.getImmediateChildElementByName((Element)command, (String)"endpointReference")) != null) {
            this.m_epr = DOMUtils.getFirstChildElement((Element)elem);
        }
        if ((elem = DOMUtils.getImmediateChildElementByName((Element)command, (String)"wsaAction")) != null) {
            this.m_wsaAction = DOMUtils.getFirstTextChildValue((Element)elem);
        }
    }

    private void deserializeFaults(Element faultInfoListElem) {
        NodeList faultList = faultInfoListElem.getChildNodes();
        for (int i = 0; i < faultList.getLength(); ++i) {
            Node n = faultList.item(i);
            if (!(n instanceof Element) || !n.getLocalName().equals("fault")) continue;
            Element e = (Element)n;
            WSDLFaultInfo inf = new WSDLFaultInfo(e.getAttribute("faultName"), false, e.getAttribute("type"), e.getAttribute("typeURI"), e.getAttribute("namespaceURI"), Boolean.valueOf(e.getAttribute("isElement")), e.getAttribute("baseType"));
            this.m_faultList.add(inf);
        }
    }

    private void deserializeParameters(Element paramInfoListElem) {
        NodeList tempNl = paramInfoListElem.getChildNodes();
        int listSize = tempNl.getLength();
        this.m_parameterList = new ArrayList(listSize);
        for (int i = 0; i < listSize; ++i) {
            Node n = tempNl.item(i);
            if (!(n instanceof Element) || !n.getLocalName().equals("parameterInfo")) continue;
            Element e = (Element)n;
            String name = e.getAttribute("name");
            WSInvocationParamValueImpl iWSParamValue = new WSInvocationParamValueImpl(name);
            boolean isSoapHeader = Boolean.valueOf(e.getAttribute("isSoapHeader"));
            iWSParamValue.setIsSoapHeader(isSoapHeader);
            boolean isElement = Boolean.valueOf(e.getAttribute("isElement"));
            iWSParamValue.setIsElement(isElement);
            String typeNS = e.getAttribute("typeURI");
            iWSParamValue.setTypeURI(typeNS);
            String nspaceURI = e.getAttribute("namespaceURI");
            iWSParamValue.setNamespaceURI(nspaceURI);
            this.m_parameterList.add(iWSParamValue);
        }
    }

    private static void setPropertyFromElement(SOAPInfo info, String propertyName, Element soapElement) {
        Element elem = DOMUtils.getImmediateChildElementByName((Element)soapElement, (String)propertyName);
        if (elem != null) {
            String val = DOMUtils.getFirstTextChildValue((Element)elem);
            info.getProperties().put(propertyName, val == null ? "" : val);
        }
    }

    private void deserializeSOAPProperties(Element soapElement) {
        this.m_soapInfo = new SOAPInfo();
        WSDLScriptCommand.setPropertyFromElement(this.m_soapInfo, "operationStyle", soapElement);
        WSDLScriptCommand.setPropertyFromElement(this.m_soapInfo, "soapActionURI", soapElement);
        WSDLScriptCommand.setPropertyFromElement(this.m_soapInfo, "use", soapElement);
        WSDLScriptCommand.setPropertyFromElement(this.m_soapInfo, "inputNamespace", soapElement);
        WSDLScriptCommand.setPropertyFromElement(this.m_soapInfo, "inputEncodingStyle", soapElement);
        WSDLScriptCommand.setPropertyFromElement(this.m_soapInfo, "outputEncodingStyle", soapElement);
        WSDLScriptCommand.setPropertyFromElement(this.m_soapInfo, "endpoint", soapElement);
        Element faultInfoListElem = DOMUtils.getImmediateChildElementByName((Element)soapElement, (String)"headerFaults");
        if (faultInfoListElem != null) {
            NodeList faultList = faultInfoListElem.getChildNodes();
            for (int i = 0; i < faultList.getLength(); ++i) {
                Node n = faultList.item(i);
                if (!(n instanceof Element) || !n.getLocalName().equals("fault")) continue;
                Element e = (Element)n;
                WSDLFaultInfo inf = new WSDLFaultInfo(e.getAttribute("faultName"), true, e.getAttribute("type"), e.getAttribute("typeURI"), e.getAttribute("namespaceURI"), Boolean.valueOf(e.getAttribute("isElement")), e.getAttribute("baseType"));
                this.m_soapInfo.getHeaderFaults().add(inf);
            }
        }
    }

    public int getESBWSType() {
        return this.m_esbwsType;
    }

    public String getESBWSTypeName() {
        return WSDLScriptCommand.getESBWSNameForType(this.m_esbwsType);
    }

    @Override
    public String getWSDLLocation() {
        return this.m_wsdlLocationURL;
    }

    public void setWSDLLocation(String url) {
        this.m_wsdlLocationURL = url;
    }

    @Override
    public QName getServiceName() {
        return this.m_serviceQName;
    }

    public void setServiceName(QName serviceName) {
        this.m_serviceQName = serviceName;
    }

    @Override
    public String getPortName() {
        return this.m_portName;
    }

    public void setPortName(String portName) {
        this.m_portName = portName;
    }

    @Override
    public QName getBindingName() {
        return this.m_bindingQName;
    }

    public void setBindingName(QName bindingName) {
        this.m_bindingQName = bindingName;
    }

    @Override
    public QName getPortType() {
        return this.m_portTypeQName;
    }

    public void setPortType(QName portTypeName) {
        this.m_portTypeQName = portTypeName;
    }

    @Override
    public String getOperationName() {
        return this.m_operationName;
    }

    public void setOperationName(String opName) {
        this.m_operationName = opName;
    }

    @Override
    public String getOperationMessageName() {
        return this.m_operationMsgName;
    }

    public void setOperationMessageName(String msgName) {
        this.m_operationMsgName = msgName;
    }

    @Override
    public List getParameters() {
        return this.m_parameterList;
    }

    public void setParameterList(List params) {
        this.m_parameterList = params;
    }

    public List getFaultList() {
        return this.m_faultList;
    }

    public void setFaultList(List faults) {
        this.m_faultList = faults;
    }

    @Override
    public String getEffectivePolicy() {
        return this.m_policyXML;
    }

    public void setEffectivePolicy(String policy) {
        this.m_policyXML = policy;
    }

    @Override
    public String getResponsePolicy() {
        return this.m_responsePolicyXML;
    }

    public void setResponsePolicy(String policy) {
        this.m_responsePolicyXML = policy;
    }

    @Override
    public String getFaultPolicy() {
        return this.m_faultPolicyXML;
    }

    public void setFaultPolicy(String policy) {
        this.m_faultPolicyXML = policy;
    }

    public boolean isUsingPolicy() {
        return this.m_policyXML != null || this.m_responsePolicyXML != null || this.m_faultPolicyXML != null;
    }

    @Override
    public boolean isRequestResponse() {
        return this.m_isRequestResponse;
    }

    public void setRequestResponse(boolean flag) {
        this.m_isRequestResponse = flag;
    }

    @Override
    public String getTargetNamespace() {
        return this.m_targetNamespace;
    }

    public void setTargetNamespace(String targetNS) {
        this.m_targetNamespace = targetNS;
    }

    public boolean isSOAPBinding() {
        return this.m_isSOAPBinding;
    }

    public void setIsSOAPBinding(boolean flag) {
        this.m_isSOAPBinding = flag;
    }

    @Override
    public Element getEndpointReference() {
        return this.m_epr;
    }

    public void setEndpointReference(Element epr) {
        this.m_epr = epr;
    }

    @Override
    public String getWSAAction() {
        return this.m_wsaAction;
    }

    public void setWSAAction(String a) {
        this.m_wsaAction = a;
    }

    public void setSOAPInfo(SOAPInfo info) {
        this.m_soapInfo = info;
    }

    public String getOperationStyle() {
        return (String)this.m_soapInfo.getProperty("operationStyle");
    }

    public String getSOAPUse() {
        return (String)this.m_soapInfo.getProperty("use");
    }

    public String getInputNamespace() {
        return (String)this.m_soapInfo.getProperty("inputNamespace");
    }

    public String getSOAPActionURI() {
        return (String)this.m_soapInfo.getProperty("soapActionURI");
    }

    public String getSOAPEndpointURL() {
        return (String)this.m_soapInfo.getProperty("endpoint");
    }

    public void setSOAPEndpointURL(String endpointURL) {
        this.m_soapInfo.setProperty("endpoint", endpointURL);
    }

    public String getInputEncodingStyle() {
        return (String)this.m_soapInfo.getProperty("inputEncodingStyle");
    }

    public String getOutputEncodingStyle() {
        return (String)this.m_soapInfo.getProperty("outputEncodingStyle");
    }

    @Override
    public boolean isReliableMessagingEnabled() {
        return this.isUsingPolicy() && (Policy.hasRMAssertion(this.m_policyXML) || Policy.hasRMAssertion(this.m_responsePolicyXML) || Policy.hasRMAssertion(this.m_faultPolicyXML));
    }

    private static synchronized XMLUtils getXMLUtils() throws Exception {
        boolean cacheEnabled = true;
        if (m_xmlUtils == null) {
            m_xmlUtils = new XMLUtils(cacheEnabled);
        }
        return m_xmlUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getWSANamespace() {
        if (this.m_policyXML != null) {
            if (this.m_wsaNamespaceRetrieved) {
                return this.m_wsaNamespace;
            }
            try {
                XPathExpression expr;
                SequenceExtent v = null;
                XMLUtils utils = WSDLScriptCommand.getXMLUtils();
                XPathExpression xPathExpression = expr = utils.retrieveExpression("//*[local-name()='UsingAddressing']");
                synchronized (xPathExpression) {
                    v = utils.computeXPath(this.m_policyXML, expr);
                    if (v != null && v.getLength() > 0) {
                        SaxonEnumerationHolder xpathResult = new SaxonEnumerationHolder(v);
                        Node node = (Node)xpathResult.getFirst();
                        this.m_wsaNamespace = AddressingUtils.addressingNSFromBindingNS(node.getNamespaceURI());
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.m_wsaNamespaceRetrieved = true;
            }
            return this.m_wsaNamespace;
        }
        return null;
    }

    @Override
    public ESBWSFaultInfo getFault(QName faultName, boolean isHeaderFault, boolean isElement) {
        for (WSDLFaultInfo fault : this.m_faultList) {
            if (!fault.getType().equals(faultName) || fault.isHeaderFault() != isHeaderFault || fault.isElement() != isElement) continue;
            return fault;
        }
        if (this.m_soapInfo != null) {
            for (WSDLFaultInfo fault : this.m_soapInfo.getHeaderFaults()) {
                if (!fault.getType().equals(faultName) || fault.isHeaderFault() != isHeaderFault || fault.isElement() != isElement) continue;
                return fault;
            }
        }
        return null;
    }

    @Override
    public String serialize() {
        QName bindingName;
        String portName;
        StringBuilder xml = new StringBuilder();
        xml.append("<scriptCommand\n");
        xml.append("   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        xml.append("   xmlns:wsis=\"http://www.sonicsw.com/esb/service/invocation\"\n");
        xml.append("   xsi:type=\"wsis:invocationType\">\n");
        xml.append("   <command>\n");
        xml.append("      <wsdlLocation>" + WSDLUtils.encode(this.getWSDLLocation()) + "</" + "wsdlLocation" + ">\n");
        xml.append("      <esbwsType>" + WSDLScriptCommand.getESBWSNameForType(this.m_esbwsType) + "</" + "esbwsType" + ">\n");
        QName svcName = this.getServiceName();
        if (svcName != null) {
            xml.append("      <serviceName local_serviceName=\"" + svcName.getLocalPart());
            xml.append("\" namespace=\"" + WSDLUtils.encode(svcName.getNamespaceURI()) + "\"/>\n");
        }
        if ((portName = this.getPortName()) != null) {
            xml.append("      <portName>" + portName + "</" + "portName" + ">\n");
        }
        if ((bindingName = this.getBindingName()) != null) {
            xml.append("      <bindingName local_bindingName=\"" + bindingName.getLocalPart());
            xml.append("\" namespace=\"" + WSDLUtils.encode(bindingName.getNamespaceURI()) + "\"/>\n");
        }
        QName portTypeName = this.getPortType();
        xml.append("      <portType local_portType=\"" + portTypeName.getLocalPart());
        xml.append("\" namespace=\"" + WSDLUtils.encode(portTypeName.getNamespaceURI()) + "\"/>\n");
        xml.append("      <operationName");
        if (this.m_operationMsgName != null) {
            String opMsgNameAttr = " message=\"" + this.m_operationMsgName + "\"";
            xml.append(opMsgNameAttr);
        }
        xml.append(">" + this.getOperationName() + "</" + "operationName" + ">\n");
        xml.append("      <requestResponse>" + this.isRequestResponse() + "</" + "requestResponse" + ">\n");
        String targetNamespace = this.getTargetNamespace();
        if (targetNamespace != null) {
            xml.append("      <targetNamespace>" + WSDLUtils.encode(targetNamespace) + "</" + "targetNamespace" + ">\n");
        }
        if (this.isSOAPBinding()) {
            this.generateSOAPProperties(xml, "      ");
        }
        this.generateFaultList(xml, "      ");
        StringBuilder params = new StringBuilder();
        StringBuilder paramInfo = new StringBuilder();
        this.generateParameterLists(params, paramInfo);
        xml.append((CharSequence)paramInfo);
        String policy = this.getEffectivePolicy();
        if (policy != null && policy.length() > 0) {
            xml.append("      <policy>\n" + policy + "\n</" + "policy" + ">\n");
        }
        if ((policy = this.getResponsePolicy()) != null && policy.length() > 0) {
            xml.append("      <responsePolicy>\n" + policy + "\n</" + "responsePolicy" + ">\n");
        }
        if ((policy = this.getFaultPolicy()) != null && policy.length() > 0) {
            xml.append("      <faultPolicy>\n" + policy + "\n</" + "faultPolicy" + ">\n");
        }
        if (this.getEndpointReference() != null) {
            String eprXML = DOMUtils.getElementAsString((Element)this.getEndpointReference(), (boolean)false);
            xml.append("      <endpointReference>\n" + eprXML + "\n</" + "endpointReference" + ">\n");
        }
        if (this.getWSAAction() != null) {
            xml.append("      <wsaAction>" + this.getWSAAction() + "</" + "wsaAction" + ">\n");
        }
        xml.append("   </command>\n");
        xml.append((CharSequence)params);
        xml.append("</scriptCommand>\n");
        return xml.toString();
    }

    private void generateParameterLists(StringBuilder paramBuff, StringBuilder paramInfoBuff) {
        paramBuff.append("   <parameterList>\n");
        paramInfoBuff.append("      <parameterInfoList>\n");
        for (ESBWSParameter p : this.m_parameterList) {
            paramBuff.append(this.getParameterXML(p));
            paramInfoBuff.append(this.getParameterInfoXML(p));
        }
        paramBuff.append("   </parameterList>\n");
        paramInfoBuff.append("      </parameterInfoList>\n");
    }

    private void generateSOAPProperties(StringBuilder buff, String prefix) {
        buff.append(prefix + "<" + "soap" + ">\n");
        String[] propNames = new String[]{"soapActionURI", "operationStyle", "use", "inputNamespace", "inputEncodingStyle", "outputEncodingStyle", "endpoint"};
        for (int i = 0; i < propNames.length; ++i) {
            String key = propNames[i];
            Object value = this.m_soapInfo.getProperty(key);
            if (value == null) continue;
            this.generateElement(buff, prefix + "   ", key, value.toString());
        }
        this.generateSOAPHeaderFaultList(buff, prefix + "   ");
        buff.append(prefix + "</" + "soap" + ">\n");
    }

    private void generateSOAPHeaderFaultList(StringBuilder buff, String prefix) {
        if (this.m_soapInfo == null) {
            return;
        }
        List headerFaults = this.m_soapInfo.getHeaderFaults();
        if (!headerFaults.isEmpty()) {
            buff.append(prefix + "<" + "headerFaults" + ">\n");
            Iterator iter = headerFaults.iterator();
            WSDLScriptCommand.appendInfoXML(buff, iter, prefix);
            buff.append(prefix + "</" + "headerFaults" + ">\n");
        }
    }

    private void generateFaultList(StringBuilder buff, String prefix) {
        if (!this.m_faultList.isEmpty()) {
            buff.append(prefix + "<" + "faults" + ">\n");
            Iterator iter = this.m_faultList.iterator();
            WSDLScriptCommand.appendInfoXML(buff, iter, prefix);
            buff.append(prefix + "</" + "faults" + ">\n");
        }
    }

    private static void appendInfoXML(StringBuilder buff, Iterator iter, String prefix) {
        while (iter.hasNext()) {
            WSDLFaultInfo info = (WSDLFaultInfo)iter.next();
            buff.append(prefix + "   " + info.getXML() + "\n");
        }
    }

    private String getParameterXML(ESBWSParameter p) {
        StringBuilder xml = new StringBuilder();
        xml.append("     <parameter name=\"" + p.getName() + "\"");
        xml.append(" direction=\"" + p.getParameterDirection().toString() + "\"");
        xml.append(" displayType=\"" + p.getDisplayType() + "\"");
        xml.append(" baseType=\"" + p.getBaseType() + "\"/>\n");
        return xml.toString();
    }

    private String getParameterInfoXML(ESBWSParameter p) {
        StringBuilder xml = new StringBuilder();
        xml.append("         <parameterInfo");
        xml.append(" name=\"" + p.getName() + "\"");
        xml.append(" isSoapHeader=\"" + p.isSoapHeader() + "\"");
        xml.append(" isElement=\"" + p.isElement() + "\"");
        if (p.getTypeURI() != null) {
            xml.append(" typeURI=\"" + WSDLUtils.encode(p.getTypeURI()) + "\"");
        }
        if (p.getNamespaceURI() != null) {
            xml.append(" namespaceURI=\"" + WSDLUtils.encode(p.getNamespaceURI()) + "\"");
        }
        xml.append("/>\n");
        return xml.toString();
    }

    private void generateElement(StringBuilder buff, String prefix, String tag, String content) {
        if (content != null) {
            buff.append(prefix + "<" + tag + ">" + WSDLUtils.encode(content) + "</" + tag + ">\n");
        }
    }

    @Override
    public int getCommandType() {
        return this.m_esbwsType;
    }

    @Override
    public ESBWSSoapInfo getSOAPInfo() {
        return this.m_soapInfo;
    }

    @Override
    public ESBWSParameter getParameter(String parameterName) {
        for (ESBWSParameter p : this.m_parameterList) {
            if (!p.getName().equals(parameterName)) continue;
            return p;
        }
        return null;
    }

    public void setParameterValues(List parameterValues) throws ScriptEngineException {
        if (parameterValues != null) {
            List scriptCommandParameters = this.getParameters();
            if (scriptCommandParameters == null || parameterValues.size() != scriptCommandParameters.size()) {
                int scriptSize = 0;
                if (scriptCommandParameters != null) {
                    scriptSize = scriptCommandParameters.size();
                }
                throw new ScriptEngineException("parameterinfo-and-parameter-one-to-one-not-maintained", new Object[]{scriptSize + "", parameterValues.size() + ""}, 1);
            }
            Iterator scriptParamIter = scriptCommandParameters.iterator();
            for (IParameterValue paramValue : parameterValues) {
                ESBWSParameter p = (ESBWSParameter)scriptParamIter.next();
                p.setParameterValue(paramValue);
            }
        }
    }

    public void resetParameterValues() throws ScriptEngineException {
        List scriptCommandParameters = this.getParameters();
        for (ESBWSParameter p : scriptCommandParameters) {
            p.setParameterValue(null);
        }
    }

    @Override
    public String getSignature() {
        String inputArgs = this.generateInputArgString();
        String faults = this.generateFaultsString();
        String returnVal = "";
        if ((this.m_isRequestResponse || this.getESBWSType() == 3) && !"".equals(returnVal = this.generateOutputArgString())) {
            returnVal = " returns " + returnVal;
        }
        if (!"".equals(faults)) {
            faults = " faults " + faults;
        }
        return this.m_operationName + " (" + inputArgs + ")" + returnVal + faults;
    }

    private int prettyPrintArgs(ParameterDirection direction, boolean bNameArgs, StringBuilder buff) {
        Iterator iter = this.m_parameterList.iterator();
        int ct = 0;
        while (iter.hasNext()) {
            WSDLParameterInfo param = (WSDLParameterInfo)iter.next();
            if (!param.getDirection().equals(ParameterDirection.INOUT) && !param.getDirection().equals(direction)) continue;
            if (ct++ > 0) {
                buff.append(", ");
            }
            buff.append(param.getDisplayType());
            if (!bNameArgs) continue;
            buff.append(" " + param.getName());
        }
        return ct;
    }

    private String generateInputArgString() {
        StringBuilder buff = new StringBuilder();
        this.prettyPrintArgs(ParameterDirection.IN, true, buff);
        return buff.toString();
    }

    private String generateOutputArgString() {
        StringBuilder buff = new StringBuilder();
        int ct = this.prettyPrintArgs(ParameterDirection.OUT, false, buff);
        if (ct > 1) {
            return "{" + buff.toString() + "}";
        }
        return buff.toString();
    }

    private String generateFaultsString() {
        StringBuilder buff = new StringBuilder();
        Iterator iter = this.m_faultList.iterator();
        if (!this.m_faultList.isEmpty()) {
            buff.append("<");
            while (iter.hasNext()) {
                WSDLFaultInfo info = (WSDLFaultInfo)iter.next();
                buff.append(info.getName());
                if (iter.hasNext()) {
                    buff.append(",");
                }
                buff.append(">");
            }
        }
        return buff.toString();
    }

    static {
        ESBWS_TYPE_NAMES.add("invocation");
        ESBWS_TYPE_NAMES.add("response");
        ESBWS_TYPE_NAMES.add("fault");
        ESBWS_TYPE_NAMES.add("unwrap");
        m_xmlUtils = null;
    }
}

