/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.xqimpl.service.CriticalException;

public class InvalidStateException
extends CriticalException {
    private String m_errorMsg;

    InvalidStateException(String context, String artifactName, boolean isContainer, boolean isAborting) {
        this.m_errorMsg = this.createErrorMessage(context, artifactName, isContainer, isAborting, false);
    }

    InvalidStateException(String context, String artifactName, boolean isContainer, boolean isAborting, boolean isServiceStopped) {
        this.m_errorMsg = this.createErrorMessage(context, artifactName, isContainer, isAborting, isServiceStopped);
    }

    InvalidStateException(String context, String artifactName, String serviceState) {
        this.m_errorMsg = context + " because service `" + artifactName + "` has not started.  Service state is " + serviceState + ".";
    }

    protected final String createErrorMessage(String context, String artifactName, boolean isContainer, boolean isAborting, boolean isServiceStopped) {
        String stopString = !isContainer && isServiceStopped ? " has stopped" : " is stopping";
        String abortString = !isContainer && isServiceStopped ? " has aborted" : " is aborting";
        String artifact = isContainer ? "container" : "service `" + artifactName + "`";
        String operation = isAborting ? abortString : stopString;
        return context + " because " + artifact + operation;
    }

    @Override
    public String getMessage() {
        return this.m_errorMsg;
    }
}

