/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.esb.message.ISOAPEventMessage;
import com.sonicsw.xq.XQAddress;
import com.sonicsw.xq.XQException;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.XQParameters;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xq.XQQualityofService;
import com.sonicsw.xqimpl.endpoint.container.IEndpointRegistry;
import com.sonicsw.xqimpl.service.XQContainer;
import com.sonicsw.xqimpl.util.BodyBuilder;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.SOAPUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SOAPEventMessage
implements ISOAPEventMessage,
BodyBuilder {
    protected static final String HOST_ATTRIBUTE = "host";
    protected static final String CONTAINER_ATTRIBUTE = "container";
    protected static final String SERVICE_ATTRIBUTE = "serviceApplication";
    protected static final String PROCESS_ATTRIBUTE = "process";
    protected static final String TOP_PROCESS_ATTRIBUTE = "topLevelProcess";
    protected static final String STEP_ATTRIBUTE = "step";
    protected static final String ID_ATTRIBUTE = "id";
    protected Element m_bodyElement;
    protected Document m_document;
    protected XQAddress m_address;
    protected XQMessage m_message;
    protected XQMessageFactory m_messageFactory;

    protected SOAPEventMessage(XQAddress address, XQMessageFactory messageFactory) {
        this(address, messageFactory, messageFactory.createMessage());
    }

    SOAPEventMessage(XQAddress address, XQMessageFactory messageFactory, XQMessage message) {
        this.m_address = address;
        this.m_messageFactory = messageFactory;
        this.m_document = DOMUtils.createDocument();
        this.m_message = message;
    }

    protected void buildMessage() throws IOException, IllegalArgumentException {
        StringWriter writer = new StringWriter();
        SOAPUtils.writeSOAPEnvelope((Writer)writer, (BodyBuilder)this);
        try {
            if (this.m_bodyElement == null) {
                throw new IllegalArgumentException("Message body element is null!");
            }
            String tracking_id = this.m_bodyElement.getAttribute(ID_ATTRIBUTE);
            if (tracking_id != null && !"".equals(tracking_id)) {
                this.m_message.setHeaderValue(ID_ATTRIBUTE, (Object)tracking_id);
            }
            XQPart part = this.m_message.createPart((Object)writer.toString(), "text/xml");
            String contentID = this.getContentId();
            if (contentID != null) {
                if (this.m_message.doesPartExist(contentID)) {
                    this.m_message.removePart(contentID);
                }
                part.setContentId(contentID);
            }
            this.m_message.addPartAt(part, 0);
        }
        catch (XQException cte) {
            throw new IllegalArgumentException("XQMessage implementation must support content-type text/xml", cte);
        }
    }

    protected String getContentId() {
        return null;
    }

    public static boolean isSoapEventMsg(XQMessage msg) throws XQMessageException {
        XQPart part;
        if (msg.getPartCount() > 0 && (part = msg.getPart(0)).getContentType().equals("text/xml")) {
            Document doc = msg.getPartAsDocument(0, false);
            Element element = doc.getDocumentElement();
            return SOAPUtils.isSoapEnvelope((Element)element);
        }
        return false;
    }

    public static Element getSoapPart(XQMessage msg) throws XQMessageException {
        Document doc;
        Element element;
        XQPart part;
        if (msg.getPartCount() > 0 && (part = msg.getPart(0)).getContentType().equals("text/xml") && SOAPUtils.isSoapEnvelope((Element)(element = (doc = msg.getPartAsDocument(0, false)).getDocumentElement()))) {
            return element;
        }
        return null;
    }

    protected abstract Element buildBody();

    public XQAddress getTargetAddress() {
        return this.m_address;
    }

    public XQMessage getMessage(boolean buildMsg) throws IllegalArgumentException, IOException {
        if (buildMsg) {
            this.buildMessage();
        }
        return this.m_message;
    }

    @Override
    public void serialize(Writer sink) throws IOException {
        this.writeBody(sink);
    }

    public void writeBody(Writer sink) throws IOException {
        this.m_bodyElement = this.buildBody();
        DOMUtils.serializeNodeToWriter((Node)this.m_bodyElement, (Writer)sink);
    }

    protected static void buildLocation(Element location, XQParameters environment) {
        location.setAttribute(HOST_ATTRIBUTE, XQContainer.getLocation());
        if (environment != null) {
            SOAPEventMessage.setAttribute(location, environment, "SonicXQ.ContainerName", CONTAINER_ATTRIBUTE);
            SOAPEventMessage.setAttribute(location, environment, "SonicXQ.ApplicationName", SERVICE_ATTRIBUTE);
            SOAPEventMessage.setAttribute(location, environment, "SonicXQ.TopLevelProcessName", TOP_PROCESS_ATTRIBUTE);
            SOAPEventMessage.setAttribute(location, environment, "SonicXQ.ProcessName", PROCESS_ATTRIBUTE);
            SOAPEventMessage.setAttribute(location, environment, "SonicXQ.ProcessStep", STEP_ATTRIBUTE);
        }
    }

    private static void setAttribute(Element elem, XQParameters env, String paramName, String attrName) {
        String paramVal = env.getParameter(paramName, 1);
        if (paramVal != null) {
            elem.setAttribute(attrName, paramVal);
        }
    }

    @Override
    public abstract void send(String var1, XQParameters var2, XQQualityofService var3, IEndpointRegistry var4) throws Throwable;
}

