/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service;

import com.sonicsw.xqimpl.service.XQDispatcher;
import java.util.HashMap;

public class XQRegistry {
    private static XQRegistry m_instance = null;
    private HashMap<String, XQDispatcher> m_serviceRegistry = new HashMap();
    private HashMap<String, XQDispatcher> m_endpointRegistry = new HashMap();

    private XQRegistry() {
    }

    public static synchronized XQRegistry instance() {
        if (m_instance == null) {
            m_instance = new XQRegistry();
        }
        return m_instance;
    }

    public XQDispatcher lookupService(String serviceName) {
        return this.m_serviceRegistry.get(serviceName);
    }

    public synchronized void registerService(String serviceName, XQDispatcher dispatcher) {
        this.m_serviceRegistry.put(serviceName, dispatcher);
    }

    public synchronized void unregisterService(String serviceName) {
        this.m_serviceRegistry.remove(serviceName);
    }

    public XQDispatcher lookupEndpoint(String endpointName) {
        return this.m_endpointRegistry.get(endpointName);
    }

    public synchronized void registerEndpoint(String endpointName, XQDispatcher dispatcher) {
        this.m_endpointRegistry.put(endpointName, dispatcher);
    }

    public synchronized void unregisterEndpoint(String endpointName) {
        this.m_endpointRegistry.remove(endpointName);
    }

    public synchronized void unregisterAll() {
        this.m_serviceRegistry.clear();
        this.m_endpointRegistry.clear();
    }
}

