/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.service.debug;

import com.sonicsw.esb.interceptor.XQInterceptorServiceContext;
import com.sonicsw.esb.jeri.esb.ESBPreferredEndpointTracker;
import com.sonicsw.esb.run.Location;
import com.sonicsw.esb.run.RemoteValue;
import com.sonicsw.esb.run.RunContext;
import com.sonicsw.esb.run.RunException;
import com.sonicsw.esb.run.handlers.service.impl.XQServiceContextReference;
import com.sonicsw.esb.run.impl.LocationContext;
import com.sonicsw.esb.run.impl.util.PreferredExporterFactory;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.util.log.XQLogImpl;

public class ServiceContextProcessor {
    private static XQLog s_log = XQLogImpl.getCategoryLog((int)16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processServiceContext(Location location, RunContext testContext, XQInterceptorServiceContext serviceContext) {
        LocationContext locationContext = new LocationContext(location, serviceContext, new PreferredExporterFactory(ESBPreferredEndpointTracker.getInstance(), testContext.getRunID()), testContext);
        try (XQServiceContextReference ref = null;){
            ref = new XQServiceContextReference(locationContext, serviceContext);
            RemoteValue remoteValue = (RemoteValue)ref.getProxy();
            locationContext.setRemoteLocationData(remoteValue);
            testContext.process(locationContext);
        }
        return true;
    }

    private static void handleDisconnect(RunException e) {
        s_log.logError("Disconnect occured while executing a run/debug session.  Cancelling the test.");
        s_log.logDebug((Throwable)e);
    }

    private static void handleTimeout(RunException e) {
        s_log.logError("Timeout occured while executing a run/debug session.  Cancelling the test.");
        s_log.logDebug((Throwable)e);
    }
}

