/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.ws.addressing;

import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.Message;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.util.AddressingUtils;

public class WSAHeaders
extends AddressingHeaders
implements Cloneable {
    protected String m_soapEnvelope;
    protected String m_wsaNamespace;

    public WSAHeaders(String soapEnvelope) throws Exception {
        this((SOAPEnvelope)new Message((Object)soapEnvelope, false).getSOAPEnvelope());
        this.m_soapEnvelope = soapEnvelope;
        this.m_wsaNamespace = this.deriveNamespace((SOAPEnvelope)new Message((Object)soapEnvelope, false).getSOAPEnvelope());
    }

    public WSAHeaders(SOAPEnvelope soapEnvelope) throws Exception {
        super(soapEnvelope, "", true, false, false, true, null);
    }

    public String getSOAPEnvelope() {
        return this.m_soapEnvelope;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.toString());
        }
    }

    public EndpointReference getEffectiveReplyTo() {
        return this.getReplyTo() != null ? this.getReplyTo() : this.getFrom();
    }

    public EndpointReference getEffectiveFaultTo() {
        return this.getFaultTo() != null ? this.getFaultTo() : this.getEffectiveReplyTo();
    }

    public String getWSANamespace() {
        return this.m_wsaNamespace;
    }

    private String deriveNamespace(SOAPEnvelope env) throws Exception {
        SOAPHeader header = env.getHeader();
        if (header == null) {
            return null;
        }
        Iterator iter = header.examineHeaderElements(null);
        while (iter.hasNext()) {
            SOAPHeaderElement headerElement = (SOAPHeaderElement)iter.next();
            Name name = headerElement.getElementName();
            if (!AddressingUtils.isW3CAddressingNamespaceURI((String)name.getURI()) && !AddressingUtils.isAddressingNamespaceURI((String)name.getURI())) continue;
            return name.getURI();
        }
        return "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    }
}

