/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.ws.rm.handlers;

import com.sonicsw.esb.itinerary.engine.ProcessInstanceProps;
import com.sonicsw.esb.itinerary.engine.XQProcessInstance;
import com.sonicsw.esb.ws.rm.IWSEndpointReference;
import com.sonicsw.esb.ws.rm.IWSRMEngine;
import com.sonicsw.esb.ws.rm.IWSRMSequence;
import com.sonicsw.esb.ws.rm.IWSRMSequenceContext;
import com.sonicsw.esb.ws.rm.WSRMException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xqimpl.script.Util;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import com.sonicsw.xqimpl.ws.addressing.WSAHeaders;
import com.sonicsw.xqimpl.ws.addressing.WSEndpointReferenceImpl;
import com.sonicsw.xqimpl.ws.rm.SequenceContext;
import com.sonicsw.xqimpl.ws.rm.WSRMEngineFactory;
import org.apache.axis.types.URI;

public class InboundRMHandler {
    private XQLog log = XQLogImpl.getCategoryLog((int)16384);
    private WSAHeaders m_wsaHeaders;
    private XQMessage m_inboundMessage;
    private IWSRMEngine m_rmEngine = null;
    private boolean m_hasRMState = false;

    public InboundRMHandler(XQMessage msg, XQProcessInstance procInst) throws WSRMException {
        this.m_inboundMessage = msg;
        try {
            this.createWSAHeaders();
            this.createWSRMMap(procInst);
        }
        catch (Exception e) {
            throw new WSRMException((Throwable)e);
        }
    }

    public IWSRMEngine getRMEngine() {
        return this.m_rmEngine;
    }

    public WSAHeaders getWSAHeaders() {
        return this.m_wsaHeaders;
    }

    private void createWSAHeaders() throws Exception {
        boolean isWSA;
        boolean bl = isWSA = this.m_inboundMessage.getHeaderValue("X-HTTP-SOAPVersion") != null;
        if (isWSA) {
            Object contentObj = this.m_inboundMessage.getPart(0).getContent();
            String content = null;
            content = contentObj instanceof byte[] ? Util.createStringFromByteArray((byte[])contentObj, null) : (String)contentObj;
            this.m_wsaHeaders = new WSAHeaders(content);
            this.m_hasRMState = true;
            this.m_inboundMessage.removeHeader("X-HTTP-SOAPVersion");
        }
    }

    private void createWSRMMap(XQProcessInstance procInst) throws WSRMException, XQMessageException {
        String processName = procInst.getProcessDefinition().getProcessName();
        ProcessInstanceProps props = procInst.getProcessInstanceProperties();
        String serializedRMEngine = props.getAllProcessProps().getProperty("SonicESB.RM.SequenceMap");
        if (serializedRMEngine != null) {
            this.m_hasRMState = true;
        }
        Integer sequenceNumber = (Integer)this.m_inboundMessage.getHeaderValue("JMSXGroupSeq");
        this.log.logDebug("InboundRMHandler: sequenceNumber=" + sequenceNumber);
        if (sequenceNumber != null && sequenceNumber > 1) {
            this.log.logDebug("InboundRMHandler: ignoring offered sequence; sequence number=" + sequenceNumber);
            return;
        }
        this.log.logDebug("InboundRMHandler: engine=" + serializedRMEngine);
        this.m_rmEngine = WSRMEngineFactory.create(serializedRMEngine);
        String offerId = (String)this.m_inboundMessage.getHeaderValue("X-WS-ReturnGroupID");
        if (offerId == null) {
            return;
        }
        WSEndpointReferenceImpl sequenceKey = null;
        if (this.m_wsaHeaders == null) {
            try {
                sequenceKey = new WSEndpointReferenceImpl("http://www.sonicxq.com/InboundOfferID-Placeholder");
            }
            catch (URI.MalformedURIException e) {
                throw new WSRMException((Throwable)e);
            }
        } else if (this.m_wsaHeaders.getEffectiveReplyTo() != null) {
            sequenceKey = new WSEndpointReferenceImpl(this.m_wsaHeaders.getEffectiveReplyTo());
        } else {
            throw new WSRMException("No appropriate key available for new inbound sequence");
        }
        this.log.logDebug("Inbound RM Handler: creating sequence with key: " + (Object)((Object)sequenceKey) + " for offerID=" + offerId);
        IWSRMSequence seqCapsule = this.m_rmEngine.createSequence((IWSEndpointReference)sequenceKey, offerId);
        seqCapsule.setSequenceContext((IWSRMSequenceContext)new SequenceContext(processName));
        this.m_hasRMState = true;
    }

    public boolean hasRMState() {
        return this.m_hasRMState;
    }
}

