/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.ws.rm.handlers;

import com.sonicsw.esb.ws.rm.IWSEndpointReference;
import com.sonicsw.esb.ws.rm.IWSRMEngine;
import com.sonicsw.esb.ws.rm.IWSRMSequence;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.ESBWSIFJMSDestination;
import com.sonicsw.xqimpl.util.log.XQLogImpl;
import com.sonicsw.xqimpl.ws.rm.WSRMEngineFactory;
import java.util.Map;

public class OutboundRMHandler {
    private static XQLog log = XQLogImpl.getCategoryLog((int)16384);
    private IWSRMEngine m_rmEngine = null;
    private IWSRMSequence m_seqCapsule = null;

    public OutboundRMHandler(ESBWSIFJMSDestination dest) throws Exception {
        Map rmProps = dest.getRMProps();
        String serializedRMEngine = (String)rmProps.get("SonicESB.RM.SequenceMap");
        this.m_rmEngine = WSRMEngineFactory.create(serializedRMEngine);
        IWSEndpointReference sequenceKey = (IWSEndpointReference)rmProps.get("DESTINATION_EPR");
        log.logDebug("OutboundRMHandler: sequenceKey=" + sequenceKey);
        this.m_seqCapsule = this.m_rmEngine.getSequence(sequenceKey);
        if (this.m_seqCapsule == null) {
            return;
        }
        this.m_seqCapsule = this.m_rmEngine.incrementSequence(this.m_seqCapsule);
        if (log.isDebugLoggingEnabled()) {
            log.logDebug("OutboundRMHandler: Id=" + this.m_seqCapsule.getSequenceID() + " nr=" + this.m_seqCapsule.getSequenceNumber());
            log.logDebug("OutboundRMHandler, rmSeqId=" + this.m_seqCapsule.getSequenceID());
            log.logDebug("OutboundRMHandler, rmSeqNum=" + this.m_seqCapsule.getSequenceNumber());
        }
    }

    public IWSRMSequence getSequence() {
        return this.m_seqCapsule;
    }

    public IWSRMEngine getRMEngine() {
        return this.m_rmEngine;
    }
}

