/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.expr;

import modelobjects.expr.BinaryExpression;
import modelobjects.expr.Expression;
import modelobjects.expr.LiteralExpression;
import modelobjects.expr.PostEvalConverter;
import modelobjects.util.LexerTokenTypes;

class ArithmeticExpression
extends BinaryExpression
implements LexerTokenTypes {
    ArithmeticExpression(int operator, Expression operand1, Expression operand2) {
        super(operator, operand1, operand2);
    }

    @Override
    protected Object eval1(Object rootObject, PostEvalConverter cvtr, int rule) throws Exception {
        Object a = this.operand1.eval(rootObject, cvtr, rule);
        Object b = this.operand2.eval(rootObject, cvtr, rule);
        if (a instanceof Number && b instanceof Number) {
            double valA = ((Number)a).doubleValue();
            double valB = ((Number)b).doubleValue();
            switch (this.operator) {
                case -30: {
                    return LiteralExpression.canonicalize(valA + valB);
                }
                case -31: {
                    return LiteralExpression.canonicalize(valA - valB);
                }
                case -32: {
                    return LiteralExpression.canonicalize(valA * valB);
                }
                case -33: {
                    return LiteralExpression.canonicalize(valA / valB);
                }
                case -57: {
                    return LiteralExpression.canonicalize(valA % valB);
                }
            }
        } else if (this.operator == -30 && (a instanceof String || b instanceof String)) {
            String valA = a == null ? "" : a.toString();
            String valB = b == null ? "" : b.toString();
            return valA + valB;
        }
        throw new RuntimeException("Illegal operands for " + ArithmeticExpression.opName(this.operator) + ": " + a + " and " + b);
    }
}

