/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.expr;

import java.lang.reflect.Array;
import java.util.Vector;
import modelobjects.expr.Expression;
import modelobjects.expr.PostEvalConverter;

class ArrayIndexExpression
extends Expression {
    protected Expression baseExpr;
    protected Expression indexExpr;

    ArrayIndexExpression(Expression baseExpr, Expression indexExpr) {
        this.baseExpr = baseExpr;
        this.indexExpr = indexExpr;
    }

    @Override
    protected Object eval1(Object rootObject, PostEvalConverter cvtr, int rule) throws Exception {
        Object base = this.baseExpr.eval(rootObject, cvtr, rule);
        if (rule == 1) {
            if (!(base instanceof Object[])) {
                throw new RuntimeException("Array index base is not an array");
            }
        } else if (!(base instanceof Object[]) && !(base instanceof Vector)) {
            throw new RuntimeException("Array index base is not an array or Vector");
        }
        Object indexObj = this.indexExpr.eval(rootObject, cvtr, rule);
        if (rule == 1) {
            if (!Integer.class.isInstance(indexObj)) {
                throw new RuntimeException("Array index is not an integer");
            }
        } else if (!Number.class.isInstance(indexObj)) {
            throw new RuntimeException("Array index is not a number");
        }
        int index = ((Number)indexObj).intValue();
        if (base instanceof Vector) {
            return ((Vector)base).elementAt(index);
        }
        return Array.get(base, index);
    }

    public String toString() {
        return "(" + this.baseExpr + "[" + this.indexExpr + "])";
    }
}

