/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.template;

import modelobjects.template.IgnoreLiteralFragment;
import modelobjects.template.TemplateException;
import modelobjects.template.TemplateFragment;
import modelobjects.template.TemplateProcessor;

class LiteralFragment
extends TemplateFragment {
    protected static final String WHITESPACE_CHARS = " \t\n\r";

    LiteralFragment(int startPos, int endPos) {
        super(startPos, endPos);
    }

    @Override
    void processFragment(TemplateProcessor processor) throws TemplateException {
        processor.writeLiteral(this.startPos, this.endPos - this.startPos + 1);
    }

    public String toString() {
        return "<<verbatim " + this.startPos + " .. " + this.endPos + ">>";
    }

    IgnoreLiteralFragment makeIgnoredTrailingWhitespaceFragment(char[] source) {
        int end;
        char c;
        int pos;
        int start = this.getStartPosition();
        for (pos = end = this.getEndPosition(); pos > start && WHITESPACE_CHARS.indexOf(c = source[pos]) != -1; --pos) {
        }
        if (pos < end) {
            this.setEndPosition(pos);
            return new IgnoreLiteralFragment(pos + 1, end);
        }
        return null;
    }
}

