/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.template;

import com.sonicsw.xqimpl.util.ClassUtils;
import java.util.Vector;
import modelobjects.expr.ExprParser;
import modelobjects.template.ElseTagParser;
import modelobjects.template.EndForeachTagParser;
import modelobjects.template.EndIfTagParser;
import modelobjects.template.IgnoreLiteralFragment;
import modelobjects.template.LiteralFragment;
import modelobjects.template.ShortSubstTagParser;
import modelobjects.template.StartForeachTagParser;
import modelobjects.template.StartIfTagParser;
import modelobjects.template.SubstTagParser;
import modelobjects.template.TagParser;
import modelobjects.template.TemplateFragment;
import modelobjects.template.VariableTagParser;

public class TemplateParser {
    public static final String DEFAULT_TOP_LEVEL_ID = "TOP_LEVEL";
    private char[] templateSource;
    private TagParser[] tagParsers;
    private String topLevelId;
    private ExprParser exprParser;

    TemplateParser(char[] templateSource, TagParser[] tagParsers) {
        this(templateSource, tagParsers, DEFAULT_TOP_LEVEL_ID);
    }

    TemplateParser(char[] templateSource, TagParser[] tagParsers, String topLevelId) {
        this.templateSource = ClassUtils.arrayCopy((char[])templateSource);
        this.tagParsers = (TagParser[])ClassUtils.arrayCopy((Object[])tagParsers);
        this.topLevelId = topLevelId;
        this.exprParser = new ExprParser();
        this.exprParser.setPropertyNamesAreCaseSensitive(false);
    }

    public ExprParser getExpressionParser() {
        return this.exprParser;
    }

    public static TemplateFragment[] defaultParseTemplateSource(char[] templateSource) {
        return TemplateParser.defaultParseTemplateSource(templateSource, null, false);
    }

    public static TemplateFragment[] defaultParseTemplateSource(char[] templateSource, Class[] staticMethodClasses, boolean caseSensitive) {
        TagParser[] tagParsers = new TagParser[]{new SubstTagParser(), new ShortSubstTagParser(), new VariableTagParser(), new StartIfTagParser(), new ElseTagParser(), new EndIfTagParser(), new StartForeachTagParser(), new EndForeachTagParser()};
        TemplateParser parser = new TemplateParser(templateSource, tagParsers);
        parser.exprParser.setPropertyNamesAreCaseSensitive(caseSensitive);
        TemplateFragment[] fragments = parser.parse();
        return fragments;
    }

    public TemplateFragment[] parse() {
        char[] source = this.templateSource;
        int sourceLength = this.templateSource.length;
        Vector<TemplateFragment> frags = new Vector<TemplateFragment>();
        int pos = 0;
        while (pos < sourceLength) {
            TemplateFragment specialFrag = this.getNextFragment(pos, source, sourceLength);
            if (specialFrag == null) {
                if (pos >= sourceLength - 1) break;
                LiteralFragment literalFrag = new LiteralFragment(pos, sourceLength - 1);
                frags.addElement(literalFrag);
                break;
            }
            int startPos = specialFrag.getStartPosition();
            int endPos = specialFrag.getEndPosition();
            if (startPos > pos) {
                IgnoreLiteralFragment ignoreFrag;
                LiteralFragment literalFrag = new LiteralFragment(pos, startPos - 1);
                frags.addElement(literalFrag);
                if (specialFrag.ignorePrecedingWhitespace() && (ignoreFrag = literalFrag.makeIgnoredTrailingWhitespaceFragment(source)) != null) {
                    frags.addElement(ignoreFrag);
                }
            }
            frags.addElement(specialFrag);
            pos = endPos + 1;
        }
        int numFrags = frags.size();
        Object[] parsedTemplate = new TemplateFragment[numFrags];
        frags.copyInto(parsedTemplate);
        for (int i = 0; i < numFrags; ++i) {
            ((TemplateFragment)parsedTemplate[i]).postParseAnalyze(source, (TemplateFragment[])parsedTemplate, i);
        }
        return parsedTemplate;
    }

    public String getTopLevelId() {
        return this.topLevelId;
    }

    public char[] getTemplateSource() {
        return this.templateSource;
    }

    public static int lineNumber(char[] source, int position) {
        int result = 1;
        int n = Math.min(source.length, position);
        for (int i = 0; i < n; ++i) {
            if (source[i] != '\n') continue;
            ++result;
        }
        return result;
    }

    private TemplateFragment getNextFragment(int startPos, char[] source, int sourceLength) {
        TagParser[] tagParsers = this.tagParsers;
        int numTagParsers = tagParsers.length;
        int tagPos = TemplateParser.nextTagPos(startPos, source, sourceLength);
        while (tagPos != -1) {
            for (int p = 0; p < numTagParsers; ++p) {
                try {
                    TemplateFragment frag = tagParsers[p].extractFragment(this, tagPos);
                    if (frag == null) continue;
                    return frag;
                }
                catch (RuntimeException rte) {
                    System.err.println("***************************************************");
                    System.err.println("ERROR parsing tag on line " + TemplateParser.lineNumber(source, tagPos) + ": " + rte);
                    break;
                }
            }
            tagPos = TemplateParser.nextTagPos(tagPos + 1, source, sourceLength);
        }
        return null;
    }

    private static int nextTagPos(int startPos, char[] source, int sourceLength) {
        for (int i = startPos; i < sourceLength; ++i) {
            if (source[i] != '<') continue;
            return i;
        }
        return -1;
    }
}

