<?xml version="1.0"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema">

   <xsl:output method="xml"/>

   <xsl:template match="node()">
      <xsl:apply-templates/>
   </xsl:template>

    <!-- Locate the schema element containing the supplied element name. If there is exactly one, -->
    <!-- return it. If not, then the element may have been defined through an import, so if there  -->
    <!-- is only one schema element, just return it.  If there are more than one, we can't make  -->
    <!-- a decision. -->

    <xsl:param name="elementname"></xsl:param>
    <xsl:variable name="selected" select="//xsd:schema[.//xsd:element/@name=$elementname]"></xsl:variable>
    <xsl:variable name="selected_roots" select="//xsd:schema"></xsl:variable>

    <xsl:template match="/">
        <xsl:choose>
            <xsl:when test="count($selected)=1">
                <xsl:for-each select="$selected">
                    <xsl:copy-of select="."/>
                </xsl:for-each>
            </xsl:when>
            <xsl:when test="count($selected_roots)=1">
                <xsl:for-each select="$selected_roots">
                    <xsl:copy-of select="."/>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <xsl:message terminate="yes"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
